/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.barakoa;

import com.bobmowzie.mowziesmobs.server.ai.AvoidProjectilesGoal;
import com.bobmowzie.mowziesmobs.server.ai.NearestAttackableTargetPredicateGoal;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarako;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarakoa;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarakoaVillager;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.MaskType;
import com.bobmowzie.mowziesmobs.server.item.BarakoaMask;
import com.bobmowzie.mowziesmobs.server.potion.EffectHandler;
import com.ilexiconn.llibrary.server.animation.AnimationHandler;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

public class EntityBarakoaya
extends EntityBarakoaVillager {
    public boolean hasTriedOrSucceededTeleport = true;
    private int teleportAttempts = 0;

    public EntityBarakoaya(EntityType<? extends EntityBarakoaVillager> type, World world) {
        super(type, world);
        this.setWeapon(3);
        this.setMask(MaskType.FAITH);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(4, (Goal)new HealTargetGoal(this));
        this.field_70714_bg.func_75776_a(6, (Goal)new AvoidEntityGoal<PlayerEntity>((CreatureEntity)this, PlayerEntity.class, 50.0f, 0.8, 0.6, target -> {
            if (target instanceof PlayerEntity) {
                if (this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL) {
                    return false;
                }
                if (this.func_70638_az() == target) {
                    return true;
                }
                if (this.func_70638_az() instanceof EntityBarako) {
                    return false;
                }
                if (this.getAnimation() != NO_ANIMATION) {
                    return false;
                }
                ItemStack headArmorStack = (ItemStack)((PlayerEntity)target).field_71071_by.field_70460_b.get(3);
                return !(headArmorStack.func_77973_b() instanceof BarakoaMask) || target == this.getMisbehavedPlayer();
            }
            return true;
        }){

            public void func_75251_c() {
                super.func_75251_c();
                EntityBarakoaya.this.setMisbehavedPlayerId(null);
            }
        });
        this.field_70714_bg.func_75776_a(1, (Goal)new TeleportToSafeSpotGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new AvoidProjectilesGoal(this, ProjectileEntity.class, target -> this.getAnimation() == HEAL_LOOP_ANIMATION || this.getAnimation() == HEAL_START_ANIMATION, 3.0f, 0.8, 0.6));
    }

    @Override
    protected void registerTargetGoals() {
        super.registerTargetGoals();
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetPredicateGoal<EntityBarako>((MobEntity)this, EntityBarako.class, 0, false, false, new EntityPredicate().func_221013_a(this.func_233637_b_(Attributes.field_233819_b_) * 2.0).func_221012_a(target -> {
            if (!this.active) {
                return false;
            }
            if (target instanceof MobEntity) {
                return ((MobEntity)target).func_70638_az() != null || target.func_110143_aJ() < target.func_110138_aP();
            }
            return false;
        }).func_221011_b().func_221008_a().func_221009_d().func_221014_c().func_221010_e()){

            public boolean func_75253_b() {
                LivingEntity livingentity = this.field_75299_d.func_70638_az();
                if (livingentity == null) {
                    livingentity = this.field_188509_g;
                }
                boolean targetHasTarget = false;
                if (livingentity instanceof MobEntity) {
                    targetHasTarget = ((MobEntity)livingentity).func_70638_az() != null;
                }
                boolean canHeal = true;
                if (this.field_75299_d instanceof EntityBarakoa) {
                    canHeal = ((EntityBarakoa)this.field_75299_d).canHeal(livingentity);
                }
                return super.func_75253_b() && (livingentity.func_110143_aJ() < livingentity.func_110138_aP() || targetHasTarget) && canHeal;
            }

            protected double func_111175_f() {
                return super.func_111175_f() * 2.0;
            }

            public void func_75249_e() {
                this.field_220779_d.func_221014_c().func_221008_a().func_221011_b().func_221009_d().func_221010_e();
                super.func_75249_e();
            }
        });
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.active && this.teleportAttempts > 3 && (this.func_70638_az() == null || !this.func_70638_az().func_70089_S())) {
            this.hasTriedOrSucceededTeleport = true;
        }
        if (this.getAnimation() == HEAL_LOOP_ANIMATION && !this.canHeal(this.func_70638_az())) {
            AnimationHandler.INSTANCE.sendAnimationMessage(this, HEAL_STOP_ANIMATION);
        }
    }

    @Override
    protected void updateAttackAI() {
    }

    @Override
    public boolean canHeal(LivingEntity entity) {
        return entity instanceof EntityBarako;
    }

    @Override
    protected void sunBlockTarget() {
        LivingEntity target = this.func_70638_az();
        if (target != null) {
            EffectHandler.addOrCombineEffect(target, EffectHandler.SUNBLOCK, 20, 0, true, false);
            if (target.field_70173_aa % 20 == 0) {
                target.func_70691_i(0.15f);
            }
        }
    }

    public boolean func_180431_b(DamageSource source) {
        boolean teleporting = this.getAnimation() == TELEPORT_ANIMATION && this.getAnimationTick() <= 16;
        return super.func_180431_b(source) || (!this.active || teleporting || !this.hasTriedOrSucceededTeleport) && source != DamageSource.field_76380_i;
    }

    public void func_70015_d(int seconds) {
        boolean teleporting;
        boolean bl = teleporting = this.getAnimation() == TELEPORT_ANIMATION && this.getAnimationTick() <= 16;
        if (!this.active || teleporting || !this.hasTriedOrSucceededTeleport) {
            return;
        }
        super.func_70015_d(seconds);
    }

    @Override
    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficulty, SpawnReason reason, ILivingEntityData livingData, CompoundNBT compound) {
        this.setMask(MaskType.FAITH);
        this.setWeapon(3);
        return super.func_213386_a(world, difficulty, reason, livingData, compound);
    }

    public static class HealTargetGoal
    extends Goal {
        private final EntityBarakoa entity;

        public HealTargetGoal(EntityBarakoa entityIn) {
            this.entity = entityIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75253_b() {
            return this.entity.canHeal(this.entity.func_70638_az());
        }

        public boolean func_75250_a() {
            if (!this.entity.active) {
                return false;
            }
            return this.entity.canHeal(this.entity.func_70638_az());
        }

        public void func_75249_e() {
            super.func_75249_e();
            AnimationHandler.INSTANCE.sendAnimationMessage(this.entity, EntityBarakoa.HEAL_START_ANIMATION);
        }

        public void func_75251_c() {
            super.func_75251_c();
        }
    }

    public class TeleportToSafeSpotGoal
    extends Goal {
        private final EntityBarakoaya entity;

        public TeleportToSafeSpotGoal(EntityBarakoaya entityIn) {
            this.entity = entityIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            if (!this.entity.active) {
                return false;
            }
            if (this.entity.getAnimation() == EntityBarakoa.TELEPORT_ANIMATION) {
                return false;
            }
            if (this.entity.func_70638_az() != null && this.entity.canHeal(this.entity.func_70638_az()) && (this.entity.targetDistance >= 0.0f && this.entity.targetDistance < 7.0f || !EntityBarakoaya.this.hasTriedOrSucceededTeleport)) {
                return this.findTeleportLocation();
            }
            return false;
        }

        public void func_75249_e() {
            super.func_75249_e();
            EntityBarakoaya.this.hasTriedOrSucceededTeleport = true;
            AnimationHandler.INSTANCE.sendAnimationMessage(this.entity, EntityBarakoa.TELEPORT_ANIMATION);
        }

        private boolean findTeleportLocation() {
            int k;
            int j;
            int i;
            if (this.entity.func_213391_dJ() > -1.0f) {
                i = MathHelper.func_76141_d((float)this.entity.func_213384_dI().func_177958_n());
                j = MathHelper.func_76141_d((float)this.entity.func_213384_dI().func_177956_o());
                k = MathHelper.func_76141_d((float)this.entity.func_213384_dI().func_177952_p());
            } else if (this.entity.func_70638_az() != null) {
                i = MathHelper.func_76128_c((double)this.entity.func_70638_az().func_226277_ct_());
                j = MathHelper.func_76128_c((double)this.entity.func_70638_az().func_226278_cu_());
                k = MathHelper.func_76128_c((double)this.entity.func_70638_az().func_226281_cx_());
            } else {
                i = MathHelper.func_76128_c((double)this.entity.func_226277_ct_());
                j = MathHelper.func_76128_c((double)this.entity.func_226278_cu_());
                k = MathHelper.func_76128_c((double)this.entity.func_226281_cx_());
            }
            boolean foundPosition = false;
            for (int l = 0; l < 50; ++l) {
                LivingEntity target;
                double radius = Math.pow(EntityBarakoaya.this.field_70146_Z.nextFloat(), 1.35) * 25.0;
                double angle = (double)EntityBarakoaya.this.field_70146_Z.nextFloat() * Math.PI * 2.0;
                int i1 = i + (int)(Math.cos(angle) * radius);
                int j1 = j + MathHelper.func_76136_a((Random)this.entity.field_70146_Z, (int)0, (int)15) * MathHelper.func_76136_a((Random)this.entity.field_70146_Z, (int)-1, (int)1);
                int k1 = k + (int)(Math.sin(angle) * radius);
                BlockPos blockpos = new BlockPos(i1, j1, k1);
                Vector3d newPos = new Vector3d((double)i1, (double)j1, (double)k1);
                Vector3d offset = newPos.func_178788_d(this.entity.func_213303_ch());
                AxisAlignedBB newBB = this.entity.func_174813_aQ().func_191194_a(offset);
                if (!this.testBlock(blockpos, newBB) || !this.entity.field_70170_p.func_217357_a(EntityBarako.class, newBB.func_186662_g(7.0)).isEmpty()) continue;
                this.entity.teleportDestination = newPos.func_72441_c(0.0, 0.0, 0.0);
                if (this.entity.teleportAttempts >= 3) {
                    foundPosition = true;
                }
                if (!this.entity.field_70170_p.func_217357_a(EntityBarakoaya.class, newBB.func_186662_g(5.0)).isEmpty()) continue;
                if (this.entity.teleportAttempts >= 2) {
                    foundPosition = true;
                }
                if (this.entity.field_70170_p.func_217358_a((double)i1, (double)j1, (double)k1, 5.0) || this.entity.field_70170_p.func_72953_d(newBB)) continue;
                if (this.entity.teleportAttempts >= 1) {
                    foundPosition = true;
                }
                if ((target = EntityBarakoaya.this.func_70638_az()) instanceof MobEntity && ((MobEntity)target).func_70638_az() != null) {
                    if (this.canEntityBeSeenFromLocation((Entity)((MobEntity)target).func_70638_az(), newPos)) continue;
                    return true;
                }
                return true;
            }
            this.entity.teleportAttempts++;
            if (this.entity.teleportAttempts > 3) {
                EntityBarakoaya.this.hasTriedOrSucceededTeleport = true;
            }
            return foundPosition;
        }

        public boolean canEntityBeSeenFromLocation(Entity entityIn, Vector3d location) {
            Vector3d vector3d1;
            Vector3d vector3d = new Vector3d(location.func_82615_a(), location.func_82617_b() + (double)this.entity.func_70047_e(), location.func_82616_c());
            return this.entity.field_70170_p.func_217299_a(new RayTraceContext(vector3d, vector3d1 = new Vector3d(entityIn.func_226277_ct_(), entityIn.func_226280_cw_(), entityIn.func_226281_cx_()), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this.entity)).func_216346_c() != RayTraceResult.Type.BLOCK;
        }

        public boolean testBlock(BlockPos blockpos, AxisAlignedBB aabb) {
            World world = this.entity.field_70170_p;
            if (world.func_175667_e(blockpos)) {
                BlockPos blockpos1 = blockpos.func_177977_b();
                BlockState blockstate = world.func_180495_p(blockpos1);
                return blockstate.func_185904_a().func_76220_a() && blockstate.func_185904_a().func_76230_c() && world.func_226664_a_(aabb);
            }
            return false;
        }
    }
}

