/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.effects;

import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityFallingBlock
extends Entity {
    public static float GRAVITY = 0.1f;
    public double prevMotionX;
    public double prevMotionY;
    public double prevMotionZ;
    private static final DataParameter<Optional<BlockState>> BLOCK_STATE = EntityDataManager.func_187226_a(EntityFallingBlock.class, (IDataSerializer)DataSerializers.field_187197_g);
    private static final DataParameter<Integer> DURATION = EntityDataManager.func_187226_a(EntityFallingBlock.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> TICKS_EXISTED = EntityDataManager.func_187226_a(EntityFallingBlock.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<String> MODE = EntityDataManager.func_187226_a(EntityFallingBlock.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Float> ANIM_V_Y = EntityDataManager.func_187226_a(EntityFallingBlock.class, (IDataSerializer)DataSerializers.field_187193_c);
    public float animY = 0.0f;
    public float prevAnimY = 0.0f;

    public EntityFallingBlock(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
        this.setBlock(Blocks.field_150346_d.func_176223_P());
        this.setDuration(70);
    }

    public EntityFallingBlock(EntityType<?> entityTypeIn, World worldIn, int duration, BlockState blockState) {
        super(entityTypeIn, worldIn);
        this.setBlock(blockState);
        this.setDuration(duration);
    }

    public EntityFallingBlock(EntityType<?> entityTypeIn, World worldIn, BlockState blockState, float vy) {
        super(entityTypeIn, worldIn);
        this.setBlock(blockState);
        this.setMode(EnumFallingBlockMode.POPUP_ANIM);
        this.setAnimVY(vy);
    }

    public void onAddedToWorld() {
        if (this.func_213322_ci().func_82615_a() > 0.0 || this.func_213322_ci().func_82616_c() > 0.0) {
            this.field_70177_z = (float)(57.29577951308232 * Math.atan2(this.func_213322_ci().func_82615_a(), this.func_213322_ci().func_82616_c()));
        }
        this.field_70125_A += this.field_70146_Z.nextFloat() * 360.0f;
        super.onAddedToWorld();
    }

    public void func_70071_h_() {
        if (this.getMode() == EnumFallingBlockMode.POPUP_ANIM) {
            this.func_213293_j(0.0, 0.0, 0.0);
        }
        this.prevMotionX = this.func_213322_ci().field_72450_a;
        this.prevMotionY = this.func_213322_ci().field_72448_b;
        this.prevMotionZ = this.func_213322_ci().field_72449_c;
        super.func_70071_h_();
        if (this.getMode() == EnumFallingBlockMode.MOBILE) {
            this.func_213317_d(this.func_213322_ci().func_178786_a(0.0, (double)GRAVITY, 0.0));
            if (this.field_70122_E) {
                this.func_213317_d(this.func_213322_ci().func_186678_a(0.7));
            } else {
                this.field_70125_A += 15.0f;
            }
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            if (this.field_70173_aa > this.getDuration()) {
                this.func_70106_y();
            }
        } else {
            float animVY = this.getAnimVY();
            this.prevAnimY = this.animY;
            this.animY += animVY;
            this.setAnimVY(animVY - GRAVITY);
            if ((double)this.animY < -0.5) {
                this.func_70106_y();
            }
        }
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(BLOCK_STATE, Optional.of(Blocks.field_150346_d.func_176223_P()));
        this.func_184212_Q().func_187214_a(DURATION, (Object)70);
        this.func_184212_Q().func_187214_a(TICKS_EXISTED, (Object)0);
        this.func_184212_Q().func_187214_a(MODE, (Object)EnumFallingBlockMode.MOBILE.toString());
        this.func_184212_Q().func_187214_a(ANIM_V_Y, (Object)Float.valueOf(1.0f));
    }

    protected void func_70037_a(CompoundNBT compound) {
        INBT blockStateCompound = compound.func_74781_a("block");
        if (blockStateCompound != null) {
            BlockState blockState = NBTUtil.func_190008_d((CompoundNBT)((CompoundNBT)blockStateCompound));
            this.setBlock(blockState);
        }
        this.setDuration(compound.func_74762_e("duration"));
        this.field_70173_aa = compound.func_74762_e("ticksExisted");
        this.func_184212_Q().func_187227_b(MODE, (Object)compound.func_74779_i("mode"));
        this.setAnimVY(compound.func_74760_g("vy"));
    }

    protected void func_213281_b(CompoundNBT compound) {
        BlockState blockState = this.getBlock();
        if (blockState != null) {
            compound.func_218657_a("block", (INBT)NBTUtil.func_190009_a((BlockState)blockState));
        }
        compound.func_74768_a("duration", this.getDuration());
        compound.func_74768_a("ticksExisted", this.field_70173_aa);
        compound.func_74778_a("mode", (String)this.func_184212_Q().func_187225_a(MODE));
        compound.func_74776_a("vy", ((Float)this.func_184212_Q().func_187225_a(ANIM_V_Y)).floatValue());
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public BlockState getBlock() {
        Optional bsOp = (Optional)this.func_184212_Q().func_187225_a(BLOCK_STATE);
        return bsOp.orElse(null);
    }

    public void setBlock(BlockState block) {
        this.func_184212_Q().func_187227_b(BLOCK_STATE, Optional.of(block));
    }

    public int getDuration() {
        return (Integer)this.func_184212_Q().func_187225_a(DURATION);
    }

    public void setDuration(int duration) {
        this.func_184212_Q().func_187227_b(DURATION, (Object)duration);
    }

    public int getTicksExisted() {
        return (Integer)this.func_184212_Q().func_187225_a(TICKS_EXISTED);
    }

    public void setTicksExisted(int ticksExisted) {
        this.func_184212_Q().func_187227_b(TICKS_EXISTED, (Object)ticksExisted);
    }

    public EnumFallingBlockMode getMode() {
        String mode = (String)this.func_184212_Q().func_187225_a(MODE);
        if (mode.isEmpty()) {
            return EnumFallingBlockMode.MOBILE;
        }
        return EnumFallingBlockMode.valueOf((String)this.func_184212_Q().func_187225_a(MODE));
    }

    private void setMode(EnumFallingBlockMode mode) {
        this.func_184212_Q().func_187227_b(MODE, (Object)mode.toString());
    }

    public float getAnimVY() {
        return ((Float)this.func_184212_Q().func_187225_a(ANIM_V_Y)).floatValue();
    }

    private void setAnimVY(float vy) {
        this.func_184212_Q().func_187227_b(ANIM_V_Y, (Object)Float.valueOf(vy));
    }

    public static enum EnumFallingBlockMode {
        MOBILE,
        POPUP_ANIM;

    }
}

