/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.frostmaw;

import com.bobmowzie.mowziesmobs.client.particle.ParticleCloud;
import com.bobmowzie.mowziesmobs.client.particle.ParticleHandler;
import com.bobmowzie.mowziesmobs.client.particle.ParticleRing;
import com.bobmowzie.mowziesmobs.client.particle.ParticleSnowFlake;
import com.bobmowzie.mowziesmobs.server.advancement.AdvancementHandler;
import com.bobmowzie.mowziesmobs.server.ai.MMEntityMoveHelper;
import com.bobmowzie.mowziesmobs.server.ai.MMPathNavigateGround;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationActivateAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationAreaAttackAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationDeactivateAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationDieAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationTakeDamage;
import com.bobmowzie.mowziesmobs.server.ai.animation.SimpleAnimationAI;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.LegSolverQuadruped;
import com.bobmowzie.mowziesmobs.server.entity.MowzieEntity;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityCameraShake;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityIceBall;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityIceBreath;
import com.bobmowzie.mowziesmobs.server.item.ItemHandler;
import com.bobmowzie.mowziesmobs.server.loot.LootTableHandler;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import com.google.common.base.Supplier;
import com.ilexiconn.llibrary.server.animation.Animation;
import com.ilexiconn.llibrary.server.animation.AnimationHandler;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.BossInfo;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemHandlerHelper;

public class EntityFrostmaw
extends MowzieEntity
implements IMob {
    public static final Animation DIE_ANIMATION = Animation.create(94);
    public static final Animation HURT_ANIMATION = Animation.create(0);
    public static final Animation ROAR_ANIMATION = Animation.create(76);
    public static final Animation SWIPE_ANIMATION = Animation.create(28);
    public static final Animation SWIPE_TWICE_ANIMATION = Animation.create(57);
    public static final Animation ICE_BREATH_ANIMATION = Animation.create(92);
    public static final Animation ICE_BALL_ANIMATION = Animation.create(50);
    public static final Animation ACTIVATE_ANIMATION = Animation.create(118);
    public static final Animation ACTIVATE_NO_CRYSTAL_ANIMATION = Animation.create(100);
    public static final Animation DEACTIVATE_ANIMATION = Animation.create(25);
    public static final Animation DODGE_ANIMATION = Animation.create(15);
    public static final Animation LAND_ANIMATION = Animation.create(14);
    public static final Animation SLAM_ANIMATION = Animation.create(113);
    private static final DataParameter<Boolean> ACTIVE = EntityDataManager.func_187226_a(EntityFrostmaw.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> HAS_CRYSTAL = EntityDataManager.func_187226_a(EntityFrostmaw.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final int ICE_BREATH_COOLDOWN = 260;
    public static final int ICE_BALL_COOLDOWN = 200;
    public static final int SLAM_COOLDOWN = 500;
    public static final int DODGE_COOLDOWN = 200;
    public EntityIceBreath iceBreath;
    public boolean swingWhichArm = false;
    private Vector3d prevRightHandPos = new Vector3d(0.0, 0.0, 0.0);
    private Vector3d prevLeftHandPos = new Vector3d(0.0, 0.0, 0.0);
    private int iceBreathCooldown = 0;
    private int iceBallCooldown = 0;
    private int slamCooldown = 0;
    private int timeWithoutTarget;
    private int shouldDodgeMeasure = 0;
    private int dodgeCooldown = 0;
    private boolean shouldDodge;
    private float dodgeYaw = 0.0f;
    private Vector3d prevTargetPos = new Vector3d(0.0, 0.0, 0.0);
    private boolean shouldPlayLandAnimation = false;
    public LegSolverQuadruped legSolver;

    public EntityFrostmaw(EntityType<? extends EntityFrostmaw> type, World world) {
        super(type, world);
        this.field_70138_W = 1.0f;
        this.frame += this.field_70146_Z.nextInt(50);
        this.legSolver = new LegSolverQuadruped(1.0f, 2.0f, -1.0f, 1.5f);
        if (world.field_72995_K) {
            this.socketPosArray = new Vector3d[]{new Vector3d(0.0, 0.0, 0.0), new Vector3d(0.0, 0.0, 0.0), new Vector3d(0.0, 0.0, 0.0)};
        }
        this.active = false;
        this.playsHurtAnimation = false;
        this.field_70177_z = this.field_70761_aq = this.field_70146_Z.nextFloat() * 360.0f;
        this.field_70728_aV = 60;
        this.field_70765_h = new MMEntityMoveHelper((MobEntity)this, 7.0f);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(5, (Goal)new MoveTowardsRestrictionGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new AnimationAreaAttackAI<EntityFrostmaw>(this, SWIPE_ANIMATION, null, null, 2.0f, 6.5f, 6.0f, 135.0f, ((Double)ConfigHandler.COMMON.MOBS.FROSTMAW.combatConfig.attackMultiplier.get()).floatValue(), 9){

            @Override
            public void func_75249_e() {
                super.func_75249_e();
            }

            @Override
            protected void onAttack(LivingEntity entityTarget, float damageMultiplier, float applyKnockbackMultiplier) {
                PlayerEntity player;
                super.onAttack(entityTarget, damageMultiplier, applyKnockbackMultiplier);
                if (entityTarget instanceof PlayerEntity && (player = (PlayerEntity)entityTarget).func_184585_cz()) {
                    player.func_190777_m(false);
                }
            }
        });
        this.field_70714_bg.func_75776_a(2, (Goal)new AnimationAreaAttackAI<EntityFrostmaw>(this, SWIPE_TWICE_ANIMATION, null, null, 1.0f, 6.5f, 6.0f, 135.0f, ((Double)ConfigHandler.COMMON.MOBS.FROSTMAW.combatConfig.attackMultiplier.get()).floatValue(), 9){

            @Override
            public void func_75249_e() {
                super.func_75249_e();
            }

            @Override
            public void func_75246_d() {
                super.func_75246_d();
                if (EntityFrostmaw.this.getAnimationTick() == 21) {
                    this.hitEntities();
                }
                if (EntityFrostmaw.this.getAnimationTick() == 16) {
                    EntityFrostmaw.this.func_184185_a((SoundEvent)MMSounds.ENTITY_FROSTMAW_WHOOSH.get(), 2.0f, 0.7f);
                }
                if (EntityFrostmaw.this.getAnimationTick() == 6) {
                    EntityFrostmaw.this.func_184185_a((SoundEvent)MMSounds.ENTITY_FROSTMAW_WHOOSH.get(), 2.0f, 0.8f);
                }
                if (EntityFrostmaw.this.func_70638_az() != null) {
                    EntityFrostmaw.this.field_70749_g.func_75651_a((Entity)EntityFrostmaw.this.func_70638_az(), 30.0f, 30.0f);
                }
            }

            @Override
            protected void onAttack(LivingEntity entityTarget, float damageMultiplier, float applyKnockbackMultiplier) {
                PlayerEntity player;
                super.onAttack(entityTarget, damageMultiplier, applyKnockbackMultiplier);
                if (entityTarget instanceof PlayerEntity && (player = (PlayerEntity)entityTarget).func_184585_cz()) {
                    player.func_190777_m(false);
                }
            }
        });
        this.field_70714_bg.func_75776_a(2, new SimpleAnimationAI<EntityFrostmaw>(this, ICE_BREATH_ANIMATION, true));
        this.field_70714_bg.func_75776_a(2, (Goal)new SimpleAnimationAI<EntityFrostmaw>(this, ICE_BALL_ANIMATION, true){

            @Override
            public void func_75249_e() {
                super.func_75249_e();
                EntityFrostmaw.this.func_184185_a((SoundEvent)MMSounds.ENTITY_FROSTMAW_ICEBALL_CHARGE.get(), 2.0f, 0.9f);
            }
        });
        this.field_70714_bg.func_75776_a(2, new SimpleAnimationAI<EntityFrostmaw>(this, ROAR_ANIMATION, false));
        this.field_70714_bg.func_75776_a(2, (Goal)new AnimationActivateAI<EntityFrostmaw>(this, ACTIVATE_ANIMATION){

            @Override
            public void func_75249_e() {
                super.func_75249_e();
                EntityFrostmaw.this.func_184185_a((SoundEvent)MMSounds.ENTITY_FROSTMAW_WAKEUP.get(), 1.0f, 1.0f);
            }
        });
        this.field_70714_bg.func_75776_a(2, (Goal)new AnimationActivateAI<EntityFrostmaw>(this, ACTIVATE_NO_CRYSTAL_ANIMATION){

            @Override
            public void func_75249_e() {
                super.func_75249_e();
                EntityFrostmaw.this.func_184185_a((SoundEvent)MMSounds.ENTITY_FROSTMAW_WAKEUP.get(), 1.0f, 1.0f);
            }
        });
        this.field_70714_bg.func_75776_a(2, new AnimationDeactivateAI<EntityFrostmaw>(this, DEACTIVATE_ANIMATION));
        this.field_70714_bg.func_75776_a(2, new SimpleAnimationAI<EntityFrostmaw>(this, LAND_ANIMATION, false));
        this.field_70714_bg.func_75776_a(2, new SimpleAnimationAI<EntityFrostmaw>(this, SLAM_ANIMATION, EnumSet.of(Goal.Flag.LOOK)));
        this.field_70714_bg.func_75776_a(2, new SimpleAnimationAI<EntityFrostmaw>(this, DODGE_ANIMATION, EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP)));
        this.field_70714_bg.func_75776_a(3, new AnimationTakeDamage<EntityFrostmaw>(this));
        this.field_70714_bg.func_75776_a(1, new AnimationDieAI<EntityFrostmaw>(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 0, true, false, null));
    }

    protected PathNavigator func_175447_b(World world) {
        return new MMPathNavigateGround(this, world);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MowzieEntity.createAttributes().func_233815_a_(Attributes.field_233823_f_, 10.0).func_233815_a_(Attributes.field_233818_a_, 250.0 * (Double)ConfigHandler.COMMON.MOBS.FROSTMAW.combatConfig.healthMultiplier.get()).func_233815_a_(Attributes.field_233820_c_, 1.0).func_233815_a_(Attributes.field_233819_b_, 50.0).func_233815_a_(Attributes.field_233821_d_, 0.3);
    }

    protected float func_189749_co() {
        return 0.98f;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(ACTIVE, (Object)false);
        this.func_184212_Q().func_187214_a(HAS_CRYSTAL, (Object)true);
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
    }

    public void func_70106_y() {
        super.func_70106_y();
    }

    public void func_70642_aH() {
        if (!this.active) {
            return;
        }
        int i = this.field_70146_Z.nextInt(4);
        super.func_70642_aH();
        if (i == 0 && this.getAnimation() == NO_ANIMATION) {
            AnimationHandler.INSTANCE.sendAnimationMessage(this, ROAR_ANIMATION);
            return;
        }
        if (i < MMSounds.ENTITY_FROSTMAW_LIVING.size()) {
            this.func_184185_a((SoundEvent)((Supplier)MMSounds.ENTITY_FROSTMAW_LIVING.get(i)).get(), 2.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.3f);
        }
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return super.func_184639_G();
    }

    @Override
    public boolean canBePushedByEntity(Entity entity) {
        return false;
    }

    @Override
    protected void repelEntities(float x, float y, float z, float radius) {
        List<PlayerEntity> nearbyEntities = this.getPlayersNearby(x, y, z, radius);
        for (Entity entity : nearbyEntities) {
            double angle = (this.getAngleBetweenEntities((Entity)this, entity) + 90.0) * Math.PI / 180.0;
            entity.func_213293_j(-0.1 * Math.cos(angle), entity.func_213322_ci().field_72448_b, -0.1 * Math.sin(angle));
        }
    }

    @Override
    public void func_70071_h_() {
        block78: {
            block76: {
                block77: {
                    int i;
                    this.field_70177_z = this.field_70761_aq;
                    super.func_70071_h_();
                    this.repelEntities(3.8f, 3.8f, 3.8f, 3.8f);
                    if (this.func_70638_az() != null && (!this.func_70638_az().func_70089_S() || this.func_70638_az().func_110143_aJ() <= 0.0f)) {
                        this.func_70624_b(null);
                    }
                    if (!this.getActive() || this.getAnimation() == ACTIVATE_ANIMATION || this.getAnimation() == ACTIVATE_NO_CRYSTAL_ANIMATION) break block76;
                    this.legSolver.update((LivingEntity)this);
                    if ((this.getAnimation() == SWIPE_ANIMATION || this.getAnimation() == SWIPE_TWICE_ANIMATION) && this.getAnimationTick() == 3 && (i = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)0, (int)MMSounds.ENTITY_FROSTMAW_ATTACK.size())) < MMSounds.ENTITY_FROSTMAW_ATTACK.size()) {
                        this.func_184185_a((SoundEvent)((Supplier)MMSounds.ENTITY_FROSTMAW_ATTACK.get(i)).get(), 2.0f, 0.9f + this.field_70146_Z.nextFloat() * 0.2f);
                    }
                    if (this.getAnimation() == SWIPE_ANIMATION) {
                        if (this.getAnimationTick() == 6) {
                            this.func_184185_a((SoundEvent)MMSounds.ENTITY_FROSTMAW_WHOOSH.get(), 2.0f, 0.8f);
                        }
                        if (this.func_70638_az() != null) {
                            this.field_70749_g.func_75651_a((Entity)this.func_70638_az(), 30.0f, 30.0f);
                        }
                    }
                    if (this.getAnimation() == ROAR_ANIMATION) {
                        if (this.getAnimationTick() == 10) {
                            this.func_184185_a((SoundEvent)MMSounds.ENTITY_FROSTMAW_ROAR.get(), 4.0f, 1.0f);
                        }
                        if (this.getAnimationTick() >= 8 && this.getAnimationTick() < 65) {
                            this.doRoarEffects();
                        }
                    }
                    if (this.getAnimation() == LAND_ANIMATION && this.getAnimationTick() == 3) {
                        this.func_184185_a((SoundEvent)MMSounds.ENTITY_FROSTMAW_LAND.get(), 3.0f, 0.9f);
                    }
                    if (this.getAnimation() == SLAM_ANIMATION) {
                        if (this.getAnimationTick() == 82) {
                            this.func_184185_a((SoundEvent)MMSounds.ENTITY_FROSTMAW_LIVING_1.get(), 2.0f, 1.0f);
                        }
                        if (this.func_70638_az() != null) {
                            this.field_70749_g.func_75651_a((Entity)this.func_70638_az(), 30.0f, 30.0f);
                        }
                        if (this.getAnimationTick() == 82) {
                            i = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)0, (int)(MMSounds.ENTITY_FROSTMAW_ATTACK.size() - 1));
                            if (i < MMSounds.ENTITY_FROSTMAW_ATTACK.size()) {
                                this.func_184185_a((SoundEvent)((Supplier)MMSounds.ENTITY_FROSTMAW_ATTACK.get(i)).get(), 2.0f, 0.9f + this.field_70146_Z.nextFloat() * 0.2f);
                            }
                            this.func_184185_a((SoundEvent)MMSounds.ENTITY_FROSTMAW_WHOOSH.get(), 2.0f, 0.7f);
                        }
                        if (this.getAnimationTick() == 87) {
                            this.func_184185_a((SoundEvent)MMSounds.ENTITY_FROSTMAW_LAND.get(), 3.0f, 1.0f);
                            float radius = 4.0f;
                            float slamPosX = (float)(this.func_226277_ct_() + (double)radius * Math.cos(Math.toRadians(this.field_70177_z + 90.0f)));
                            float slamPosZ = (float)(this.func_226281_cx_() + (double)radius * Math.sin(Math.toRadians(this.field_70177_z + 90.0f)));
                            if (this.field_70170_p.field_72995_K) {
                                this.field_70170_p.func_195594_a((IParticleData)new ParticleRing.RingData(0.0f, 1.5707964f, 17, 1.0f, 1.0f, 1.0f, 1.0f, 60.0f, false, ParticleRing.EnumRingBehavior.GROW), (double)slamPosX, this.func_226278_cu_() + (double)0.2f, (double)slamPosZ, 0.0, 0.0, 0.0);
                            }
                            AxisAlignedBB hitBox = new AxisAlignedBB(new BlockPos((double)(slamPosX - 0.5f), this.func_226278_cu_(), (double)(slamPosZ - 0.5f))).func_72314_b(3.0, 3.0, 3.0);
                            List entitiesHit = this.field_70170_p.func_217357_a(LivingEntity.class, hitBox);
                            for (LivingEntity entity : entitiesHit) {
                                if (entity == this) continue;
                                this.attackEntityAsMob((Entity)entity, 4.0f * ((Double)ConfigHandler.COMMON.MOBS.FROSTMAW.combatConfig.attackMultiplier.get()).floatValue(), 1.0f);
                                if (!entity.func_184585_cz()) continue;
                                entity.func_184607_cu().func_222118_a(400, entity, p -> p.func_213334_d(entity.func_184600_cs()));
                            }
                            EntityCameraShake.cameraShake(this.field_70170_p, new Vector3d((double)slamPosX, this.func_226278_cu_(), (double)slamPosZ), 30.0f, 0.1f, 0, 20);
                        }
                    }
                    if (this.getAnimation() == DODGE_ANIMATION && !this.field_70170_p.field_72995_K) {
                        this.func_70661_as().func_75499_g();
                        if (this.getAnimationTick() == 2) {
                            this.dodgeYaw = (float)Math.toRadians(this.targetAngle + 90.0f + this.field_70146_Z.nextFloat() * 150.0f - 75.0f);
                        }
                        if (this.getAnimationTick() == 6 && (this.field_70122_E || this.func_180799_ab() || this.func_70090_H())) {
                            float speed = 1.7f;
                            Vector3d m = this.func_213322_ci().func_72441_c((double)speed * Math.cos(this.dodgeYaw), 0.0, (double)speed * Math.sin(this.dodgeYaw));
                            this.func_213293_j(m.field_72450_a, 0.6, m.field_72449_c);
                        }
                        if (this.func_70638_az() != null) {
                            this.field_70749_g.func_75651_a((Entity)this.func_70638_az(), 30.0f, 30.0f);
                        }
                    }
                    if (this.getAnimation() == ICE_BREATH_ANIMATION) {
                        if (this.func_70638_az() != null) {
                            this.field_70749_g.func_75651_a((Entity)this.func_70638_az(), 30.0f, 30.0f);
                            this.func_70625_a((Entity)this.func_70638_az(), 30.0f, 30.0f);
                        }
                        Vector3d mouthPos = new Vector3d(2.3, 2.65, 0.0);
                        mouthPos = mouthPos.func_178785_b((float)Math.toRadians(-this.field_70177_z - 90.0f));
                        mouthPos = mouthPos.func_178787_e(this.func_213303_ch());
                        mouthPos = mouthPos.func_178787_e(new Vector3d(0.0, 0.0, 1.0).func_178789_a((float)Math.toRadians(-this.field_70125_A)).func_178785_b((float)Math.toRadians(-this.field_70759_as)));
                        if (this.getAnimationTick() == 13) {
                            this.iceBreath = new EntityIceBreath((EntityType<? extends EntityIceBreath>)((EntityType)EntityHandler.ICE_BREATH.get()), this.field_70170_p, (LivingEntity)this);
                            this.iceBreath.func_70080_a(mouthPos.field_72450_a, mouthPos.field_72448_b, mouthPos.field_72449_c, this.field_70759_as, this.field_70125_A + 10.0f);
                            if (!this.field_70170_p.field_72995_K) {
                                this.field_70170_p.func_217376_c((Entity)this.iceBreath);
                            }
                        }
                        if (this.iceBreath != null) {
                            this.iceBreath.func_70080_a(mouthPos.field_72450_a, mouthPos.field_72448_b, mouthPos.field_72449_c, this.field_70759_as, this.field_70125_A + 10.0f);
                        }
                    }
                    if (this.getAnimation() == ICE_BALL_ANIMATION) {
                        if (this.func_70638_az() != null) {
                            this.field_70749_g.func_75651_a((Entity)this.func_70638_az(), 15.0f, 15.0f);
                        }
                        Vector3d projectilePos = new Vector3d(2.0, 1.9, 0.0);
                        projectilePos = projectilePos.func_178785_b((float)Math.toRadians(-this.field_70177_z - 90.0f));
                        projectilePos = projectilePos.func_178787_e(this.func_213303_ch());
                        projectilePos = projectilePos.func_178787_e(new Vector3d(0.0, 0.0, 1.0).func_178789_a((float)Math.toRadians(-this.field_70125_A)).func_178785_b((float)Math.toRadians(-this.field_70759_as)));
                        if (this.field_70170_p.field_72995_K) {
                            Vector3d mouthPos = this.socketPosArray[2];
                            if (this.getAnimationTick() < 12) {
                                Vector3d particlePos;
                                int i2;
                                for (i2 = 0; i2 < 6; ++i2) {
                                    particlePos = new Vector3d(3.5, 0.0, 0.0);
                                    particlePos = particlePos.func_178785_b((float)((double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI));
                                    particlePos = particlePos.func_178789_a((float)((double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI));
                                    float value = this.field_70146_Z.nextFloat() * 0.15f;
                                    this.field_70170_p.func_195594_a((IParticleData)new ParticleCloud.CloudData((ParticleType<ParticleCloud.CloudData>)((ParticleType)ParticleHandler.CLOUD.get()), 0.75f + value, 0.75f + value, 1.0f, 5.0f + this.field_70146_Z.nextFloat() * 15.0f, 30, ParticleCloud.EnumCloudBehavior.CONSTANT, 1.0f), mouthPos.field_72450_a + particlePos.field_72450_a, mouthPos.field_72448_b + particlePos.field_72448_b, mouthPos.field_72449_c + particlePos.field_72449_c, -0.1 * particlePos.field_72450_a, -0.1 * particlePos.field_72448_b, -0.1 * particlePos.field_72449_c);
                                }
                                for (i2 = 0; i2 < 8; ++i2) {
                                    particlePos = new Vector3d(3.5, 0.0, 0.0);
                                    particlePos = particlePos.func_178785_b((float)((double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI));
                                    particlePos = particlePos.func_178789_a((float)((double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI));
                                    this.field_70170_p.func_195594_a((IParticleData)new ParticleSnowFlake.SnowflakeData(40.0f, false), mouthPos.field_72450_a + particlePos.field_72450_a, mouthPos.field_72448_b + particlePos.field_72448_b, mouthPos.field_72449_c + particlePos.field_72449_c, -0.07 * particlePos.field_72450_a, -0.07 * particlePos.field_72448_b, -0.07 * particlePos.field_72449_c);
                                }
                            }
                        }
                        if (this.getAnimationTick() == 32 && this.func_70638_az() != null) {
                            this.prevTargetPos = this.func_70638_az().func_213303_ch().func_178787_e(new Vector3d(0.0, (double)this.func_70638_az().func_213302_cg() / 2.0, 0.0));
                        }
                        if (this.getAnimationTick() == 33) {
                            this.func_184185_a((SoundEvent)MMSounds.ENTITY_FROSTMAW_ICEBALL_SHOOT.get(), 2.0f, 0.7f);
                            EntityIceBall iceBall = new EntityIceBall((EntityType<? extends EntityIceBall>)((EntityType)EntityHandler.ICE_BALL.get()), this.field_70170_p, (LivingEntity)this);
                            iceBall.func_70080_a(projectilePos.field_72450_a, projectilePos.field_72448_b, projectilePos.field_72449_c, this.field_70759_as, this.field_70125_A + 10.0f);
                            float projSpeed = 1.6f;
                            if (this.func_70638_az() != null) {
                                float ticksUntilHit = this.targetDistance / projSpeed;
                                Vector3d targetPos = this.func_70638_az().func_213303_ch().func_178787_e(new Vector3d(0.0, (double)this.func_70638_az().func_213302_cg() / 2.0, 0.0));
                                Vector3d targetMovement = targetPos.func_178788_d(this.prevTargetPos).func_186678_a((double)ticksUntilHit * 0.95);
                                targetMovement = targetMovement.func_178786_a(0.0, targetMovement.field_72448_b, 0.0);
                                Vector3d futureTargetPos = targetPos.func_178787_e(targetMovement);
                                Vector3d projectileMid = projectilePos.func_178787_e(new Vector3d(0.0, (double)iceBall.func_213302_cg() / 2.0, 0.0));
                                Vector3d shootVec = futureTargetPos.func_178788_d(projectileMid).func_72432_b();
                                iceBall.shoot(shootVec.field_72450_a, shootVec.field_72448_b, shootVec.field_72449_c, projSpeed, 0.0f);
                            } else {
                                iceBall.shoot(this.func_70040_Z().field_72450_a, this.func_70040_Z().field_72448_b, this.func_70040_Z().field_72449_c, projSpeed, 0.0f);
                            }
                            if (!this.field_70170_p.field_72995_K) {
                                this.field_70170_p.func_217376_c((Entity)iceBall);
                            }
                        }
                    }
                    this.spawnSwipeParticles();
                    if ((double)this.field_70143_R > 0.2 && !this.field_70122_E || this.getAnimation() == DODGE_ANIMATION) {
                        this.shouldPlayLandAnimation = true;
                    }
                    if (this.field_70122_E && this.shouldPlayLandAnimation && this.getAnimation() != DODGE_ANIMATION) {
                        if (!this.field_70170_p.field_72995_K && this.getAnimation() == NO_ANIMATION) {
                            AnimationHandler.INSTANCE.sendAnimationMessage(this, LAND_ANIMATION);
                        }
                        this.shouldPlayLandAnimation = false;
                    }
                    if (this.func_70638_az() == null) break block77;
                    this.timeWithoutTarget = 0;
                    float entityHitAngle = (float)((Math.atan2(this.func_70638_az().func_226281_cx_() - this.func_226281_cx_(), this.func_70638_az().func_226277_ct_() - this.func_226277_ct_()) * 57.29577951308232 - 90.0) % 360.0);
                    float entityAttackingAngle = this.field_70761_aq % 360.0f;
                    if (entityHitAngle < 0.0f) {
                        entityHitAngle += 360.0f;
                    }
                    if (entityAttackingAngle < 0.0f) {
                        entityAttackingAngle += 360.0f;
                    }
                    float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
                    if (!(!this.func_70661_as().func_75500_f() || entityRelativeAngle <= 15.0f && entityRelativeAngle >= -15.0f || entityRelativeAngle >= 345.0f || entityRelativeAngle <= -345.0f)) {
                        this.func_70661_as().func_75497_a((Entity)this.func_70638_az(), 0.85);
                    }
                    if (this.shouldDodgeMeasure >= 12) {
                        this.shouldDodge = true;
                    }
                    if (this.targetDistance < 4.0f && this.shouldDodge && this.getAnimation() == NO_ANIMATION) {
                        this.shouldDodge = false;
                        this.dodgeCooldown = 200;
                        this.shouldDodgeMeasure = 0;
                        AnimationHandler.INSTANCE.sendAnimationMessage(this, DODGE_ANIMATION);
                    }
                    if ((double)this.targetDistance > 5.5 && (this.getAnimation() != ICE_BREATH_ANIMATION || !((double)this.targetDistance < 7.5))) {
                        if (this.getAnimation() != SLAM_ANIMATION) {
                            this.func_70661_as().func_75497_a((Entity)this.func_70638_az(), 1.0);
                        } else {
                            this.func_70661_as().func_75497_a((Entity)this.func_70638_az(), 0.95);
                        }
                    } else {
                        this.func_70661_as().func_75499_g();
                    }
                    if ((double)this.targetDistance <= 8.5 && this.getAnimation() == NO_ANIMATION && this.slamCooldown <= 0 && this.field_70146_Z.nextInt(4) == 0 && (double)this.getHealthRatio() < 0.6) {
                        AnimationHandler.INSTANCE.sendAnimationMessage(this, SLAM_ANIMATION);
                        this.slamCooldown = 500;
                    }
                    if ((double)this.targetDistance <= 6.5 && this.getAnimation() == NO_ANIMATION) {
                        if (this.field_70146_Z.nextInt(4) == 0) {
                            AnimationHandler.INSTANCE.sendAnimationMessage(this, SWIPE_TWICE_ANIMATION);
                        } else {
                            AnimationHandler.INSTANCE.sendAnimationMessage(this, SWIPE_ANIMATION);
                        }
                    }
                    if ((double)this.targetDistance <= 13.5 && this.getAnimation() == NO_ANIMATION && this.iceBreathCooldown <= 0 && this.getHasCrystal() && (this.field_70122_E || this.field_70171_ac)) {
                        AnimationHandler.INSTANCE.sendAnimationMessage(this, ICE_BREATH_ANIMATION);
                        this.iceBreathCooldown = 260;
                    }
                    if (!((double)this.targetDistance >= 14.5) || this.getAnimation() != NO_ANIMATION || this.iceBallCooldown > 0 || !this.getHasCrystal() || !this.field_70122_E && !this.field_70171_ac) break block78;
                    AnimationHandler.INSTANCE.sendAnimationMessage(this, ICE_BALL_ANIMATION);
                    this.iceBallCooldown = 200;
                    break block78;
                }
                if (this.field_70170_p.field_72995_K) break block78;
                ++this.timeWithoutTarget;
                if (this.timeWithoutTarget > 1200 || this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL) {
                    this.timeWithoutTarget = 0;
                    if (this.getAnimation() == NO_ANIMATION) {
                        AnimationHandler.INSTANCE.sendAnimationMessage(this, DEACTIVATE_ANIMATION);
                        this.setActive(false);
                    }
                }
                break block78;
            }
            this.func_70661_as().func_75499_g();
            this.func_213293_j(0.0, this.func_213322_ci().field_72448_b, 0.0);
            this.field_70761_aq = this.field_70760_ar;
            if (!this.field_70170_p.field_72995_K && this.getAnimation() != ACTIVATE_ANIMATION && ((Boolean)ConfigHandler.COMMON.MOBS.FROSTMAW.healsOutOfBattle.get()).booleanValue()) {
                this.func_70691_i(0.3f);
            }
            if (this.func_70638_az() != null && this.func_70638_az().func_70644_a(Effects.field_76441_p)) {
                this.func_70624_b(null);
            }
            if (!this.getAttackableEntityLivingBaseNearby(8.0, 8.0, 8.0, 8.0).isEmpty() && this.func_70638_az() != null && this.getAnimation() == NO_ANIMATION && this.field_70170_p.func_175659_aa() != Difficulty.PEACEFUL) {
                if (this.getHasCrystal()) {
                    AnimationHandler.INSTANCE.sendAnimationMessage(this, ACTIVATE_ANIMATION);
                } else {
                    AnimationHandler.INSTANCE.sendAnimationMessage(this, ACTIVATE_NO_CRYSTAL_ANIMATION);
                }
                this.setActive(true);
            }
            if (((Boolean)ConfigHandler.COMMON.MOBS.FROSTMAW.stealableIceCrystal.get()).booleanValue() && this.getHasCrystal() && this.field_70173_aa > 20 && this.getAnimation() == NO_ANIMATION) {
                Vector3d crystalPos = new Vector3d(1.6, 0.4, 1.8);
                crystalPos = crystalPos.func_178785_b((float)Math.toRadians(-this.field_70177_z - 90.0f));
                crystalPos = crystalPos.func_178787_e(this.func_213303_ch());
                for (PlayerEntity player : this.getPlayersNearby(8.0, 8.0, 8.0, 8.0)) {
                    if (!(player.func_213303_ch().func_72438_d(crystalPos) <= 1.8) || !player.func_184812_l_() && !player.func_82150_aj() || EntityFrostmaw.isInventoryFull(player.field_71071_by)) continue;
                    ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)new ItemStack((IItemProvider)ItemHandler.ICE_CRYSTAL));
                    this.setHasCrystal(false);
                    if (this.field_70170_p.func_175659_aa() != Difficulty.PEACEFUL) {
                        AnimationHandler.INSTANCE.sendAnimationMessage(this, ACTIVATE_NO_CRYSTAL_ANIMATION);
                        this.setActive(true);
                    }
                    if (!(player instanceof ServerPlayerEntity)) break;
                    AdvancementHandler.STEAL_ICE_CRYSTAL_TRIGGER.trigger((ServerPlayerEntity)player);
                    break;
                }
            }
        }
        if (this.getAnimation() == ACTIVATE_ANIMATION || this.getAnimation() == ACTIVATE_NO_CRYSTAL_ANIMATION) {
            if (this.getAnimation() == ACTIVATE_ANIMATION && this.getAnimationTick() == 18) {
                this.func_184185_a((SoundEvent)((Supplier)MMSounds.ENTITY_FROSTMAW_ATTACK.get(0)).get(), 1.5f, 1.0f);
            }
            if (this.getAnimation() == ACTIVATE_ANIMATION && this.getAnimationTick() == 52 || this.getAnimation() == ACTIVATE_NO_CRYSTAL_ANIMATION && this.getAnimationTick() == 34) {
                this.func_184185_a((SoundEvent)MMSounds.ENTITY_FROSTMAW_ROAR.get(), 4.0f, 1.0f);
            }
            if (this.getAnimation() == ACTIVATE_ANIMATION && this.getAnimationTick() >= 51 && this.getAnimationTick() < 108 || this.getAnimation() == ACTIVATE_NO_CRYSTAL_ANIMATION && this.getAnimationTick() >= 33 && this.getAnimationTick() < 90) {
                this.doRoarEffects();
            }
        }
        if (this.field_70170_p.field_72995_K && (this.getAnimation() == SWIPE_ANIMATION || this.getAnimation() == SWIPE_TWICE_ANIMATION) && this.getAnimationTick() == 1) {
            this.swingWhichArm = this.field_70146_Z.nextBoolean();
        }
        float moveX = (float)(this.func_226277_ct_() - this.field_70169_q);
        float moveZ = (float)(this.func_226281_cx_() - this.field_70166_s);
        float speed = MathHelper.func_76129_c((float)(moveX * moveX + moveZ * moveZ));
        if (this.frame % 16 == 5 && (double)speed > 0.05 && this.active) {
            this.func_184185_a((SoundEvent)MMSounds.ENTITY_FROSTMAW_STEP.get(), 3.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.2f);
            EntityCameraShake.cameraShake(this.field_70170_p, this.func_213303_ch(), 20.0f, 0.03f, 0, 10);
        }
        if (this.frame % 118 == 1 && !this.active) {
            int i = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)0, (int)1);
            this.func_184185_a((SoundEvent)((Supplier)MMSounds.ENTITY_FROSTMAW_BREATH.get(i)).get(), 1.5f, 1.1f + this.field_70146_Z.nextFloat() * 0.1f);
        }
        if (this.iceBreathCooldown > 0) {
            --this.iceBreathCooldown;
        }
        if (this.iceBallCooldown > 0) {
            --this.iceBallCooldown;
        }
        if (this.slamCooldown > 0) {
            --this.slamCooldown;
        }
        if (this.shouldDodgeMeasure > 0 && this.field_70173_aa % 7 == 0) {
            --this.shouldDodgeMeasure;
        }
        if (this.dodgeCooldown > 0) {
            --this.dodgeCooldown;
        }
        this.field_70126_B = this.field_70177_z;
    }

    private void doRoarEffects() {
        if (this.getHasCrystal()) {
            List<LivingEntity> entities = this.getEntityLivingBaseNearby(10.0, 3.0, 10.0, 10.0);
            for (LivingEntity entity : entities) {
                if (entity == this) continue;
                double angle = (this.getAngleBetweenEntities((Entity)this, (Entity)entity) + 90.0) * Math.PI / 180.0;
                double distance = this.func_70032_d((Entity)entity) - 4.0f;
                entity.func_213317_d(entity.func_213322_ci().func_72441_c(Math.min(1.0 / (distance * distance), 1.0) * -1.0 * Math.cos(angle), 0.0, Math.min(1.0 / (distance * distance), 1.0) * -1.0 * Math.sin(angle)));
            }
            if (this.getAnimationTick() % 12 == 0 && this.field_70170_p.field_72995_K) {
                double zSpeed;
                double xSpeed;
                double speed;
                double yaw;
                int i;
                int particleCount = 15;
                for (i = 1; i <= particleCount; ++i) {
                    yaw = (float)i * 360.0f / (float)particleCount;
                    speed = 0.9;
                    xSpeed = speed * Math.cos(Math.toRadians(yaw));
                    zSpeed = speed * Math.sin(Math.toRadians(yaw));
                    this.field_70170_p.func_195594_a((IParticleData)new ParticleCloud.CloudData((ParticleType<ParticleCloud.CloudData>)((ParticleType)ParticleHandler.CLOUD.get()), 0.75f, 0.75f, 1.0f, 40.0f, 22, ParticleCloud.EnumCloudBehavior.GROW, 1.0f), this.func_226277_ct_(), this.func_226278_cu_() + 1.0, this.func_226281_cx_(), xSpeed, 0.0, zSpeed);
                }
                for (i = 1; i <= particleCount; ++i) {
                    yaw = (float)i * 360.0f / (float)particleCount;
                    speed = 0.65;
                    xSpeed = speed * Math.cos(Math.toRadians(yaw));
                    zSpeed = speed * Math.sin(Math.toRadians(yaw));
                    this.field_70170_p.func_195594_a((IParticleData)new ParticleCloud.CloudData((ParticleType<ParticleCloud.CloudData>)((ParticleType)ParticleHandler.CLOUD.get()), 0.75f, 0.75f, 1.0f, 35.0f, 22, ParticleCloud.EnumCloudBehavior.GROW, 1.0f), this.func_226277_ct_(), this.func_226278_cu_() + 1.0, this.func_226281_cx_(), xSpeed, 0.0, zSpeed);
                }
            }
        }
    }

    private static boolean isInventoryFull(PlayerInventory inventory) {
        for (ItemStack itemstack : inventory.field_70462_a) {
            if (!itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public boolean func_213380_a(IWorld world, SpawnReason reason) {
        List<LivingEntity> nearby = this.getEntityLivingBaseNearby(100.0, 100.0, 100.0, 100.0);
        for (LivingEntity nearbyEntity : nearby) {
            if (!(nearbyEntity instanceof EntityFrostmaw) && !(nearbyEntity instanceof VillagerEntity)) continue;
            return false;
        }
        return super.func_213380_a(world, reason);
    }

    public int func_70641_bl() {
        return 1;
    }

    @Override
    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData livingData, @Nullable CompoundNBT compound) {
        this.setHasCrystal(true);
        return super.func_213386_a(world, difficulty, reason, livingData, compound);
    }

    private void spawnSwipeParticles() {
        if (this.field_70170_p.field_72995_K && this.getHasCrystal()) {
            double motionX = this.func_213322_ci().func_82615_a();
            double motionY = this.func_213322_ci().func_82617_b();
            double motionZ = this.func_213322_ci().func_82616_c();
            int snowflakeDensity = 4;
            float snowflakeRandomness = 0.5f;
            int cloudDensity = 2;
            float cloudRandomness = 0.5f;
            if (this.getAnimation() == SWIPE_ANIMATION || this.getAnimation() == SWIPE_TWICE_ANIMATION) {
                Vector3d rightHandPos = this.socketPosArray[0];
                Vector3d leftHandPos = this.socketPosArray[1];
                if (this.getAnimation() == SWIPE_ANIMATION) {
                    if (this.getAnimationTick() > 8 && this.getAnimationTick() < 14) {
                        if (this.swingWhichArm) {
                            double length = this.prevRightHandPos.func_178788_d(rightHandPos).func_72433_c();
                            int numClouds = (int)Math.floor(2.0 * length);
                            for (int i = 0; i < numClouds; ++i) {
                                float zOffset;
                                float yOffset;
                                float xOffset;
                                int j;
                                double x = this.prevRightHandPos.field_72450_a + (double)i * (rightHandPos.field_72450_a - this.prevRightHandPos.field_72450_a) / (double)numClouds;
                                double y = this.prevRightHandPos.field_72448_b + (double)i * (rightHandPos.field_72448_b - this.prevRightHandPos.field_72448_b) / (double)numClouds;
                                double z = this.prevRightHandPos.field_72449_c + (double)i * (rightHandPos.field_72449_c - this.prevRightHandPos.field_72449_c) / (double)numClouds;
                                for (j = 0; j < snowflakeDensity; ++j) {
                                    xOffset = snowflakeRandomness * (2.0f * this.field_70146_Z.nextFloat() - 1.0f);
                                    yOffset = snowflakeRandomness * (2.0f * this.field_70146_Z.nextFloat() - 1.0f);
                                    zOffset = snowflakeRandomness * (2.0f * this.field_70146_Z.nextFloat() - 1.0f);
                                    this.field_70170_p.func_195594_a((IParticleData)new ParticleSnowFlake.SnowflakeData(40.0f, false), x + (double)xOffset, y + (double)yOffset, z + (double)zOffset, motionX, motionY - (double)0.01f, motionZ);
                                }
                                for (j = 0; j < cloudDensity; ++j) {
                                    xOffset = cloudRandomness * (2.0f * this.field_70146_Z.nextFloat() - 1.0f);
                                    yOffset = cloudRandomness * (2.0f * this.field_70146_Z.nextFloat() - 1.0f);
                                    zOffset = cloudRandomness * (2.0f * this.field_70146_Z.nextFloat() - 1.0f);
                                    float value = this.field_70146_Z.nextFloat() * 0.1f;
                                    this.field_70170_p.func_195594_a((IParticleData)new ParticleCloud.CloudData((ParticleType<ParticleCloud.CloudData>)((ParticleType)ParticleHandler.CLOUD.get()), 0.8f + value, 0.8f + value, 1.0f, (float)(10.0 + this.field_70146_Z.nextDouble() * 10.0), 40, ParticleCloud.EnumCloudBehavior.SHRINK, 1.0f), x + (double)xOffset, y + (double)yOffset, z + (double)zOffset, motionX, motionY, motionZ);
                                }
                            }
                        } else {
                            double length = this.prevLeftHandPos.func_178788_d(leftHandPos).func_72433_c();
                            int numClouds = (int)Math.floor(2.5 * length);
                            for (int i = 0; i < numClouds; ++i) {
                                float zOffset;
                                float yOffset;
                                float xOffset;
                                int j;
                                double x = this.prevLeftHandPos.field_72450_a + (double)i * (leftHandPos.field_72450_a - this.prevLeftHandPos.field_72450_a) / (double)numClouds;
                                double y = this.prevLeftHandPos.field_72448_b + (double)i * (leftHandPos.field_72448_b - this.prevLeftHandPos.field_72448_b) / (double)numClouds;
                                double z = this.prevLeftHandPos.field_72449_c + (double)i * (leftHandPos.field_72449_c - this.prevLeftHandPos.field_72449_c) / (double)numClouds;
                                for (j = 0; j < snowflakeDensity; ++j) {
                                    xOffset = snowflakeRandomness * (2.0f * this.field_70146_Z.nextFloat() - 1.0f);
                                    yOffset = snowflakeRandomness * (2.0f * this.field_70146_Z.nextFloat() - 1.0f);
                                    zOffset = snowflakeRandomness * (2.0f * this.field_70146_Z.nextFloat() - 1.0f);
                                    this.field_70170_p.func_195594_a((IParticleData)new ParticleSnowFlake.SnowflakeData(40.0f, false), x + (double)xOffset, y + (double)yOffset, z + (double)zOffset, motionX, motionY - (double)0.01f, motionZ);
                                }
                                for (j = 0; j < cloudDensity; ++j) {
                                    xOffset = cloudRandomness * (2.0f * this.field_70146_Z.nextFloat() - 1.0f);
                                    yOffset = cloudRandomness * (2.0f * this.field_70146_Z.nextFloat() - 1.0f);
                                    zOffset = cloudRandomness * (2.0f * this.field_70146_Z.nextFloat() - 1.0f);
                                    float value = this.field_70146_Z.nextFloat() * 0.1f;
                                    this.field_70170_p.func_195594_a((IParticleData)new ParticleCloud.CloudData((ParticleType<ParticleCloud.CloudData>)((ParticleType)ParticleHandler.CLOUD.get()), 0.8f + value, 0.8f + value, 1.0f, (float)(10.0 + this.field_70146_Z.nextDouble() * 10.0), 40, ParticleCloud.EnumCloudBehavior.SHRINK, 1.0f), x + (double)xOffset, y + (double)yOffset, z + (double)zOffset, motionX, motionY, motionZ);
                                }
                            }
                        }
                    }
                } else if (this.swingWhichArm && this.getAnimationTick() > 8 && this.getAnimationTick() < 14 || !this.swingWhichArm && this.getAnimationTick() > 19 && this.getAnimationTick() < 25) {
                    double length = this.prevRightHandPos.func_178788_d(rightHandPos).func_72433_c();
                    int numClouds = (int)Math.floor(2.0 * length);
                    for (int i = 0; i < numClouds; ++i) {
                        float zOffset;
                        float yOffset;
                        float xOffset;
                        int j;
                        double x = this.prevRightHandPos.field_72450_a + (double)i * (rightHandPos.field_72450_a - this.prevRightHandPos.field_72450_a) / (double)numClouds;
                        double y = this.prevRightHandPos.field_72448_b + (double)i * (rightHandPos.field_72448_b - this.prevRightHandPos.field_72448_b) / (double)numClouds;
                        double z = this.prevRightHandPos.field_72449_c + (double)i * (rightHandPos.field_72449_c - this.prevRightHandPos.field_72449_c) / (double)numClouds;
                        for (j = 0; j < snowflakeDensity; ++j) {
                            xOffset = snowflakeRandomness * (2.0f * this.field_70146_Z.nextFloat() - 1.0f);
                            yOffset = snowflakeRandomness * (2.0f * this.field_70146_Z.nextFloat() - 1.0f);
                            zOffset = snowflakeRandomness * (2.0f * this.field_70146_Z.nextFloat() - 1.0f);
                            this.field_70170_p.func_195594_a((IParticleData)new ParticleSnowFlake.SnowflakeData(40.0f, false), x + (double)xOffset, y + (double)yOffset, z + (double)zOffset, motionX, motionY - (double)0.01f, motionZ);
                        }
                        for (j = 0; j < cloudDensity; ++j) {
                            xOffset = cloudRandomness * (2.0f * this.field_70146_Z.nextFloat() - 1.0f);
                            yOffset = cloudRandomness * (2.0f * this.field_70146_Z.nextFloat() - 1.0f);
                            zOffset = cloudRandomness * (2.0f * this.field_70146_Z.nextFloat() - 1.0f);
                            float value = this.field_70146_Z.nextFloat() * 0.1f;
                            this.field_70170_p.func_195594_a((IParticleData)new ParticleCloud.CloudData((ParticleType<ParticleCloud.CloudData>)((ParticleType)ParticleHandler.CLOUD.get()), 0.8f + value, 0.8f + value, 1.0f, (float)(10.0 + this.field_70146_Z.nextDouble() * 10.0), 40, ParticleCloud.EnumCloudBehavior.SHRINK, 1.0f), x + (double)xOffset, y + (double)yOffset, z + (double)zOffset, motionX, motionY, motionZ);
                        }
                    }
                } else if (!this.swingWhichArm && this.getAnimationTick() > 8 && this.getAnimationTick() < 14 || this.swingWhichArm && this.getAnimationTick() > 19 && this.getAnimationTick() < 25) {
                    double length = this.prevLeftHandPos.func_178788_d(leftHandPos).func_72433_c();
                    int numClouds = (int)Math.floor(2.5 * length);
                    for (int i = 0; i < numClouds; ++i) {
                        float zOffset;
                        float yOffset;
                        float xOffset;
                        int j;
                        double x = this.prevLeftHandPos.field_72450_a + (double)i * (leftHandPos.field_72450_a - this.prevLeftHandPos.field_72450_a) / (double)numClouds;
                        double y = this.prevLeftHandPos.field_72448_b + (double)i * (leftHandPos.field_72448_b - this.prevLeftHandPos.field_72448_b) / (double)numClouds;
                        double z = this.prevLeftHandPos.field_72449_c + (double)i * (leftHandPos.field_72449_c - this.prevLeftHandPos.field_72449_c) / (double)numClouds;
                        for (j = 0; j < snowflakeDensity; ++j) {
                            xOffset = snowflakeRandomness * (2.0f * this.field_70146_Z.nextFloat() - 1.0f);
                            yOffset = snowflakeRandomness * (2.0f * this.field_70146_Z.nextFloat() - 1.0f);
                            zOffset = snowflakeRandomness * (2.0f * this.field_70146_Z.nextFloat() - 1.0f);
                            this.field_70170_p.func_195594_a((IParticleData)new ParticleSnowFlake.SnowflakeData(40.0f, false), x + (double)xOffset, y + (double)yOffset, z + (double)zOffset, motionX, motionY - (double)0.01f, motionZ);
                        }
                        for (j = 0; j < cloudDensity; ++j) {
                            xOffset = cloudRandomness * (2.0f * this.field_70146_Z.nextFloat() - 1.0f);
                            yOffset = cloudRandomness * (2.0f * this.field_70146_Z.nextFloat() - 1.0f);
                            zOffset = cloudRandomness * (2.0f * this.field_70146_Z.nextFloat() - 1.0f);
                            float value = this.field_70146_Z.nextFloat() * 0.1f;
                            this.field_70170_p.func_195594_a((IParticleData)new ParticleCloud.CloudData((ParticleType<ParticleCloud.CloudData>)((ParticleType)ParticleHandler.CLOUD.get()), 0.8f + value, 0.8f + value, 1.0f, (float)(10.0 + this.field_70146_Z.nextDouble() * 10.0), 40, ParticleCloud.EnumCloudBehavior.SHRINK, 1.0f), x + (double)xOffset, y + (double)yOffset, z + (double)zOffset, motionX, motionY, motionZ);
                        }
                    }
                }
                this.prevLeftHandPos = leftHandPos;
                this.prevRightHandPos = rightHandPos;
            }
        }
    }

    @Override
    public boolean func_70097_a(DamageSource source, float damage) {
        if (source == DamageSource.field_76379_h) {
            return false;
        }
        if (source == DamageSource.field_76371_c && this.getAnimation() == NO_ANIMATION) {
            AnimationHandler.INSTANCE.sendAnimationMessage(this, DODGE_ANIMATION);
        }
        if (source.func_76347_k()) {
            damage = (float)((double)damage * 1.25);
        }
        if (source.func_76364_f() instanceof AbstractArrowEntity) {
            this.func_184185_a(SoundEvents.field_187689_f, 0.4f, 2.0f);
            Entity entity = source.func_76346_g();
            if (!(entity == null || !(entity instanceof LivingEntity) || entity instanceof PlayerEntity && ((PlayerEntity)entity).func_184812_l_() || this.func_70638_az() != null || entity instanceof EntityFrostmaw)) {
                this.func_70624_b((LivingEntity)entity);
            }
            if (!this.getActive()) {
                if (this.getAnimation() != DIE_ANIMATION && this.field_70170_p.func_175659_aa() != Difficulty.PEACEFUL) {
                    if (this.getHasCrystal()) {
                        AnimationHandler.INSTANCE.sendAnimationMessage(this, ACTIVATE_ANIMATION);
                    } else {
                        AnimationHandler.INSTANCE.sendAnimationMessage(this, ACTIVATE_NO_CRYSTAL_ANIMATION);
                    }
                }
                if (this.field_70170_p.func_175659_aa() != Difficulty.PEACEFUL) {
                    this.setActive(true);
                }
            }
            return false;
        }
        boolean attack = super.func_70097_a(source, damage);
        if (attack) {
            this.shouldDodgeMeasure = (int)((float)this.shouldDodgeMeasure + damage);
            Entity entity = source.func_76346_g();
            if (!(entity == null || !(entity instanceof LivingEntity) || entity instanceof PlayerEntity && ((PlayerEntity)entity).func_184812_l_() || this.func_70638_az() != null || entity instanceof EntityFrostmaw)) {
                this.func_70624_b((LivingEntity)entity);
            }
            if (!this.getActive()) {
                if (this.getAnimation() != DIE_ANIMATION && this.field_70170_p.func_175659_aa() != Difficulty.PEACEFUL) {
                    if (this.getHasCrystal()) {
                        AnimationHandler.INSTANCE.sendAnimationMessage(this, ACTIVATE_ANIMATION);
                    } else {
                        AnimationHandler.INSTANCE.sendAnimationMessage(this, ACTIVATE_NO_CRYSTAL_ANIMATION);
                    }
                }
                if (this.field_70170_p.func_175659_aa() != Difficulty.PEACEFUL) {
                    this.setActive(true);
                }
            }
        }
        return attack;
    }

    @Override
    protected void onDeathAIUpdate() {
        super.onDeathAIUpdate();
        if (this.getAnimationTick() == 5) {
            this.func_184185_a((SoundEvent)MMSounds.ENTITY_FROSTMAW_DIE.get(), 2.5f, 1.0f);
        } else if (this.getAnimationTick() == 53) {
            this.func_184185_a((SoundEvent)MMSounds.ENTITY_FROSTMAW_LAND.get(), 2.5f, 1.0f);
        }
    }

    @Override
    public Animation getDeathAnimation() {
        return DIE_ANIMATION;
    }

    @Override
    public Animation getHurtAnimation() {
        return HURT_ANIMATION;
    }

    public void setActive(boolean active) {
        this.func_184212_Q().func_187227_b(ACTIVE, (Object)active);
    }

    public boolean getActive() {
        this.active = (Boolean)this.func_184212_Q().func_187225_a(ACTIVE);
        return this.active;
    }

    public void setHasCrystal(boolean hasCrystal) {
        this.func_184212_Q().func_187227_b(HAS_CRYSTAL, (Object)hasCrystal);
    }

    public boolean getHasCrystal() {
        return (Boolean)this.func_184212_Q().func_187225_a(HAS_CRYSTAL);
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{DIE_ANIMATION, HURT_ANIMATION, ROAR_ANIMATION, SWIPE_ANIMATION, SWIPE_TWICE_ANIMATION, ICE_BREATH_ANIMATION, ICE_BALL_ANIMATION, ACTIVATE_ANIMATION, ACTIVATE_NO_CRYSTAL_ANIMATION, DEACTIVATE_ANIMATION, SLAM_ANIMATION, LAND_ANIMATION, DODGE_ANIMATION};
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setHasCrystal(compound.func_74767_n("has_crystal"));
        this.setActive(compound.func_74767_n("active"));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("has_crystal", this.getHasCrystal());
        compound.func_74757_a("active", this.getActive());
    }

    public boolean func_213392_I() {
        return this.getHasCrystal();
    }

    @Override
    protected boolean hasBossBar() {
        return (Boolean)ConfigHandler.COMMON.MOBS.FROSTMAW.hasBossBar.get();
    }

    @Override
    protected BossInfo.Color bossBarColor() {
        return BossInfo.Color.WHITE;
    }

    protected ResourceLocation func_184647_J() {
        return LootTableHandler.FROSTMAW;
    }

    public Vector3d func_213322_ci() {
        if (!this.getActive()) {
            return super.func_213322_ci().func_216372_d(0.0, 1.0, 0.0);
        }
        return super.func_213322_ci();
    }

    @Override
    public SoundEvent getBossMusic() {
        return (SoundEvent)MMSounds.MUSIC_FROSTMAW_THEME.get();
    }

    @Override
    protected boolean canPlayMusic() {
        return super.canPlayMusic() && (this.active || this.getAnimation() == ACTIVATE_ANIMATION);
    }
}

