/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.world.spawn;

import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.MowzieEntity;
import com.bobmowzie.mowziesmobs.server.world.BiomeChecker;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.spawner.WorldEntitySpawner;
import net.minecraftforge.common.util.TriPredicate;
import net.minecraftforge.event.world.BiomeLoadingEvent;

public class SpawnHandler {
    public static final Map<EntityType<?>, ConfigHandler.SpawnConfig> spawnConfigs = new HashMap();

    public static void registerSpawnPlacementTypes() {
        EntitySpawnPlacementRegistry.PlacementType.create((String)"MMSPAWN", (TriPredicate)new TriPredicate<IWorldReader, BlockPos, EntityType<? extends MobEntity>>(){

            public boolean test(IWorldReader t, BlockPos pos, EntityType<? extends MobEntity> entityType) {
                BlockState block = t.func_180495_p(pos.func_177977_b());
                if (block.func_177230_c() == Blocks.field_150357_h || block.func_177230_c() == Blocks.field_180401_cv || !block.func_185904_a().func_76230_c()) {
                    return false;
                }
                BlockState iblockstateUp = t.func_180495_p(pos);
                BlockState iblockstateUp2 = t.func_180495_p(pos.func_177984_a());
                return WorldEntitySpawner.func_234968_a_((IBlockReader)t, (BlockPos)pos, (BlockState)iblockstateUp, (FluidState)iblockstateUp.func_204520_s(), entityType) && WorldEntitySpawner.func_234968_a_((IBlockReader)t, (BlockPos)pos.func_177984_a(), (BlockState)iblockstateUp2, (FluidState)iblockstateUp2.func_204520_s(), entityType);
            }
        });
        EntitySpawnPlacementRegistry.PlacementType mmSpawn = EntitySpawnPlacementRegistry.PlacementType.valueOf((String)"MMSPAWN");
        if (mmSpawn != null) {
            EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityHandler.FOLIAATH.get()), (EntitySpawnPlacementRegistry.PlacementType)mmSpawn, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING, MowzieEntity::spawnPredicate);
            EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityHandler.LANTERN.get()), (EntitySpawnPlacementRegistry.PlacementType)mmSpawn, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING, MowzieEntity::spawnPredicate);
            EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityHandler.BARAKOANA.get()), (EntitySpawnPlacementRegistry.PlacementType)mmSpawn, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MowzieEntity::spawnPredicate);
            EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityHandler.NAGA.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.NO_RESTRICTIONS, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING, MowzieEntity::spawnPredicate);
            EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityHandler.GROTTOL.get()), (EntitySpawnPlacementRegistry.PlacementType)mmSpawn, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MowzieEntity::spawnPredicate);
            EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityHandler.BARAKOAYA.get()), (EntitySpawnPlacementRegistry.PlacementType)mmSpawn, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MowzieEntity::spawnPredicate);
        }
    }

    public static void onBiomeLoading(BiomeLoadingEvent event) {
        ResourceLocation biomeName = event.getName();
        if (biomeName == null) {
            return;
        }
        if ((Integer)ConfigHandler.COMMON.MOBS.FOLIAATH.spawnConfig.spawnRate.get() > 0 && BiomeChecker.isBiomeInConfig(ConfigHandler.COMMON.MOBS.FOLIAATH.spawnConfig.biomeConfig, biomeName)) {
            SpawnHandler.registerEntityWorldSpawn((EntityType)EntityHandler.FOLIAATH.get(), ConfigHandler.COMMON.MOBS.FOLIAATH.spawnConfig, EntityClassification.MONSTER, event);
        }
        if ((Integer)ConfigHandler.COMMON.MOBS.BARAKOA.spawnConfig.spawnRate.get() > 0 && BiomeChecker.isBiomeInConfig(ConfigHandler.COMMON.MOBS.BARAKOA.spawnConfig.biomeConfig, biomeName)) {
            SpawnHandler.registerEntityWorldSpawn((EntityType)EntityHandler.BARAKOANA.get(), ConfigHandler.COMMON.MOBS.BARAKOA.spawnConfig, EntityClassification.MONSTER, event);
        }
        if ((Integer)ConfigHandler.COMMON.MOBS.GROTTOL.spawnConfig.spawnRate.get() > 0 && BiomeChecker.isBiomeInConfig(ConfigHandler.COMMON.MOBS.GROTTOL.spawnConfig.biomeConfig, biomeName)) {
            SpawnHandler.registerEntityWorldSpawn((EntityType)EntityHandler.GROTTOL.get(), ConfigHandler.COMMON.MOBS.GROTTOL.spawnConfig, EntityClassification.MONSTER, event);
        }
        if ((Integer)ConfigHandler.COMMON.MOBS.LANTERN.spawnConfig.spawnRate.get() > 0 && BiomeChecker.isBiomeInConfig(ConfigHandler.COMMON.MOBS.LANTERN.spawnConfig.biomeConfig, biomeName)) {
            SpawnHandler.registerEntityWorldSpawn((EntityType)EntityHandler.LANTERN.get(), ConfigHandler.COMMON.MOBS.LANTERN.spawnConfig, EntityClassification.AMBIENT, event);
        }
        if ((Integer)ConfigHandler.COMMON.MOBS.NAGA.spawnConfig.spawnRate.get() > 0 && BiomeChecker.isBiomeInConfig(ConfigHandler.COMMON.MOBS.NAGA.spawnConfig.biomeConfig, biomeName)) {
            SpawnHandler.registerEntityWorldSpawn((EntityType)EntityHandler.NAGA.get(), ConfigHandler.COMMON.MOBS.NAGA.spawnConfig, EntityClassification.MONSTER, event);
        }
    }

    private static void registerEntityWorldSpawn(EntityType<?> entity, ConfigHandler.SpawnConfig spawnConfig, EntityClassification classification, BiomeLoadingEvent event) {
        event.getSpawns().getSpawner(classification).add(new MobSpawnInfo.Spawners(entity, ((Integer)spawnConfig.spawnRate.get()).intValue(), ((Integer)spawnConfig.minGroupSize.get()).intValue(), ((Integer)spawnConfig.maxGroupSize.get()).intValue()));
    }

    static {
        spawnConfigs.put((EntityType<?>)EntityHandler.FOLIAATH.get(), ConfigHandler.COMMON.MOBS.FOLIAATH.spawnConfig);
        spawnConfigs.put((EntityType<?>)EntityHandler.BARAKOANA.get(), ConfigHandler.COMMON.MOBS.BARAKOA.spawnConfig);
        spawnConfigs.put((EntityType<?>)EntityHandler.LANTERN.get(), ConfigHandler.COMMON.MOBS.LANTERN.spawnConfig);
        spawnConfigs.put((EntityType<?>)EntityHandler.NAGA.get(), ConfigHandler.COMMON.MOBS.NAGA.spawnConfig);
        spawnConfigs.put((EntityType<?>)EntityHandler.GROTTOL.get(), ConfigHandler.COMMON.MOBS.GROTTOL.spawnConfig);
    }
}

