/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.neapolitan.common.block;

import com.minecraftabnormals.neapolitan.core.registry.NeapolitanBlocks;
import com.minecraftabnormals.neapolitan.core.registry.NeapolitanItems;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BoneMealItem;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;

public class AdzukiSproutsBlock
extends BushBlock
implements IPlantable,
IGrowable {
    public static final IntegerProperty AGE = IntegerProperty.func_177719_a((String)"age", (int)0, (int)6);
    public static final BooleanProperty FLOWERING = BooleanProperty.func_177716_a((String)"flowering");
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0), Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)6.0, (double)14.0), Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0), Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0), Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0), Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0), Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0)};

    public AdzukiSproutsBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)AGE, (Comparable)Integer.valueOf(0))).func_206870_a((Property)FLOWERING, (Comparable)Boolean.valueOf(false)));
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        super.func_196262_a(state, worldIn, pos, entityIn);
        if (entityIn instanceof AnimalEntity && !((Boolean)state.func_177229_b((Property)FLOWERING)).booleanValue()) {
            worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)FLOWERING, (Comparable)Boolean.valueOf(true)));
            if (worldIn.func_201670_d()) {
                BoneMealItem.func_195965_a((IWorld)worldIn, (BlockPos)pos, (int)0);
            }
        }
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return new ItemStack((IItemProvider)NeapolitanItems.ADZUKI_BEANS.get());
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        int speed;
        if (!worldIn.isAreaLoaded(pos, 1)) {
            return;
        }
        int i = (Integer)state.func_177229_b((Property)AGE);
        int n = speed = (Boolean)state.func_177229_b((Property)FLOWERING) != false ? 3 : 6;
        if (worldIn.func_226659_b_(pos, 0) >= 9 && !this.isMaxAge(state) && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (BlockState)state, (random.nextInt(speed) == 0 ? 1 : 0) != 0)) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
            ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (BlockState)state);
        }
    }

    public void func_220062_a(BlockState state, ServerWorld level, BlockPos pos, ItemStack stack) {
        super.func_220062_a(state, level, pos, stack);
        this.replant(state, (World)level, pos);
    }

    public void func_176208_a(World level, BlockPos pos, BlockState state, PlayerEntity player) {
        super.func_176208_a(level, pos, state, player);
        this.replant(state, level, pos);
    }

    private void replant(BlockState state, World level, BlockPos pos) {
        BlockState downState = level.func_180495_p(pos.func_177977_b());
        if (this.isMaxAge(state) && (downState.func_203425_a(Blocks.field_150346_d) || downState.func_203425_a(Blocks.field_196660_k) || downState.func_203425_a(Blocks.field_196658_i))) {
            level.func_175656_a(pos.func_177977_b(), ((Block)NeapolitanBlocks.ADZUKI_SOIL.get()).func_176223_P());
        }
    }

    public boolean isMaxAge(BlockState state) {
        return (Integer)state.func_177229_b((Property)AGE) >= 6;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{AGE, FLOWERING});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE_BY_AGE[(Integer)state.func_177229_b((Property)AGE)];
    }

    public boolean func_176473_a(IBlockReader block, BlockPos pos, BlockState state, boolean isClient) {
        return !this.isMaxAge(state);
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void func_225535_a_(ServerWorld worldIn, Random rand, BlockPos pos, BlockState state) {
        int i = Math.min(6, (Integer)state.func_177229_b((Property)AGE) + 1);
        worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(i)), 2);
    }

    protected boolean func_200014_a_(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return state.func_203425_a((Block)NeapolitanBlocks.ADZUKI_SOIL.get()) || super.func_200014_a_(state, worldIn, pos);
    }
}

