/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.neapolitan.common.entity.goals;

import com.minecraftabnormals.neapolitan.common.entity.ChimpanzeeEntity;
import com.minecraftabnormals.neapolitan.common.entity.util.ChimpanzeeAction;
import com.minecraftabnormals.neapolitan.core.other.NeapolitanTags;
import com.minecraftabnormals.neapolitan.core.registry.NeapolitanItems;
import java.util.EnumSet;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.FireworkRocketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.TieredItem;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;

public class ChimpLookAtItemGoal
extends Goal {
    private final ChimpanzeeEntity chimpanzee;
    private ItemStack itemStack;
    private int lookTimer;
    private boolean wasHurt;

    public ChimpLookAtItemGoal(ChimpanzeeEntity chimpanzeeIn) {
        this.chimpanzee = chimpanzeeIn;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        if (!this.chimpanzee.isDoingAction(ChimpanzeeAction.DEFAULT)) {
            return false;
        }
        if (!this.chimpanzee.func_70661_as().func_75500_f()) {
            return false;
        }
        if (this.chimpanzee.func_70681_au().nextInt(160) > 0) {
            return false;
        }
        ItemStack mainhanditem = this.chimpanzee.func_184614_ca();
        ItemStack offhanditem = this.chimpanzee.func_184592_cb();
        if (!mainhanditem.func_190926_b()) {
            if (this.shouldLookAtItem(mainhanditem)) {
                this.itemStack = mainhanditem;
                return true;
            }
        } else if (!offhanditem.func_190926_b() && this.shouldLookAtItem(offhanditem)) {
            this.chimpanzee.func_184611_a(Hand.MAIN_HAND, offhanditem);
            this.chimpanzee.func_184611_a(Hand.OFF_HAND, ItemStack.field_190927_a);
            this.itemStack = offhanditem;
            return true;
        }
        return false;
    }

    public void func_75249_e() {
        this.lookTimer = 60 + this.chimpanzee.func_70681_au().nextInt(60);
        this.wasHurt = false;
        this.chimpanzee.setAction(ChimpanzeeAction.LOOKING_AT_ITEM);
        this.chimpanzee.func_70661_as().func_75499_g();
    }

    public boolean func_75253_b() {
        if (this.chimpanzee.func_184614_ca() != this.itemStack) {
            return false;
        }
        return this.lookTimer > 0;
    }

    public void func_75251_c() {
        this.chimpanzee.setDefaultAction();
    }

    public void func_75246_d() {
        --this.lookTimer;
        if (this.lookTimer == 0) {
            this.doItemInteraction();
        } else if (this.chimpanzee.isDoingAction(ChimpanzeeAction.PLAYING_WITH_ITEM)) {
            if (this.lookTimer == 20) {
                if (this.chimpanzee.func_70681_au().nextInt(10) == 0 && this.itemStack.func_77973_b().func_206844_a(NeapolitanTags.Items.CHIMPANZEE_SHAKEABLE_BUCKETS)) {
                    this.chimpanzee.spawnItemFromBucket(new ItemStack((IItemProvider)NeapolitanItems.BANANA.get()), this.chimpanzee.func_184591_cq());
                }
            } else if (this.lookTimer == 4) {
                if (this.itemStack.func_77973_b() instanceof TieredItem) {
                    this.chimpanzee.func_70097_a(DamageSource.field_76377_j, 0.0f);
                    this.wasHurt = true;
                } else if (this.itemStack.func_77973_b() instanceof FireworkRocketItem) {
                    this.chimpanzee.setOffFirework(this.itemStack, this.chimpanzee.func_184591_cq());
                    this.chimpanzee.func_184614_ca().func_190918_g(1);
                    this.itemStack = this.chimpanzee.func_184614_ca();
                }
            }
        }
    }

    private void doItemInteraction() {
        Item item = this.itemStack.func_77973_b();
        if (item.func_206844_a(NeapolitanTags.Items.CHIMPANZEE_APE_MODE_ITEMS) && this.chimpanzee.getApeModeTime() <= 0) {
            this.lookTimer = 40;
            this.chimpanzee.setApeModeTime(1200 + this.chimpanzee.func_70681_au().nextInt(1200));
        } else if (this.shouldPlayWithItem(item) && this.chimpanzee.isDoingAction(ChimpanzeeAction.LOOKING_AT_ITEM)) {
            this.lookTimer = 60 + this.chimpanzee.func_70681_au().nextInt(20);
            this.chimpanzee.setAction(ChimpanzeeAction.PLAYING_WITH_ITEM);
        } else {
            if (!this.chimpanzee.func_70631_g_() && item instanceof ArmorItem && ((ArmorItem)item).func_185083_B_() == EquipmentSlotType.HEAD && this.chimpanzee.func_184582_a(EquipmentSlotType.HEAD).func_190926_b()) {
                this.chimpanzee.func_184201_a(EquipmentSlotType.HEAD, this.itemStack);
                this.chimpanzee.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
                this.chimpanzee.func_184642_a(EquipmentSlotType.HEAD, 2.0f);
                this.playEquipSound(item);
            } else if (this.chimpanzee.func_184614_ca() == this.itemStack) {
                this.chimpanzee.throwHeldItem(Hand.MAIN_HAND);
            }
            if (this.wasHurt) {
                this.runAway();
            }
            this.chimpanzee.setDefaultAction();
        }
    }

    private void playEquipSound(Item item) {
        SoundEvent soundevent = ((ArmorItem)item).func_200880_d().func_200899_b();
        this.chimpanzee.func_184185_a(soundevent, 1.0f, 1.0f);
    }

    private void runAway() {
        Vector3d vector3d = RandomPositionGenerator.func_75463_a((CreatureEntity)this.chimpanzee, (int)10, (int)5);
        if (vector3d != null) {
            this.chimpanzee.func_70661_as().func_75492_a(vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c, 1.25);
        }
        this.chimpanzee.func_70683_ar().func_75660_a();
        this.chimpanzee.playScreamSound();
    }

    private boolean shouldLookAtItem(ItemStack itemStackIn) {
        return !this.chimpanzee.isSnack(itemStackIn) && !this.chimpanzee.isFavoriteItem(itemStackIn);
    }

    private boolean shouldPlayWithItem(Item item) {
        return item instanceof TieredItem || item instanceof FireworkRocketItem || item.func_206844_a(NeapolitanTags.Items.CHIMPANZEE_SHAKEABLE_BUCKETS);
    }
}

