/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.neapolitan.common.entity.goals;

import com.minecraftabnormals.neapolitan.common.entity.ChimpanzeeEntity;
import com.minecraftabnormals.neapolitan.common.entity.util.ChimpanzeeAction;
import java.util.EnumSet;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.NoteBlock;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.state.Property;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class ChimpPlayNoteBlockGoal
extends MoveToBlockGoal {
    private final ChimpanzeeEntity chimpanzee;
    private int timePlayed;
    private int noteTime;

    public ChimpPlayNoteBlockGoal(ChimpanzeeEntity chimpanzeeIn, double speed, int length) {
        super((CreatureEntity)chimpanzeeIn, speed, length, 6);
        this.chimpanzee = chimpanzeeIn;
        this.func_220684_a(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        if (this.chimpanzee.func_184218_aH()) {
            return false;
        }
        if (!this.chimpanzee.isDoingAction(ChimpanzeeAction.DEFAULT, ChimpanzeeAction.CLIMBING)) {
            return false;
        }
        if (this.chimpanzee.func_70681_au().nextInt(1200) != 0) {
            return false;
        }
        return this.func_179489_g();
    }

    public boolean func_75253_b() {
        if (this.timePlayed > 320 && this.chimpanzee.func_70681_au().nextInt(250) == 0) {
            return false;
        }
        if (this.chimpanzee.func_184218_aH()) {
            return false;
        }
        if (!(this.timePlayed <= 0 || this.func_179487_f() && this.chimpanzee.isSitting())) {
            return false;
        }
        return super.func_75253_b();
    }

    public void func_75249_e() {
        super.func_75249_e();
        this.noteTime = 20;
    }

    public void func_75251_c() {
        super.func_75251_c();
        this.timePlayed = 0;
        this.chimpanzee.setDefaultAction();
        if (this.chimpanzee.canStandUp()) {
            this.chimpanzee.setSitting(false);
        }
    }

    public void func_75246_d() {
        super.func_75246_d();
        this.chimpanzee.func_70671_ap().func_75650_a((double)this.field_179494_b.func_177958_n() + 0.5, (double)this.field_179494_b.func_177956_o() + 0.5, (double)this.field_179494_b.func_177952_p() + 0.5, (float)(this.chimpanzee.func_184649_cE() + 20), (float)this.chimpanzee.func_70646_bf());
        if (this.func_179487_f() && this.chimpanzee.func_70661_as().func_75500_f() && this.chimpanzee.getAction().canBeInterrupted()) {
            this.chimpanzee.setAction(ChimpanzeeAction.DRUMMING);
            this.chimpanzee.setSitting(true);
            if (--this.noteTime <= 0) {
                if (ForgeEventFactory.getMobGriefingEvent((World)this.chimpanzee.field_70170_p, (Entity)this.chimpanzee)) {
                    BlockState state = this.chimpanzee.field_70170_p.func_180495_p(this.field_179494_b);
                    int note = (Integer)state.func_177229_b((Property)NoteBlock.field_196485_c);
                    note = MathHelper.func_76125_a((int)(note + this.chimpanzee.func_70681_au().nextInt(7) - 3), (int)0, (int)24);
                    this.chimpanzee.field_70170_p.func_180501_a(this.field_179494_b, (BlockState)state.func_206870_a((Property)NoteBlock.field_196485_c, (Comparable)Integer.valueOf(note)), 3);
                }
                this.chimpanzee.field_70170_p.func_175641_c(this.field_179494_b, Blocks.field_196586_al, 0, 0);
                this.noteTime = 8 + this.chimpanzee.func_70681_au().nextInt(5);
            }
            ++this.timePlayed;
        }
    }

    protected boolean func_179488_a(IWorldReader worldIn, BlockPos pos) {
        return worldIn.func_175623_d(pos.func_177984_a()) && worldIn.func_175623_d(pos.func_177984_a().func_177984_a()) && worldIn.func_180495_p(pos).func_177230_c() == Blocks.field_196586_al && !this.isBlockBeingPlayed((World)worldIn, pos);
    }

    private boolean isBlockBeingPlayed(World worldIn, BlockPos pos) {
        return !worldIn.func_175647_a(ChimpanzeeEntity.class, new AxisAlignedBB(pos.func_177984_a()), chimpanzee -> chimpanzee != this.chimpanzee && chimpanzee.isDoingAction(ChimpanzeeAction.DRUMMING)).isEmpty();
    }
}

