/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.neapolitan.common.entity.goals;

import com.minecraftabnormals.neapolitan.common.entity.BananaPeelEntity;
import com.minecraftabnormals.neapolitan.common.entity.ChimpanzeeEntity;
import com.minecraftabnormals.neapolitan.common.entity.util.ChimpanzeeAction;
import com.minecraftabnormals.neapolitan.core.registry.NeapolitanBlocks;
import com.minecraftabnormals.neapolitan.core.registry.NeapolitanEntities;
import com.minecraftabnormals.neapolitan.core.registry.NeapolitanItems;
import java.util.EnumSet;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class ChimpShakeBundleGoal
extends MoveToBlockGoal {
    private final ChimpanzeeEntity chimpanzee;
    private BlockPos bundlePos = BlockPos.field_177992_a;
    private int shakingTime;
    private int nextBananaTime;

    public ChimpShakeBundleGoal(ChimpanzeeEntity chimpanzeeIn, double speed, int length, int yMax) {
        super((CreatureEntity)chimpanzeeIn, speed, length, yMax);
        this.chimpanzee = chimpanzeeIn;
        this.func_220684_a(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        if (this.chimpanzee.isDirty() || this.chimpanzee.needsSunlight()) {
            return false;
        }
        if (!this.chimpanzee.needsSnack()) {
            return false;
        }
        if (this.chimpanzee.func_70631_g_()) {
            return false;
        }
        if (this.chimpanzee.func_184218_aH()) {
            return false;
        }
        return super.func_75250_a();
    }

    public boolean func_75253_b() {
        if (this.shakingTime > 160) {
            return false;
        }
        if (this.chimpanzee.func_184218_aH()) {
            return false;
        }
        return super.func_75253_b();
    }

    public void func_75249_e() {
        super.func_75249_e();
        this.shakingTime = 0;
        this.nextBananaTime = 30 + this.getNextBananaTime();
        this.chimpanzee.setLookingForBundle(true);
    }

    public void func_75251_c() {
        super.func_75251_c();
        this.chimpanzee.setDefaultAction();
        this.chimpanzee.setLookingForBundle(false);
    }

    public void func_75246_d() {
        super.func_75246_d();
        this.chimpanzee.func_70671_ap().func_75650_a((double)this.bundlePos.func_177958_n() + 0.5, (double)this.bundlePos.func_177956_o() + 0.5, (double)this.bundlePos.func_177952_p() + 0.5, (float)(this.chimpanzee.func_184649_cE() + 20), (float)this.chimpanzee.func_70646_bf());
        if (this.chimpanzee.func_226283_e_(1.0) <= (double)this.bundlePos.func_177956_o() && this.bundlePos.func_218137_a((IPosition)this.chimpanzee.func_213303_ch().func_178787_e(new Vector3d(0.0, (double)this.chimpanzee.func_213302_cg(), 0.0)), 1.0)) {
            this.chimpanzee.func_213317_d(this.chimpanzee.func_213322_ci().func_216372_d(0.4, 0.0, 0.4).func_72441_c(0.0, 0.1, 0.0));
            if (this.shakingTime > 30) {
                this.chimpanzee.setAction(ChimpanzeeAction.SHAKING);
                if (this.shakingTime >= this.nextBananaTime) {
                    double d0 = (double)this.bundlePos.func_177958_n() + this.chimpanzee.func_70681_au().nextDouble() * 0.5 + 0.25;
                    double d1 = (double)this.bundlePos.func_177952_p() + this.chimpanzee.func_70681_au().nextDouble() * 0.5 + 0.25;
                    if (this.chimpanzee.func_70681_au().nextInt(4) == 0) {
                        BananaPeelEntity bananapeel = (BananaPeelEntity)((EntityType)NeapolitanEntities.BANANA_PEEL.get()).func_200721_a(this.chimpanzee.field_70170_p);
                        bananapeel.func_70012_b(d0, (double)this.bundlePos.func_177956_o() - 0.5, d1, this.chimpanzee.field_70177_z, 0.0f);
                        bananapeel.func_213293_j(this.chimpanzee.func_70681_au().nextDouble() * 0.4 - 0.2, -0.1, this.chimpanzee.func_70681_au().nextDouble() * 0.4 - 0.2);
                        this.chimpanzee.field_70170_p.func_217376_c((Entity)bananapeel);
                    } else {
                        ItemEntity itementity = new ItemEntity(this.chimpanzee.field_70170_p, d0, (double)this.bundlePos.func_177956_o() - 0.25, d1, new ItemStack((IItemProvider)NeapolitanItems.BANANA_BUNCH.get()));
                        itementity.func_213293_j(this.chimpanzee.func_70681_au().nextDouble() * 0.4 - 0.2, -0.1, this.chimpanzee.func_70681_au().nextDouble() * 0.4 - 0.2);
                        itementity.func_174869_p();
                        this.chimpanzee.field_70170_p.func_217376_c((Entity)itementity);
                    }
                    this.nextBananaTime = this.shakingTime + this.getNextBananaTime();
                }
            } else {
                this.chimpanzee.setAction(ChimpanzeeAction.HANGING);
            }
            ++this.shakingTime;
        } else {
            if (this.func_179487_f() && this.chimpanzee.getAction().canBeInterrupted() && this.chimpanzee.func_233570_aj_()) {
                this.chimpanzee.func_70637_d(true);
                double d0 = (double)this.field_179494_b.func_177958_n() + 0.5 - this.chimpanzee.func_226277_ct_();
                double d1 = (double)this.field_179494_b.func_177952_p() + 0.5 - this.chimpanzee.func_226281_cx_();
                double d2 = (double)this.bundlePos.func_177956_o() - this.chimpanzee.func_226278_cu_() + 1.0;
                double d3 = 0.8 - d2 * 0.1;
                this.chimpanzee.func_213317_d(this.chimpanzee.func_213322_ci().func_216372_d(0.9, 1.0, 0.9).func_72441_c(d0 * d3, 0.3 + d2 * 0.1, d1 * d3));
            }
            this.chimpanzee.setDefaultAction();
            this.shakingTime = 0;
            this.nextBananaTime = 30 + this.getNextBananaTime();
        }
    }

    protected boolean func_179488_a(IWorldReader worldIn, BlockPos pos) {
        if (worldIn.func_180495_p(pos).func_235785_r_((IBlockReader)worldIn, pos)) {
            for (int i = 1; i < 7; ++i) {
                BlockPos blockpos = pos.func_177981_b(i);
                if (i > 2 && worldIn.func_180495_p(blockpos).func_177230_c() == NeapolitanBlocks.BANANA_BUNDLE.get()) {
                    if (this.getBlockBeingShaken((World)worldIn, blockpos)) {
                        return false;
                    }
                    this.bundlePos = blockpos;
                    return true;
                }
                if (!worldIn.func_180495_p(blockpos).func_235785_r_((IBlockReader)worldIn, pos.func_177981_b(i))) continue;
                return false;
            }
        }
        return false;
    }

    private int getNextBananaTime() {
        return 5 + this.chimpanzee.func_70681_au().nextInt(30);
    }

    private boolean getBlockBeingShaken(World worldIn, BlockPos pos) {
        return !worldIn.func_175647_a(ChimpanzeeEntity.class, new AxisAlignedBB(pos.func_177977_b()), chimpanzee -> chimpanzee != this.chimpanzee && chimpanzee.isDoingAction(ChimpanzeeAction.HANGING, ChimpanzeeAction.SHAKING)).isEmpty();
    }
}

