/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.personality.common;

import com.minecraftabnormals.abnormals_core.common.world.storage.tracking.IDataManager;
import com.minecraftabnormals.personality.client.ClimbAnimation;
import com.minecraftabnormals.personality.common.network.MessageS2CSyncCrawl;
import com.minecraftabnormals.personality.core.Personality;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="personality")
public class CommonEvents {
    @SubscribeEvent
    public static void onEvent(TickEvent.PlayerTickEvent event) {
        if (event.side == LogicalSide.CLIENT && event.phase != TickEvent.Phase.END) {
            return;
        }
        PlayerEntity player = event.player;
        if (!(player instanceof ServerPlayerEntity)) {
            return;
        }
        UUID uuid = player.func_110124_au();
        CommonEvents.setBesideClimbableBlock(player, player.func_70617_f_() && (player.field_70137_T != player.func_226278_cu_() || player.func_225608_bj_()));
        if ((Personality.SITTING_PLAYERS.contains(player.func_110124_au()) || Personality.SYNCED_SITTING_PLAYERS.contains(player.func_110124_au())) && !CommonEvents.testCrawl(player)) {
            Personality.SITTING_PLAYERS.remove(uuid);
            Personality.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new MessageS2CSyncCrawl(player.func_110124_au(), false));
        }
    }

    @SubscribeEvent
    public static void onEvent(PlayerEvent.StartTracking event) {
        Entity entity = event.getTarget();
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            Personality.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new MessageS2CSyncCrawl(player.func_110124_au(), player.getForcedPose() == Pose.SWIMMING));
        }
    }

    @SubscribeEvent
    public static void onEvent(PlayerEvent.StopTracking event) {
        Entity entity = event.getTarget();
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            Personality.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new MessageS2CSyncCrawl(player.func_110124_au(), false));
        }
    }

    @SubscribeEvent
    public static void onEvent(EntityEvent.Size event) {
        Entity entity = event.getEntity();
        if (!(event.getEntity() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entity;
        if ((Personality.SITTING_PLAYERS.contains(player.func_110124_au()) || Personality.SYNCED_SITTING_PLAYERS.contains(player.func_110124_au())) && CommonEvents.testSit(player)) {
            EntitySize size = PlayerEntity.field_213835_bs;
            event.setNewSize(new EntitySize(size.field_220315_a, size.field_220316_b - 0.5f, size.field_220317_c));
            event.setNewEyeHeight(player.func_213348_b(Pose.STANDING, size) - 0.5f);
        }
    }

    public static boolean testSit(PlayerEntity player) {
        return (player.func_213283_Z() == Pose.STANDING || player.func_213283_Z() == Pose.CROUCHING) && !player.func_184218_aH() && player.func_233570_aj_();
    }

    public static boolean testCrawl(PlayerEntity player) {
        return !Personality.SITTING_PLAYERS.contains(player.func_110124_au()) && !Personality.SYNCED_SITTING_PLAYERS.contains(player.func_110124_au()) && !player.func_184218_aH();
    }

    public static boolean isClimbing(PlayerEntity player) {
        return !player.func_233570_aj_() && CommonEvents.isBesideClimbableBlock(player);
    }

    public static boolean isBesideClimbableBlock(PlayerEntity player) {
        IDataManager data = (IDataManager)player;
        return ((Byte)data.getValue(Personality.CLIMBING) & 1) != 0;
    }

    public static void setBesideClimbableBlock(PlayerEntity player, boolean climbing) {
        IDataManager data = (IDataManager)player;
        byte b0 = (Byte)data.getValue(Personality.CLIMBING);
        b0 = climbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        data.setValue(Personality.CLIMBING, (Object)b0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static float getClimbingAnimationScale(PlayerEntity player, float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)((ClimbAnimation)player).getPrevClimbAnim(), (float)((ClimbAnimation)player).getClimbAnim()) / 4.0f;
    }
}

