/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.personality.core.mixin;

import com.minecraftabnormals.personality.client.ClimbAnimation;
import com.minecraftabnormals.personality.common.CommonEvents;
import com.minecraftabnormals.personality.core.Personality;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerEntity.class})
public abstract class PlayerEntityMixin
extends LivingEntity
implements ClimbAnimation {
    private float climbAnim;
    private float prevClimbAnim;

    public PlayerEntityMixin(EntityType<? extends LivingEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Inject(method={"aiStep()V"}, at={@At(value="TAIL")})
    public void tickClimbAnim(CallbackInfo ci) {
        this.prevClimbAnim = this.climbAnim;
        this.climbAnim = CommonEvents.isClimbing((PlayerEntity)this) ? Math.min(this.climbAnim + 1.0f, 4.0f) : Math.max(this.climbAnim - 1.0f, 0.0f);
    }

    public void func_213315_a(MoverType typeIn, Vector3d pos) {
        double x = pos.func_82615_a();
        double y = pos.func_82617_b();
        double z = pos.func_82616_c();
        if (Personality.SITTING_PLAYERS.contains(this.func_110124_au()) && Math.cbrt(x * x + y * y + z * z) >= 0.185) {
            Personality.SITTING_PLAYERS.remove(this.func_110124_au());
        }
        super.func_213315_a(typeIn, pos);
    }

    @Override
    public float getClimbAnim() {
        return this.climbAnim;
    }

    @Override
    public float getPrevClimbAnim() {
        return this.prevClimbAnim;
    }
}

