/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.blocks;

import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.tiles.BloodyLecternTile;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import it.hurts.sskirillss.relics.utils.RelicUtils;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.LecternBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ToolType;
import org.jetbrains.annotations.Nullable;

public class BloodyLecternBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;

    public BloodyLecternBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(4.0f).harvestTool(ToolType.PICKAXE).func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (handIn != Hand.MAIN_HAND) {
            return ActionResultType.FAIL;
        }
        BloodyLecternTile lectern = (BloodyLecternTile)world.func_175625_s(pos);
        ItemStack heldStack = player.func_184586_b(handIn);
        Random random = world.func_201674_k();
        if (lectern.getStack().func_190926_b()) {
            if (heldStack.func_77973_b() == ItemRegistry.COAL_PARCHMENT.get() || heldStack.func_77973_b() == ItemRegistry.RELIC_CONTRACT.get()) {
                lectern.setStack(heldStack.func_77979_a(1));
            }
        } else {
            ItemStack contract = lectern.getStack();
            if ((contract.func_77973_b() == ItemRegistry.COAL_PARCHMENT.get() || contract.func_77973_b() == ItemRegistry.RELIC_CONTRACT.get()) && heldStack.func_77973_b() == ItemRegistry.BLOODY_FEATHER.get()) {
                if (world.func_201670_d()) {
                    return ActionResultType.FAIL;
                }
                int blood = NBTUtils.getInt(contract, "blood", -1);
                String owner = RelicUtils.Owner.getOwnerUUID(contract);
                if (player.func_184811_cZ().func_185141_a(heldStack.func_77973_b()) || blood >= 4) {
                    return ActionResultType.FAIL;
                }
                if (contract.func_77973_b() == ItemRegistry.COAL_PARCHMENT.get()) {
                    ItemStack parchment = new ItemStack((IItemProvider)ItemRegistry.RELIC_CONTRACT.get());
                    RelicUtils.Owner.setOwnerUUID(parchment, player.func_189512_bd());
                    lectern.setStack(parchment);
                } else if (owner.equals("") || player.func_189512_bd().equals(owner)) {
                    NBTUtils.setInt(contract, "blood", ++blood);
                    RelicUtils.Owner.setOwnerUUID(contract, player.func_189512_bd());
                    if (blood == 4) {
                        ((ServerWorld)world).func_195598_a((IParticleData)ParticleTypes.field_197627_t, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.75f), (double)((float)pos.func_177952_p() + 0.5f), 1, 0.0, 0.0, 0.0, 0.0);
                    }
                } else {
                    return ActionResultType.FAIL;
                }
                player.func_70097_a(DamageSource.field_76377_j, player.func_110138_aP() * 0.1f);
                player.func_184811_cZ().func_185145_a(heldStack.func_77973_b(), 10);
                world.func_184133_a(null, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 1.0f - random.nextFloat() * 0.5f);
                world.func_184138_a(pos, state, state, 2);
            } else {
                if (heldStack.func_190926_b()) {
                    player.func_184611_a(Hand.MAIN_HAND, contract);
                } else {
                    ItemEntity drop = new ItemEntity(world, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), lectern.getStack());
                    drop.func_174867_a(0);
                    world.func_217376_c((Entity)drop);
                }
                lectern.setStack(ItemStack.field_190927_a);
            }
        }
        return ActionResultType.SUCCESS;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        ItemStack stack;
        TileEntity tile;
        if (!state.func_203425_a(newState.func_177230_c()) && (tile = worldIn.func_175625_s(pos)) instanceof BloodyLecternTile && (stack = ((BloodyLecternTile)tile).getStack()) != null && !stack.func_190926_b()) {
            worldIn.func_217376_c((Entity)new ItemEntity(worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack));
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        Direction direction = (Direction)state.func_177229_b((Property)FACING);
        if (direction == Direction.NORTH) {
            return LecternBlock.field_220166_j;
        }
        if (direction == Direction.SOUTH) {
            return LecternBlock.field_220163_w;
        }
        if (direction == Direction.EAST) {
            return LecternBlock.field_220167_k;
        }
        if (direction == Direction.WEST) {
            return LecternBlock.field_220165_i;
        }
        return LecternBlock.field_220161_f;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new BloodyLecternTile();
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }
}

