/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.blocks;

import it.hurts.sskirillss.relics.blocks.IVoidBlock;
import it.hurts.sskirillss.relics.init.BlockRegistry;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ToolType;

public class MagmaStoneBlock
extends Block
implements IVoidBlock {
    public static final BooleanProperty FALLING = BlockStateProperties.field_208183_j;
    public static final IntegerProperty LEVEL = IntegerProperty.func_177719_a((String)"level", (int)0, (int)8);
    public static final IntegerProperty AGE = BlockStateProperties.field_208168_U;

    public MagmaStoneBlock() {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151655_K).func_200944_c().func_200943_b(1.0f).harvestTool(ToolType.PICKAXE).func_235861_h_().func_235838_a_(state -> 3));
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)AGE, (Comparable)Integer.valueOf(0))).func_206870_a((Property)FALLING, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)LEVEL, (Comparable)Integer.valueOf(0)));
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        MagmaStoneBlock.updateState(world, pos, true);
        return true;
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        MagmaStoneBlock.updateState((World)worldIn, pos, true);
    }

    private static void updateState(World worldIn, BlockPos pos, boolean isCascade) {
        if (worldIn.func_201670_d()) {
            return;
        }
        BlockState state = worldIn.func_180495_p(pos);
        int level = (Integer)state.func_177229_b((Property)LEVEL);
        int age = (Integer)state.func_177229_b((Property)AGE);
        if (age < 3) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf((Integer)state.func_177229_b((Property)AGE) + 1)), 2);
        } else {
            worldIn.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 1.0f);
            FluidState fluid = level > 0 ? Fluids.field_207213_d.func_207207_a(level, ((Boolean)state.func_177229_b((Property)FALLING)).booleanValue()) : Fluids.field_204547_b.func_207188_f();
            worldIn.func_175656_a(pos, fluid.func_206883_i());
        }
        if (!isCascade) {
            return;
        }
        for (Direction direction : Direction.values()) {
            BlockPos offset = pos.func_177982_a(direction.func_82601_c(), direction.func_96559_d(), direction.func_82599_e());
            if (!worldIn.func_180495_p(offset).func_203425_a((Block)BlockRegistry.MAGMA_STONE_BLOCK.get())) continue;
            MagmaStoneBlock.updateState(worldIn, offset, worldIn.field_73012_v.nextInt(10) == 0);
        }
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        int age = (Integer)worldIn.func_180495_p(pos).func_177229_b((Property)AGE);
        if (!entityIn.func_230279_az_() && entityIn instanceof LivingEntity && age > 0 && !EnchantmentHelper.func_189869_j((LivingEntity)((LivingEntity)entityIn))) {
            entityIn.func_70097_a(DamageSource.field_190095_e, (float)age);
        }
        super.func_176199_a(worldIn, pos, entityIn);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{AGE}).func_206894_a(new Property[]{FALLING}).func_206894_a(new Property[]{LEVEL});
    }
}

