/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.blocks;

import com.google.common.collect.ImmutableList;
import it.hurts.sskirillss.relics.tiles.PedestalTile;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class PedestalBlock
extends Block {
    public static final DirectionProperty DIRECTION = DirectionProperty.func_196962_a((String)"direction", (Direction[])new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.UP, Direction.DOWN});

    public PedestalBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(1.5f).harvestTool(ToolType.PICKAXE));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)DIRECTION, (Comparable)Direction.UP));
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        return ImmutableList.of((Object)new ItemStack((IItemProvider)state.func_177230_c()));
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (handIn != Hand.MAIN_HAND) {
            return ActionResultType.FAIL;
        }
        PedestalTile pedestal = (PedestalTile)world.func_175625_s(pos);
        if (pedestal.getStack().func_190926_b()) {
            ItemStack stack = player.func_184614_ca();
            if (stack.func_190926_b()) {
                return ActionResultType.FAIL;
            }
            pedestal.setStack(player.func_184614_ca().func_77979_a(1));
        } else {
            ItemStack stack = pedestal.getStack();
            if (player.func_184614_ca().func_190926_b()) {
                player.func_184611_a(Hand.MAIN_HAND, stack);
            } else {
                ItemEntity drop = new ItemEntity(world, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), pedestal.getStack());
                drop.func_174867_a(0);
                world.func_217376_c((Entity)drop);
            }
            pedestal.setStack(ItemStack.field_190927_a);
        }
        return ActionResultType.SUCCESS;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        ItemStack stack;
        TileEntity tile;
        if (!state.func_203425_a(newState.func_177230_c()) && (tile = worldIn.func_175625_s(pos)) instanceof PedestalTile && (stack = ((PedestalTile)tile).getStack()) != null && !stack.func_190926_b()) {
            worldIn.func_217376_c((Entity)new ItemEntity(worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack));
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Direction direction = (Direction)state.func_177229_b((Property)DIRECTION);
        if (direction == Direction.UP) {
            return Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)4.0, (double)12.0);
        }
        if (direction == Direction.DOWN) {
            return Block.func_208617_a((double)4.0, (double)16.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
        }
        if (direction == Direction.NORTH) {
            return Block.func_208617_a((double)12.0, (double)4.0, (double)16.0, (double)4.0, (double)12.0, (double)12.0);
        }
        if (direction == Direction.SOUTH) {
            return Block.func_208617_a((double)12.0, (double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)0.0);
        }
        if (direction == Direction.EAST) {
            return Block.func_208617_a((double)0.0, (double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0);
        }
        if (direction == Direction.WEST) {
            return Block.func_208617_a((double)12.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0);
        }
        return Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new PedestalTile();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = context.func_195999_j() == null ? (BlockState)this.func_176223_P().func_206870_a((Property)DIRECTION, (Comparable)Direction.UP) : (BlockState)this.func_176223_P().func_206870_a((Property)DIRECTION, (Comparable)(context.func_195999_j().func_225608_bj_() ? context.func_196000_l().func_176734_d() : context.func_196000_l()));
        return state;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{DIRECTION});
    }
}

