/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.particles.spark;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.hurts.sskirillss.relics.init.ParticleRegistry;
import java.awt.Color;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.math.MathHelper;

public class SparkTintData
implements IParticleData {
    private final Color tint;
    private final float diameter;
    private final int lifeTime;
    public static final Codec<SparkTintData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("tint").forGetter(d -> d.tint.getRGB()), (App)Codec.FLOAT.fieldOf("diameter").forGetter(d -> Float.valueOf(d.diameter)), (App)Codec.INT.fieldOf("life_time").forGetter(d -> d.lifeTime)).apply((Applicative)instance, SparkTintData::new));
    public static final IParticleData.IDeserializer<SparkTintData> DESERIALIZER = new IParticleData.IDeserializer<SparkTintData>(){

        @Nonnull
        public SparkTintData fromCommand(@Nonnull ParticleType<SparkTintData> type, @Nonnull StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            int red = MathHelper.func_76125_a((int)reader.readInt(), (int)0, (int)255);
            reader.expect(' ');
            int green = MathHelper.func_76125_a((int)reader.readInt(), (int)0, (int)255);
            reader.expect(' ');
            int blue = MathHelper.func_76125_a((int)reader.readInt(), (int)0, (int)255);
            reader.expect(' ');
            float diameter = SparkTintData.validateDiameter(reader.readFloat());
            reader.expect(' ');
            int lifeTime = reader.readInt();
            return new SparkTintData(new Color(red, green, blue), diameter, lifeTime);
        }

        public SparkTintData fromNetwork(@Nonnull ParticleType<SparkTintData> type, PacketBuffer buf) {
            int red = MathHelper.func_76125_a((int)buf.readInt(), (int)0, (int)255);
            int green = MathHelper.func_76125_a((int)buf.readInt(), (int)0, (int)255);
            int blue = MathHelper.func_76125_a((int)buf.readInt(), (int)0, (int)255);
            Color color = new Color(red, green, blue);
            float diameter = SparkTintData.validateDiameter(buf.readFloat());
            int lifeTime = buf.readInt();
            return new SparkTintData(color, diameter, lifeTime);
        }
    };

    public SparkTintData(Color tint, float diameter, int lifeTime) {
        this.tint = tint;
        this.lifeTime = lifeTime;
        this.diameter = SparkTintData.validateDiameter(diameter);
    }

    public Color getTint() {
        return this.tint;
    }

    public int getLifeTime() {
        return this.lifeTime;
    }

    public float getDiameter() {
        return this.diameter;
    }

    @Nonnull
    public ParticleType<SparkTintData> func_197554_b() {
        return ParticleRegistry.SPARK_TINT;
    }

    public void func_197553_a(PacketBuffer buf) {
        buf.writeInt(this.tint.getRed());
        buf.writeInt(this.tint.getGreen());
        buf.writeInt(this.tint.getBlue());
        buf.writeFloat(this.diameter);
        buf.writeInt(this.lifeTime);
    }

    @Nonnull
    public String func_197555_a() {
        return String.format(Locale.ROOT, "%s %i %i %i %.2f %i", this.func_197554_b().getRegistryName(), this.tint.getRed(), this.tint.getGreen(), this.tint.getBlue(), Float.valueOf(this.diameter), this.lifeTime);
    }

    private static float validateDiameter(float diameter) {
        return (float)MathHelper.func_151237_a((double)diameter, (double)0.05, (double)5.0);
    }

    private SparkTintData(int tintRGB, float diameter, int lifeTime) {
        this.tint = new Color(tintRGB);
        this.lifeTime = lifeTime;
        this.diameter = SparkTintData.validateDiameter(diameter);
    }
}

