/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.entities;

import it.hurts.sskirillss.relics.client.particles.spark.SparkTintData;
import it.hurts.sskirillss.relics.init.EntityRegistry;
import it.hurts.sskirillss.relics.items.relics.ShadowGlaiveItem;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import java.awt.Color;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class ShadowGlaiveEntity
extends ThrowableEntity {
    private static final DataParameter<Integer> BOUNCES = EntityDataManager.func_187226_a(ShadowGlaiveEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<String> OWNER = EntityDataManager.func_187226_a(ShadowGlaiveEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> TARGET = EntityDataManager.func_187226_a(ShadowGlaiveEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> BOUNCED_ENTITIES = EntityDataManager.func_187226_a(ShadowGlaiveEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final String TAG_BOUNCES_AMOUNT = "bounces";
    private static final String TAG_OWNER_UUID = "owner";
    private static final String TAG_TARGET_UUID = "target";
    private static final String TAG_BOUNCED_ENTITIES = "entities";
    private boolean isBounced = false;
    private PlayerEntity owner;
    private LivingEntity target;

    public ShadowGlaiveEntity(EntityType<? extends ShadowGlaiveEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public ShadowGlaiveEntity(World world, LivingEntity throwerIn) {
        super((EntityType)EntityRegistry.SHADOW_GLAIVE.get(), throwerIn, world);
    }

    public void setOwner(PlayerEntity playerIn) {
        this.owner = playerIn;
        if (playerIn != null) {
            this.field_70180_af.func_187227_b(OWNER, (Object)playerIn.func_110124_au().toString());
        }
    }

    public void setTarget(LivingEntity target) {
        this.target = target;
        if (target != null) {
            this.field_70180_af.func_187227_b(TARGET, (Object)target.func_110124_au().toString());
        }
    }

    private void locateNearestTarget() {
        ShadowGlaiveItem.Stats config = (ShadowGlaiveItem.Stats)ShadowGlaiveItem.INSTANCE.getStats();
        int bounces = (Integer)this.field_70180_af.func_187225_a(BOUNCES);
        if (this.field_70170_p.func_201674_k().nextFloat() > 1.0f - (float)bounces * config.bounceChanceMultiplier) {
            this.func_70106_y();
            return;
        }
        List<String> bouncedEntities = Arrays.asList(((String)this.field_70180_af.func_187225_a(BOUNCED_ENTITIES)).split(","));
        List entitiesAround = this.field_70170_p.func_217357_a(LivingEntity.class, this.func_174813_aQ().func_186662_g((double)config.bounceRadius));
        if ((entitiesAround = entitiesAround.stream().filter(entity -> !bouncedEntities.contains(entity.func_110124_au().toString())).filter(EntityPredicates.field_188444_d).filter(entity -> entity != this.owner).sorted(Comparator.comparing(entity -> entity.func_213303_ch().func_72438_d(this.func_213303_ch()))).collect(Collectors.toList())).isEmpty()) {
            if (this.isBounced) {
                this.func_70106_y();
            }
            return;
        }
        LivingEntity target = null;
        for (LivingEntity entity2 : entitiesAround) {
            if (entity2 == null || !entity2.func_70089_S()) continue;
            target = entity2;
            break;
        }
        if (target == null || !target.func_70089_S()) {
            this.func_70106_y();
            return;
        }
        this.setTarget(target);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        ShadowGlaiveItem.Stats config = (ShadowGlaiveItem.Stats)ShadowGlaiveItem.INSTANCE.getStats();
        for (int i = 0; i < 3; ++i) {
            this.field_70170_p.func_195594_a((IParticleData)new SparkTintData(new Color(255, this.field_70146_Z.nextInt(100), 255), 0.2f, 30), this.field_70169_q, this.field_70167_r, this.field_70166_s, (double)(MathUtils.randomFloat(this.field_70146_Z) * 0.01f), 0.0, (double)(MathUtils.randomFloat(this.field_70146_Z) * 0.01f));
        }
        if (this.field_70170_p.func_201670_d()) {
            return;
        }
        if (!this.isBounced && this.target == null && this.field_70173_aa > 30) {
            this.func_70106_y();
        }
        if (this.field_70173_aa > 300) {
            this.func_70106_y();
        }
        if (this.target == null && this.field_70173_aa > 10 && this.field_70173_aa % 2 == 0) {
            this.locateNearestTarget();
            return;
        }
        if (this.target != null && this.target.func_70089_S()) {
            EntityUtils.moveTowardsPosition((Entity)this, this.target.func_213303_ch().func_72441_c(0.0, (double)this.target.func_213302_cg() * 0.5, 0.0), config.projectileSpeed);
            Iterator iterator = this.field_70170_p.func_217357_a(LivingEntity.class, this.func_174813_aQ().func_72314_b(0.3, 3.0, 0.3)).iterator();
            if (iterator.hasNext()) {
                LivingEntity entity = (LivingEntity)iterator.next();
                if (entity == this.owner) {
                    return;
                }
                int bounces = (Integer)this.field_70180_af.func_187225_a(BOUNCES);
                if (bounces > config.maxBounces) {
                    this.func_70106_y();
                }
                String bouncedEntitiesString = (String)this.field_70180_af.func_187225_a(BOUNCED_ENTITIES);
                List<String> bouncedEntities = Arrays.asList(bouncedEntitiesString.split(","));
                entity.func_70097_a(this.owner != null ? DamageSource.func_76365_a((PlayerEntity)this.owner) : DamageSource.field_76377_j, (float)config.damage);
                if (!bouncedEntities.contains(entity.func_110124_au().toString())) {
                    this.field_70180_af.func_187227_b(BOUNCED_ENTITIES, (Object)(bouncedEntitiesString + "," + entity.func_110124_au()));
                    this.field_70180_af.func_187227_b(BOUNCES, (Object)(bounces + 1));
                    this.isBounced = true;
                }
                this.locateNearestTarget();
            }
        } else {
            this.locateNearestTarget();
        }
    }

    protected void func_70227_a(@Nonnull RayTraceResult rayTraceResult) {
        if (this.field_70170_p.func_201670_d()) {
            return;
        }
        if (rayTraceResult.func_216346_c() == RayTraceResult.Type.BLOCK && this.field_70170_p.func_180495_p(((BlockRayTraceResult)rayTraceResult).func_216350_a()).func_185904_a().func_76230_c()) {
            this.func_70106_y();
        }
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(BOUNCES, (Object)0);
        this.field_70180_af.func_187214_a(OWNER, (Object)"");
        this.field_70180_af.func_187214_a(TARGET, (Object)"");
        this.field_70180_af.func_187214_a(BOUNCED_ENTITIES, (Object)"");
    }

    public void func_213281_b(CompoundNBT tag) {
        tag.func_74768_a(TAG_BOUNCES_AMOUNT, ((Integer)this.field_70180_af.func_187225_a(BOUNCES)).intValue());
        tag.func_74778_a(TAG_OWNER_UUID, (String)this.field_70180_af.func_187225_a(OWNER));
        tag.func_74778_a(TAG_TARGET_UUID, (String)this.field_70180_af.func_187225_a(TARGET));
        tag.func_74778_a(TAG_BOUNCED_ENTITIES, (String)this.field_70180_af.func_187225_a(BOUNCED_ENTITIES));
        super.func_213281_b(tag);
    }

    public void func_70037_a(CompoundNBT tag) {
        this.field_70180_af.func_187227_b(BOUNCES, (Object)tag.func_74762_e(TAG_BOUNCES_AMOUNT));
        this.field_70180_af.func_187227_b(OWNER, (Object)tag.func_74779_i(TAG_OWNER_UUID));
        this.field_70180_af.func_187227_b(TARGET, (Object)tag.func_74779_i(TAG_TARGET_UUID));
        this.field_70180_af.func_187227_b(BOUNCED_ENTITIES, (Object)tag.func_74779_i(TAG_BOUNCED_ENTITIES));
        super.func_70037_a(tag);
    }

    public boolean func_96092_aw() {
        return false;
    }

    protected float func_70185_h() {
        return 0.0f;
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

