/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics;

import it.hurts.sskirillss.relics.client.tooltip.base.AbilityTooltip;
import it.hurts.sskirillss.relics.client.tooltip.base.RelicTooltip;
import it.hurts.sskirillss.relics.configs.data.relics.RelicConfigData;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicStats;
import it.hurts.sskirillss.relics.utils.DurabilityUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import it.hurts.sskirillss.relics.utils.RelicsTab;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class InfinityHamItem
extends RelicItem<Stats>
implements ICurioItem {
    public static final String TAG_PIECES = "pieces";
    private static final String TAG_CHARGE = "charge";

    public InfinityHamItem() {
        super(RelicData.builder().properties(new Item.Properties().func_200916_a(RelicsTab.RELICS_TAB).func_200917_a(1).func_208103_a(Rarity.RARE).func_221540_a(new Food.Builder().func_221453_d())).build());
    }

    @Override
    public RelicTooltip getTooltip(ItemStack stack) {
        return RelicTooltip.builder().borders("#ffe0d2", "#9c756b").ability(AbilityTooltip.builder().arg(((Stats)this.stats).feedAmount).arg(((Stats)this.stats).maxPieces).arg(((Stats)this.stats).rechargeTime).build()).build();
    }

    @Override
    public RelicConfigData<Stats> getConfigData() {
        return RelicConfigData.builder().stats(new Stats()).build();
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (group != RelicsTab.RELICS_TAB) {
            return;
        }
        ItemStack stack = new ItemStack((IItemProvider)ItemRegistry.INFINITY_HAM.get());
        NBTUtils.setInt(stack, TAG_PIECES, ((Stats)this.stats).maxPieces);
        items.add((Object)stack);
        super.func_150895_a(group, items);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (DurabilityUtils.isBroken(stack) || entityIn.field_70173_aa % 20 != 0) {
            return;
        }
        int pieces = NBTUtils.getInt(stack, TAG_PIECES, 0);
        if (pieces >= ((Stats)this.stats).maxPieces) {
            return;
        }
        int charge = NBTUtils.getInt(stack, TAG_CHARGE, 0);
        if (charge >= ((Stats)this.stats).rechargeTime) {
            NBTUtils.setInt(stack, TAG_PIECES, pieces + 1);
            NBTUtils.setInt(stack, TAG_CHARGE, 0);
        } else {
            NBTUtils.setInt(stack, TAG_CHARGE, charge + 1);
        }
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!DurabilityUtils.isBroken(stack) && NBTUtils.getInt(stack, TAG_PIECES, 0) > 0 && player.func_71024_bL().func_75121_c()) {
            return super.func_77659_a(world, player, hand);
        }
        return ActionResult.func_226250_c_((Object)stack);
    }

    public ItemStack func_77654_b(ItemStack stack, World world, LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return stack;
        }
        PlayerEntity player = (PlayerEntity)entity;
        int pieces = NBTUtils.getInt(stack, TAG_PIECES, 0);
        if (pieces > 0) {
            NBTUtils.setInt(stack, TAG_PIECES, pieces - 1);
            player.func_71024_bL().func_75122_a(((Stats)this.stats).feedAmount, (float)((Stats)this.stats).saturationAmount / (float)((Stats)this.stats).feedAmount / 2.0f);
        }
        return stack;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public int func_77626_a(ItemStack stack) {
        return ((Stats)this.stats).useDuration;
    }

    public static class Stats
    extends RelicStats {
        public int rechargeTime = 60;
        public int useDuration = 32;
        public int maxPieces = 3;
        public int feedAmount = 10;
        public int saturationAmount = 5;
    }
}

