/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics;

import it.hurts.sskirillss.relics.client.tooltip.base.AbilityTooltip;
import it.hurts.sskirillss.relics.client.tooltip.base.RelicTooltip;
import it.hurts.sskirillss.relics.configs.data.relics.RelicConfigData;
import it.hurts.sskirillss.relics.configs.data.relics.RelicDurabilityData;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicStats;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.network.PacketItemActivation;
import it.hurts.sskirillss.relics.utils.DurabilityUtils;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.SlotContext;

public class SpatialSignItem
extends RelicItem<Stats> {
    public static final String TAG_POSITION = "pos";
    public static final String TAG_TIME = "time";
    public static final String TAG_WORLD = "world";
    public static SpatialSignItem INSTANCE;

    public SpatialSignItem() {
        super(RelicData.builder().rarity(Rarity.RARE).build());
        INSTANCE = this;
    }

    @Override
    public RelicTooltip getTooltip(ItemStack stack) {
        return RelicTooltip.builder().borders("#dc41ff", "#832698").ability(AbilityTooltip.builder().arg(((Stats)this.stats).timeBeforeActivation).arg(((Stats)this.stats).experiencePerSecond).arg(Minecraft.func_71410_x().field_71474_y.field_228046_af_.getKey().func_237520_d_().getString()).active(Minecraft.func_71410_x().field_71474_y.field_74313_G).build()).ability(AbilityTooltip.builder().build()).build();
    }

    @Override
    public RelicConfigData<Stats> getConfigData() {
        return RelicConfigData.builder().stats(new Stats()).durability(new RelicDurabilityData(1)).build();
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (!NBTUtils.getString(stack, TAG_POSITION, "").equals("")) {
            Vector3d pos = NBTUtils.parsePosition(NBTUtils.getString(stack, TAG_POSITION, ""));
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.relics.spatial_sign.tooltip_1", new Object[]{pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c()}));
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.relics.spatial_sign.tooltip_2", new Object[]{NBTUtils.getInt(stack, TAG_TIME, 0)}));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (DurabilityUtils.isBroken(stack)) {
            return ActionResult.func_226251_d_((Object)stack);
        }
        if (NBTUtils.getString(stack, TAG_POSITION, "").equals("")) {
            if (playerIn.field_71067_cb > 0) {
                NBTUtils.setString(stack, TAG_POSITION, NBTUtils.writePosition(playerIn.func_213303_ch()));
                NBTUtils.setString(stack, TAG_WORLD, playerIn.func_130014_f_().func_234923_W_().func_240901_a_().toString());
                NBTUtils.setInt(stack, TAG_TIME, ((Stats)this.stats).timeBeforeActivation);
                worldIn.func_184133_a(playerIn, playerIn.func_233580_cy_(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
        } else if (playerIn.func_225608_bj_()) {
            SpatialSignItem.teleportPlayer(playerIn, stack);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (worldIn.func_201670_d() || DurabilityUtils.isBroken(stack) || !(entityIn instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entityIn;
        int time = NBTUtils.getInt(stack, TAG_TIME, -1);
        if (player.field_70173_aa % 20 == 0 && time >= 0) {
            if (time > 0) {
                NBTUtils.setInt(stack, TAG_TIME, time - 1);
                if (player.field_71067_cb > 0) {
                    player.func_195068_e(-((Stats)this.stats).experiencePerSecond);
                } else {
                    SpatialSignItem.teleportPlayer(player, stack);
                }
            } else {
                SpatialSignItem.teleportPlayer(player, stack);
            }
        }
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    @Override
    public int getMaxDamage(ItemStack stack) {
        return 1;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public boolean func_77636_d(ItemStack stack) {
        return NBTUtils.getInt(stack, TAG_TIME, 0) > 0;
    }

    public static void teleportPlayer(PlayerEntity player, ItemStack stack) {
        Stats stats = (Stats)SpatialSignItem.INSTANCE.stats;
        if (player.func_130014_f_().func_201670_d()) {
            return;
        }
        Vector3d pos = NBTUtils.parsePosition(NBTUtils.getString(stack, TAG_POSITION, ""));
        ServerWorld world = NBTUtils.parseWorld(player.func_130014_f_(), NBTUtils.getString(stack, TAG_WORLD, ""));
        ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
        if (pos == null || world == null) {
            return;
        }
        serverPlayer.func_200619_a(world, pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c(), player.field_70177_z, player.field_70125_A);
        world.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_232818_ms_, SoundCategory.PLAYERS, 1.0f, 1.0f);
        NetworkHandler.sendToClient(new PacketItemActivation(stack), serverPlayer);
        if (!player.field_71075_bZ.field_75098_d) {
            player.func_184811_cZ().func_185145_a(stack.func_77973_b(), (stats.timeBeforeActivation - NBTUtils.getInt(stack, TAG_TIME, 0)) * 20);
        }
        NBTUtils.setString(stack, TAG_WORLD, "");
        NBTUtils.setString(stack, TAG_POSITION, "");
        NBTUtils.setInt(stack, TAG_TIME, -1);
    }

    @Override
    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return false;
    }

    public static class Stats
    extends RelicStats {
        public int timeBeforeActivation = 30;
        public int experiencePerSecond = 1;
    }

    @Mod.EventBusSubscriber(modid="relics")
    public static class SpatialSignServerEvents {
        @SubscribeEvent
        public static void onEntityDeath(LivingDeathEvent event) {
            if (!(event.getEntity() instanceof PlayerEntity)) {
                return;
            }
            PlayerEntity player = (PlayerEntity)event.getEntity();
            if (EntityUtils.getSlotWithItem(player, (Item)ItemRegistry.SPATIAL_SIGN.get()) == -1) {
                return;
            }
            ItemStack stack = player.field_71071_by.func_70301_a(EntityUtils.getSlotWithItem(player, (Item)ItemRegistry.SPATIAL_SIGN.get()));
            if (!DurabilityUtils.isBroken(stack) && !NBTUtils.getString(stack, SpatialSignItem.TAG_POSITION, "").equals("")) {
                SpatialSignItem.teleportPlayer(player, stack);
                player.func_70606_j(1.0f);
                stack.func_196085_b(stack.func_77958_k());
                event.setCanceled(true);
            }
        }
    }
}

