/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.back;

import it.hurts.sskirillss.relics.client.renderer.items.models.ArrowQuiverModel;
import it.hurts.sskirillss.relics.client.tooltip.base.AbilityTooltip;
import it.hurts.sskirillss.relics.client.tooltip.base.RelicTooltip;
import it.hurts.sskirillss.relics.configs.data.relics.RelicConfigData;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicStats;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.network.PacketPlayerMotion;
import it.hurts.sskirillss.relics.utils.DurabilityUtils;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.Rarity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class ArrowQuiverItem
extends RelicItem<Stats>
implements ICurioItem {
    public static ArrowQuiverItem INSTANCE;
    private static final String TAG_CHARGED = "charged";
    private static final String TAG_ARROW = "arrow";

    public ArrowQuiverItem() {
        super(RelicData.builder().rarity(Rarity.UNCOMMON).hasAbility().build());
        INSTANCE = this;
    }

    @Override
    public RelicTooltip getTooltip(ItemStack stack) {
        return RelicTooltip.builder().borders("#c87625", "#ab661b").ability(AbilityTooltip.builder().arg(((Stats)this.stats).skippedTicks + 1).build()).ability(AbilityTooltip.builder().active().build()).build();
    }

    @Override
    public RelicConfigData<Stats> getConfigData() {
        return RelicConfigData.builder().stats(new Stats()).build();
    }

    public void curioTick(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        if (DurabilityUtils.isBroken(stack)) {
            return;
        }
        this.handleArrow(stack, livingEntity.func_130014_f_());
        this.handleUse(stack, livingEntity);
    }

    private void handleArrow(ItemStack stack, World world) {
        if (world.func_201670_d()) {
            return;
        }
        String UUIDString = NBTUtils.getString(stack, TAG_ARROW, "");
        ServerWorld serverWorld = (ServerWorld)world;
        if (UUIDString.equals("")) {
            return;
        }
        Entity arrow = serverWorld.func_217461_a(UUID.fromString(UUIDString));
        if (arrow == null || !arrow.func_70089_S()) {
            NBTUtils.setString(stack, TAG_ARROW, "");
            NBTUtils.setBoolean(stack, TAG_CHARGED, false);
            return;
        }
        serverWorld.func_195598_a((IParticleData)ParticleTypes.field_197613_f, arrow.func_226277_ct_(), arrow.func_226278_cu_(), arrow.func_226281_cx_(), 1, 0.0, 0.0, 0.0, 0.0);
    }

    private void handleUse(ItemStack stack, LivingEntity entity) {
        if (!entity.func_184587_cr() || NBTUtils.getBoolean(stack, TAG_CHARGED, false)) {
            return;
        }
        Item item = entity.func_184614_ca().func_77973_b();
        String id = item.getRegistryName().toString();
        if (item instanceof BowItem && !((Stats)this.stats).blacklistedItems.contains(id) || ((Stats)this.stats).whitelistedItems.contains(id)) {
            for (int i = 0; i < ((Stats)this.stats).skippedTicks; ++i) {
                entity.func_184608_ct();
            }
        }
    }

    @Override
    public void castAbility(PlayerEntity player, ItemStack stack) {
        if (player.func_184811_cZ().func_185141_a(stack.func_77973_b())) {
            return;
        }
        player.func_130014_f_().func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 1.0f, 1.0f);
        NBTUtils.setBoolean(stack, TAG_CHARGED, !NBTUtils.getBoolean(stack, TAG_CHARGED, false));
        NBTUtils.setString(stack, TAG_ARROW, "");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public BipedModel<LivingEntity> getModel() {
        return new ArrowQuiverModel();
    }

    public static class Stats
    extends RelicStats {
        public int skippedTicks = 1;
        public int activeCooldown = 10;
        public int explosionRadius = 5;
        public float explosionDamageMultiplier = 1.5f;
        public int maxExplosionDamage = 75;
        public List<String> whitelistedItems = new ArrayList<String>();
        public List<String> blacklistedItems = new ArrayList<String>();
    }

    @Mod.EventBusSubscriber(modid="relics")
    public static class Events {
        @SubscribeEvent
        public static void onArrowLoose(ArrowLooseEvent event) {
            Stats stats = (Stats)INSTANCE.stats;
            if (!(event.getEntityLiving() instanceof PlayerEntity)) {
                return;
            }
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)ItemRegistry.ARROW_QUIVER.get());
            if (stack.func_190926_b()) {
                return;
            }
            World world = player.func_130014_f_();
            if (!NBTUtils.getBoolean(stack, ArrowQuiverItem.TAG_CHARGED, false)) {
                return;
            }
            event.setCanceled(true);
            ItemStack bow = event.getBow();
            ItemStack ammo = player.func_213356_f(bow);
            if (ammo.func_190926_b()) {
                return;
            }
            AbstractArrowEntity projectile = ((ArrowItem)(ammo.func_77973_b() instanceof ArrowItem ? ammo.func_77973_b() : Items.field_151032_g)).func_200887_a(world, ammo, (LivingEntity)player);
            if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)bow) <= 0 && !player.func_184812_l_()) {
                projectile.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
                ammo.func_190918_g(1);
            }
            projectile.func_234612_a_((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, BowItem.func_185059_b((int)event.getCharge()) * 3.0f, 0.0f);
            world.func_217376_c((Entity)projectile);
            NBTUtils.setString(stack, ArrowQuiverItem.TAG_ARROW, projectile.func_189512_bd());
            player.func_184811_cZ().func_185145_a(stack.func_77973_b(), stats.activeCooldown * 20);
            world.func_195594_a((IParticleData)ParticleTypes.field_197627_t, player.func_226277_ct_(), player.func_226278_cu_() + 1.0, player.func_226281_cx_(), 0.0, 0.0, 0.0);
            world.func_184133_a(player, player.func_233580_cy_(), SoundEvents.field_187539_bB, SoundCategory.PLAYERS, 1.0f, 1.0f);
            world.func_184133_a(player, player.func_233580_cy_(), SoundEvents.field_187631_bo, SoundCategory.PLAYERS, 1.0f, 1.75f);
        }

        @SubscribeEvent
        public static void onProjectileImpact(ProjectileImpactEvent event) {
            Stats stats = (Stats)INSTANCE.stats;
            if (!(event.getEntity() instanceof ProjectileEntity)) {
                return;
            }
            ProjectileEntity projectile = (ProjectileEntity)event.getEntity();
            if (!(projectile.func_234616_v_() instanceof PlayerEntity)) {
                return;
            }
            PlayerEntity owner = (PlayerEntity)projectile.func_234616_v_();
            if (owner == null) {
                return;
            }
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)owner, (Item)ItemRegistry.ARROW_QUIVER.get());
            if (stack.func_190926_b()) {
                return;
            }
            World world = owner.func_130014_f_();
            if (DurabilityUtils.isBroken(stack) || !event.getEntity().func_110124_au().toString().equals(NBTUtils.getString(stack, ArrowQuiverItem.TAG_ARROW, ""))) {
                return;
            }
            for (LivingEntity entity : world.func_217357_a(LivingEntity.class, projectile.func_174813_aQ().func_186662_g((double)stats.explosionRadius))) {
                if (world.func_201670_d()) {
                    return;
                }
                Vector3d motion = entity.func_213303_ch().func_72441_c(0.0, 2.25, 0.0).func_178788_d(projectile.func_213303_ch()).func_72432_b().func_216372_d(1.5, 1.5, 1.5);
                if (!world.func_201670_d() && entity instanceof ServerPlayerEntity) {
                    NetworkHandler.sendToClient(new PacketPlayerMotion(motion.func_82615_a(), motion.func_82617_b(), motion.func_82616_c()), (ServerPlayerEntity)entity);
                } else {
                    entity.func_213317_d(motion);
                }
                if (entity.func_189512_bd().equals(owner.func_189512_bd())) continue;
                entity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)owner), (float)Math.min((double)stats.maxExplosionDamage, entity.func_213303_ch().func_72438_d(owner.func_213303_ch()) * (double)stats.explosionDamageMultiplier));
            }
            NBTUtils.setString(stack, ArrowQuiverItem.TAG_ARROW, "");
            NBTUtils.setBoolean(stack, ArrowQuiverItem.TAG_CHARGED, false);
            world.func_184133_a(null, projectile.func_233580_cy_(), SoundEvents.field_187539_bB, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
    }
}

