/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.base;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.matrix.MatrixStack;
import it.hurts.sskirillss.relics.api.durability.IRepairableItem;
import it.hurts.sskirillss.relics.client.particles.circle.CircleTintData;
import it.hurts.sskirillss.relics.client.tooltip.base.RelicTooltip;
import it.hurts.sskirillss.relics.configs.data.relics.RelicConfigData;
import it.hurts.sskirillss.relics.configs.data.relics.RelicLevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicAttributeModifier;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicSlotModifier;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicStats;
import it.hurts.sskirillss.relics.utils.DurabilityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public abstract class RelicItem<T extends RelicStats>
extends Item
implements ICurioItem,
IRepairableItem {
    protected RelicData data;
    protected RelicLevelingData leveling;
    protected T stats;
    protected RelicConfigData<T> configData;

    public RelicItem(RelicData data) {
        super(data.getRarity() == null ? data.getProperties() : data.getProperties().func_208103_a(data.getRarity()));
        this.setData(data);
        this.setConfig(this.getConfigData());
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        LinkedHashMultimap modifiers = LinkedHashMultimap.create();
        if (DurabilityUtils.isBroken(stack)) {
            return modifiers;
        }
        RelicAttributeModifier attributes = this.getAttributeModifiers(stack);
        RelicSlotModifier slots = this.getSlotModifiers(stack);
        if (attributes != null) {
            attributes.getAttributes().forEach(arg_0 -> RelicItem.lambda$getAttributeModifiers$0((Multimap)modifiers, uuid, stack, arg_0));
        }
        if (slots != null) {
            slots.getModifiers().forEach(arg_0 -> RelicItem.lambda$getAttributeModifiers$1((Multimap)modifiers, uuid, arg_0));
        }
        return modifiers;
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (!DurabilityUtils.isBroken(stack)) {
            Vector3d pos = entity.func_213303_ch();
            entity.func_130014_f_().func_195594_a((IParticleData)new CircleTintData(stack.func_77953_t().field_77937_e.func_211163_e() != null ? new Color(stack.func_77953_t().field_77937_e.func_211163_e(), false) : new Color(255, 255, 255), field_77697_d.nextFloat() * 0.025f + 0.04f, 25, 0.95f, true), pos.func_82615_a() + (double)(MathUtils.randomFloat(field_77697_d) * 0.25f), pos.func_82617_b() + (double)0.1f, pos.func_82616_c() + (double)(MathUtils.randomFloat(field_77697_d) * 0.25f), 0.0, (double)field_77697_d.nextFloat() * 0.05, 0.0);
        }
        return super.onEntityItemUpdate(stack, entity);
    }

    public void render(String identifier, int index, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int light, LivingEntity livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, ItemStack stack) {
        BipedModel<LivingEntity> model = this.getModel();
        if (model == null) {
            return;
        }
        matrixStack.func_227860_a_();
        model.func_225597_a_(livingEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        model.func_212843_a_(livingEntity, limbSwing, limbSwingAmount, partialTicks);
        ICurio.RenderHelper.followBodyRotations((LivingEntity)livingEntity, (BipedModel[])new BipedModel[]{model});
        model.func_225598_a_(matrixStack, renderTypeBuffer.getBuffer(RenderType.func_228644_e_((ResourceLocation)new ResourceLocation("relics", "textures/items/models/" + this.getRegistryName().func_110623_a() + ".png"))), light, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.func_227865_b_();
    }

    public List<ITextComponent> getTagsTooltip(List<ITextComponent> tagTooltips, ItemStack stack) {
        return new ArrayList<ITextComponent>();
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.field_185307_s;
    }

    public int getItemEnchantability(ItemStack stack) {
        return 1;
    }

    public boolean showAttributesTooltip(String identifier, ItemStack stack) {
        return false;
    }

    public boolean canEquip(String identifier, LivingEntity livingEntity, ItemStack stack) {
        return !DurabilityUtils.isBroken(stack);
    }

    public boolean canRender(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        return !DurabilityUtils.isBroken(stack);
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return !DurabilityUtils.isBroken(stack);
    }

    public int getMaxDamage(ItemStack stack) {
        switch (stack.func_77953_t()) {
            case COMMON: {
                return 250;
            }
            case UNCOMMON: {
                return 500;
            }
            case RARE: {
                return 750;
            }
            case EPIC: {
                return 1000;
            }
        }
        return 0;
    }

    public boolean isDamageable(ItemStack stack) {
        return this.getMaxDamage(stack) > 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public BipedModel<LivingEntity> getModel() {
        return null;
    }

    public RelicTooltip getTooltip(ItemStack stack) {
        return null;
    }

    public RelicAttributeModifier getAttributeModifiers(ItemStack stack) {
        return null;
    }

    public RelicSlotModifier getSlotModifiers(ItemStack stack) {
        return null;
    }

    public void castAbility(PlayerEntity player, ItemStack stack) {
    }

    public void setConfig(RelicConfigData<?> data) {
        this.leveling = data.getLevel();
        this.stats = data.getStats();
    }

    public RelicData getData() {
        return this.data;
    }

    public void setData(RelicData data) {
        this.data = data;
    }

    public RelicLevelingData getLeveling() {
        return this.leveling;
    }

    public void setLeveling(RelicLevelingData leveling) {
        this.leveling = leveling;
    }

    public T getStats() {
        return this.stats;
    }

    public void setStats(T stats) {
        this.stats = stats;
    }

    public RelicConfigData<T> getConfigData() {
        return this.configData;
    }

    public void setConfigData(RelicConfigData<T> configData) {
        this.configData = configData;
    }

    private static /* synthetic */ void lambda$getAttributeModifiers$1(Multimap modifiers, UUID uuid, Pair slot) {
        CuriosApi.getCuriosHelper().addSlotModifier(modifiers, (String)slot.getLeft(), uuid, (double)((Integer)slot.getRight()).intValue(), AttributeModifier.Operation.ADDITION);
    }

    private static /* synthetic */ void lambda$getAttributeModifiers$0(Multimap modifiers, UUID uuid, ItemStack stack, RelicAttributeModifier.Modifier attribute) {
        modifiers.put((Object)attribute.getAttribute(), (Object)new AttributeModifier(uuid, stack.func_77973_b().getRegistryName().func_110623_a() + "_" + attribute.getAttribute().getRegistryName().func_110623_a(), (double)attribute.getMultiplier(), attribute.getOperation()));
    }
}

