/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.necklace;

import it.hurts.sskirillss.relics.client.renderer.items.models.JellyfishNecklaceModel;
import it.hurts.sskirillss.relics.client.tooltip.base.AbilityTooltip;
import it.hurts.sskirillss.relics.client.tooltip.base.RelicTooltip;
import it.hurts.sskirillss.relics.configs.data.relics.RelicConfigData;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicAttributeModifier;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicStats;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class JellyfishNecklaceItem
extends RelicItem<Stats> {
    public static JellyfishNecklaceItem INSTANCE;

    public JellyfishNecklaceItem() {
        super(RelicData.builder().rarity(Rarity.RARE).hasAbility().build());
        INSTANCE = this;
    }

    @Override
    public RelicTooltip getTooltip(ItemStack stack) {
        return RelicTooltip.builder().borders("#53b2f8", "#0d4065").ability(AbilityTooltip.builder().arg("+" + (int)(((Stats)this.stats).healMultiplier * 100.0f - 100.0f) + "%").build()).ability(AbilityTooltip.builder().arg("+" + (int)(((Stats)this.stats).magicResistance * 100.0f) + "%").build()).ability(AbilityTooltip.builder().arg("-" + (int)Math.abs(((Stats)this.stats).swimSpeedModifier * 100.0f) + "%").negative().build()).ability(AbilityTooltip.builder().active().build()).build();
    }

    @Override
    public RelicConfigData<Stats> getConfigData() {
        return RelicConfigData.builder().stats(new Stats()).build();
    }

    @Override
    public RelicAttributeModifier getAttributeModifiers(ItemStack stack) {
        return RelicAttributeModifier.builder().attribute(new RelicAttributeModifier.Modifier((Attribute)ForgeMod.SWIM_SPEED.get(), ((Stats)this.stats).swimSpeedModifier)).build();
    }

    @Override
    public void castAbility(PlayerEntity player, ItemStack stack) {
        if (!player.func_70026_G() || player.func_184811_cZ().func_185141_a(stack.func_77973_b())) {
            return;
        }
        float rot = (float)Math.PI / 180;
        float f0 = MathHelper.func_76134_b((float)(player.field_70125_A * rot));
        float f1 = -MathHelper.func_76126_a((float)(player.field_70177_z * rot)) * f0;
        float f2 = -MathHelper.func_76126_a((float)(player.field_70125_A * rot));
        float f3 = MathHelper.func_76134_b((float)(player.field_70177_z * rot)) * f0;
        float f4 = MathHelper.func_76129_c((float)(f1 * f1 + f2 * f2 + f3 * f3));
        float f5 = ((Stats)this.stats).riptidePower;
        player.func_70024_g((double)(f1 *= f5 / f4), (double)(f2 *= f5 / f4), (double)(f3 *= f5 / f4));
        player.func_204803_n(20);
        player.func_184811_cZ().func_185145_a(stack.func_77973_b(), ((Stats)this.stats).riptideCooldown * 20);
        player.func_130014_f_().func_217384_a(null, (Entity)player, SoundEvents.field_203273_io, SoundCategory.PLAYERS, 1.0f, 1.0f);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public BipedModel<LivingEntity> getModel() {
        return new JellyfishNecklaceModel();
    }

    public static class Stats
    extends RelicStats {
        public float swimSpeedModifier = -0.2f;
        public float magicResistance = 0.25f;
        public float healMultiplier = 3.0f;
        public int riptideCooldown = 5;
        public float riptidePower = 2.0f;
    }

    @Mod.EventBusSubscriber(modid="relics")
    public static class JellyfishNecklaceEvents {
        @SubscribeEvent
        public static void onEntityHeal(LivingHealEvent event) {
            Stats stats = (Stats)INSTANCE.stats;
            LivingEntity entity = event.getEntityLiving();
            if (EntityUtils.findEquippedCurio((Entity)entity, (Item)ItemRegistry.JELLYFISH_NECKLACE.get()).func_190926_b() || !entity.func_70090_H()) {
                return;
            }
            event.setAmount(event.getAmount() * stats.healMultiplier);
        }

        @SubscribeEvent
        public static void onLivingHurt(LivingHurtEvent event) {
            Stats stats = (Stats)INSTANCE.stats;
            if (EntityUtils.findEquippedCurio((Entity)event.getEntityLiving(), (Item)ItemRegistry.JELLYFISH_NECKLACE.get()).func_190926_b() || event.getSource() != DamageSource.field_76376_m) {
                return;
            }
            event.setAmount(event.getAmount() * (1.0f - stats.magicResistance));
        }
    }
}

