/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.ring;

import it.hurts.sskirillss.relics.client.tooltip.base.AbilityTooltip;
import it.hurts.sskirillss.relics.client.tooltip.base.RelicTooltip;
import it.hurts.sskirillss.relics.configs.data.relics.RelicConfigData;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicStats;
import it.hurts.sskirillss.relics.utils.DurabilityUtils;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.SlotContext;

public class DelayRingItem
extends RelicItem<Stats> {
    public static final String TAG_UPDATE_TIME = "time";
    public static final String TAG_STORED_AMOUNT = "amount";
    public static final String TAG_KILLER_UUID = "killer";
    public static DelayRingItem INSTANCE;

    public DelayRingItem() {
        super(RelicData.builder().rarity(Rarity.EPIC).build());
        INSTANCE = this;
    }

    @Override
    public RelicTooltip getTooltip(ItemStack stack) {
        return RelicTooltip.builder().borders("#e60032", "#670d4e").ability(AbilityTooltip.builder().arg(((Stats)this.stats).delayDuration).build()).build();
    }

    @Override
    public RelicConfigData<Stats> getConfigData() {
        return RelicConfigData.builder().stats(new Stats()).build();
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (NBTUtils.getInt(stack, TAG_UPDATE_TIME, 0) > 0) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.relics.delay_ring.tooltip_1", new Object[]{NBTUtils.getInt(stack, TAG_UPDATE_TIME, 0)}));
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.relics.delay_ring.tooltip_2", new Object[]{NBTUtils.getInt(stack, TAG_STORED_AMOUNT, 0)}));
        }
    }

    public void curioTick(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        if (!(livingEntity instanceof PlayerEntity) || DurabilityUtils.isBroken(stack)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)livingEntity;
        World world = player.func_130014_f_();
        int points = NBTUtils.getInt(stack, TAG_STORED_AMOUNT, 0);
        int time = NBTUtils.getInt(stack, TAG_UPDATE_TIME, -1);
        if (player.field_70173_aa % 4 == 0 && time > 0) {
            world.func_195594_a((IParticleData)(points > 0 ? ParticleTypes.field_197633_z : ParticleTypes.field_197609_b), player.func_226277_ct_() + (double)(MathUtils.randomFloat(world.func_201674_k()) * 0.5f), player.func_226280_cw_() + (double)(MathUtils.randomFloat(world.func_201674_k()) * 0.5f), player.func_226281_cx_() + (double)(MathUtils.randomFloat(world.func_201674_k()) * 0.5f), 0.0, -0.25, 0.0);
        }
        if (world.func_201670_d() || player.func_184811_cZ().func_185141_a(stack.func_77973_b())) {
            return;
        }
        if (time > 0) {
            if (player.field_70173_aa % 20 == 0) {
                NBTUtils.setInt(stack, TAG_UPDATE_TIME, --time);
                world.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187909_gi, SoundCategory.MASTER, 0.75f, 1.0f + (float)time * 0.1f);
            }
        } else if (time == 0) {
            this.delay((LivingEntity)player, stack);
        }
    }

    private void delay(LivingEntity entity, ItemStack stack) {
        if (!(entity instanceof PlayerEntity) || DurabilityUtils.isBroken(stack)) {
            return;
        }
        NBTUtils.setInt(stack, TAG_UPDATE_TIME, -1);
        PlayerEntity player = (PlayerEntity)entity;
        World world = player.func_130014_f_();
        int points = NBTUtils.getInt(stack, TAG_STORED_AMOUNT, 0);
        world.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_232818_ms_, SoundCategory.MASTER, 1.0f, 1.0f);
        player.func_184811_cZ().func_185145_a(stack.func_77973_b(), ((Stats)this.stats).useCooldown * 20);
        if (points > 0) {
            player.func_70691_i((float)points);
        } else {
            PlayerEntity killer;
            String uuidString = NBTUtils.getString(stack, TAG_KILLER_UUID, "");
            DamageSource source = DamageSource.field_76377_j;
            if (!uuidString.equals("") && (killer = world.func_217371_b(UUID.fromString(uuidString))) != null) {
                source = DamageSource.func_76365_a((PlayerEntity)killer);
            }
            player.func_70097_a(source, 2.1474836E9f);
        }
        NBTUtils.setInt(stack, TAG_STORED_AMOUNT, 0);
        NBTUtils.setString(stack, TAG_KILLER_UUID, "");
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        if (NBTUtils.getInt(stack, TAG_UPDATE_TIME, -1) > -1 && newStack.func_77973_b() != stack.func_77973_b()) {
            this.delay(slotContext.getWearer(), stack);
        }
    }

    public static class Stats
    extends RelicStats {
        public int useCooldown = 60;
        public int delayDuration = 10;
        public float damageMultiplier = 1.0f;
        public float healMultiplier = 2.0f;
    }

    @Mod.EventBusSubscriber(modid="relics")
    public static class DelayRingEvents {
        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void onEntityDeath(LivingDeathEvent event) {
            Stats stats = (Stats)INSTANCE.stats;
            if (!(event.getEntityLiving() instanceof PlayerEntity)) {
                return;
            }
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)ItemRegistry.DELAY_RING.get());
            if (stack.func_190926_b() || player.func_184811_cZ().func_185141_a(stack.func_77973_b())) {
                return;
            }
            Entity source = event.getSource().func_76346_g();
            if (source instanceof PlayerEntity) {
                NBTUtils.setString(stack, DelayRingItem.TAG_KILLER_UUID, source.func_110124_au().toString());
            }
            NBTUtils.setInt(stack, DelayRingItem.TAG_UPDATE_TIME, stats.delayDuration);
            NBTUtils.setInt(stack, DelayRingItem.TAG_STORED_AMOUNT, 0);
            player.func_70606_j(1.0f);
            event.setCanceled(true);
        }

        @SubscribeEvent
        public static void onEntityHurt(LivingHurtEvent event) {
            Stats stats = (Stats)INSTANCE.stats;
            LivingEntity entity = event.getEntityLiving();
            if (!(entity instanceof PlayerEntity)) {
                return;
            }
            PlayerEntity player = (PlayerEntity)entity;
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)ItemRegistry.DELAY_RING.get());
            if (stack.func_190926_b() || player.func_184811_cZ().func_185141_a(stack.func_77973_b()) || NBTUtils.getInt(stack, DelayRingItem.TAG_UPDATE_TIME, -1) < 0) {
                return;
            }
            NBTUtils.setInt(stack, DelayRingItem.TAG_STORED_AMOUNT, NBTUtils.getInt(stack, DelayRingItem.TAG_STORED_AMOUNT, 0) - Math.round(event.getAmount() * stats.damageMultiplier));
            event.setCanceled(true);
        }

        @SubscribeEvent
        public static void onEntityHeal(LivingHealEvent event) {
            Stats stats = (Stats)INSTANCE.stats;
            LivingEntity entity = event.getEntityLiving();
            if (!(entity instanceof PlayerEntity)) {
                return;
            }
            PlayerEntity player = (PlayerEntity)entity;
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)ItemRegistry.DELAY_RING.get());
            if (stack.func_190926_b() || player.func_184811_cZ().func_185141_a(stack.func_77973_b()) || NBTUtils.getInt(stack, DelayRingItem.TAG_UPDATE_TIME, -1) < 0) {
                return;
            }
            NBTUtils.setInt(stack, DelayRingItem.TAG_STORED_AMOUNT, NBTUtils.getInt(stack, DelayRingItem.TAG_STORED_AMOUNT, 0) + Math.round(event.getAmount() * stats.healMultiplier));
            event.setCanceled(true);
        }
    }
}

