/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.talisman;

import it.hurts.sskirillss.relics.client.tooltip.base.AbilityTooltip;
import it.hurts.sskirillss.relics.client.tooltip.base.RelicTooltip;
import it.hurts.sskirillss.relics.configs.data.relics.RelicConfigData;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicStats;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.EntityTeleportEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class ChorusInhibitorItem
extends RelicItem<Stats> {
    public static ChorusInhibitorItem INSTANCE;

    public ChorusInhibitorItem() {
        super(RelicData.builder().rarity(Rarity.RARE).build());
        INSTANCE = this;
    }

    @Override
    public RelicTooltip getTooltip(ItemStack stack) {
        return RelicTooltip.builder().borders("#6e0096", "#201425").ability(AbilityTooltip.builder().arg(((Stats)this.stats).maxDistance).active(Minecraft.func_71410_x().field_71474_y.field_74313_G).build()).build();
    }

    @Override
    public RelicConfigData<Stats> getConfigData() {
        return RelicConfigData.builder().stats(new Stats()).build();
    }

    public static class Stats
    extends RelicStats {
        public int maxDistance = 50;
        public int safeChecks = 5;
    }

    @Mod.EventBusSubscriber(modid="relics")
    public static class ChorusInhibitorEvents {
        @SubscribeEvent
        public static void onChorusTeleport(EntityTeleportEvent.ChorusFruit event) {
            Stats stats = (Stats)INSTANCE.stats;
            if (!(event.getEntityLiving() instanceof PlayerEntity)) {
                return;
            }
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            if (EntityUtils.findEquippedCurio((Entity)player, (Item)ItemRegistry.CHORUS_INHIBITOR.get()).func_190926_b()) {
                return;
            }
            World world = player.func_130014_f_();
            Vector3d view = player.func_70676_i(0.0f);
            Vector3d eyeVec = player.func_174824_e(0.0f);
            BlockRayTraceResult ray = world.func_217299_a(new RayTraceContext(eyeVec, eyeVec.func_72441_c(view.field_72450_a * (double)stats.maxDistance, view.field_72448_b * (double)stats.maxDistance, view.field_72449_c * (double)stats.maxDistance), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)player));
            BlockPos pos = ray.func_216350_a();
            if (!world.func_180495_p(pos).func_185904_a().func_76220_a()) {
                return;
            }
            pos = pos.func_177984_a();
            for (int i = 0; i < stats.safeChecks; ++i) {
                if (!world.func_180495_p(pos).func_185904_a().func_76230_c() && !world.func_180495_p(pos.func_177984_a()).func_185904_a().func_76230_c()) {
                    event.setCanceled(true);
                    player.func_70634_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                    world.func_184133_a(null, pos, SoundEvents.field_187544_ad, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    break;
                }
                pos = pos.func_177984_a();
            }
        }
    }
}

