/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.talisman;

import it.hurts.sskirillss.relics.client.tooltip.base.AbilityTooltip;
import it.hurts.sskirillss.relics.client.tooltip.base.RelicTooltip;
import it.hurts.sskirillss.relics.configs.data.relics.RelicConfigData;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicStats;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class SporeSackItem
extends RelicItem<Stats> {
    public static SporeSackItem INSTANCE;

    public SporeSackItem() {
        super(RelicData.builder().rarity(Rarity.UNCOMMON).build());
        INSTANCE = this;
    }

    @Override
    public RelicTooltip getTooltip(ItemStack stack) {
        return RelicTooltip.builder().borders("#398f00", "#006e00").ability(AbilityTooltip.builder().arg((int)(((Stats)this.stats).chance * 100.0f) + "%").arg(((Stats)this.stats).radius).build()).build();
    }

    @Override
    public RelicConfigData<Stats> getConfigData() {
        return RelicConfigData.builder().stats(new Stats()).build();
    }

    public static class Stats
    extends RelicStats {
        public float chance = 0.3f;
        public int radius = 3;
        public int cooldown = 5;
        public int poisonAmplifier = 2;
        public int poisonDuration = 5;
        public int slownessAmplifier = 0;
        public int slownessDuration = 5;
    }

    @Mod.EventBusSubscriber(modid="relics")
    public static class SporeSackEvents {
        @SubscribeEvent
        public static void onProjectileImpact(ProjectileImpactEvent event) {
            Stats stats = (Stats)INSTANCE.stats;
            if (!(event.getEntity() instanceof ProjectileEntity)) {
                return;
            }
            ProjectileEntity projectile = (ProjectileEntity)event.getEntity();
            if (projectile.func_234616_v_() == null || !(projectile.func_234616_v_() instanceof PlayerEntity)) {
                return;
            }
            PlayerEntity player = (PlayerEntity)projectile.func_234616_v_();
            World world = projectile.func_130014_f_();
            if (world.func_201670_d()) {
                return;
            }
            if (EntityUtils.findEquippedCurio((Entity)player, (Item)ItemRegistry.SPORE_SACK.get()).func_190926_b() || world.func_201674_k().nextFloat() > stats.chance) {
                return;
            }
            ((ServerWorld)world).func_195598_a((IParticleData)new RedstoneParticleData(0.0f, 255.0f, 0.0f, 1.0f), projectile.func_226277_ct_(), projectile.func_226278_cu_(), projectile.func_226281_cx_(), 100, 1.0, 1.0, 1.0, 0.5);
            world.func_184133_a(null, projectile.func_233580_cy_(), SoundEvents.field_187646_bt, SoundCategory.PLAYERS, 1.0f, 0.5f);
            player.func_184811_cZ().func_185145_a((Item)ItemRegistry.SPORE_SACK.get(), stats.cooldown * 20);
            for (LivingEntity entity : world.func_217357_a(LivingEntity.class, projectile.func_174813_aQ().func_186662_g((double)stats.radius))) {
                if (entity == player) continue;
                entity.func_195064_c(new EffectInstance(Effects.field_76436_u, stats.poisonDuration * 20, stats.poisonAmplifier));
                entity.func_195064_c(new EffectInstance(Effects.field_76421_d, stats.slownessDuration * 20, stats.slownessAmplifier));
            }
        }
    }
}

