/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.utils;

import it.hurts.sskirillss.relics.utils.NBTUtils;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootTables;
import net.minecraft.world.World;

public class RelicUtils {

    public static class Worldgen {
        public static final List<String> AQUATIC = Arrays.asList(LootTables.field_204115_q.toString(), LootTables.field_204114_p.toString(), LootTables.field_204773_u.toString());
        public static final List<String> NETHER = Arrays.asList(LootTables.field_186425_g.toString(), LootTables.field_237382_N_.toString(), LootTables.field_237381_M_.toString(), LootTables.field_237380_L_.toString(), LootTables.field_237383_O_.toString(), LootTables.field_237384_P_.toString());
        public static final List<String> COLD = Arrays.asList(LootTables.field_186431_m.toString(), LootTables.field_215828_s.toString(), LootTables.field_215827_r.toString());
        public static final List<String> DESERT = Arrays.asList(LootTables.field_186429_k.toString(), LootTables.field_215825_p.toString());
        public static final List<String> CAVE = Arrays.asList(LootTables.field_186428_j.toString(), LootTables.field_186427_i.toString(), LootTables.field_186426_h.toString(), LootTables.field_186424_f.toString());
        public static final List<String> VILLAGE = Arrays.asList(LootTables.field_215825_p.toString(), LootTables.field_215828_s.toString(), LootTables.field_215827_r.toString(), LootTables.field_215826_q.toString(), LootTables.field_215829_t.toString());
    }

    public static class Owner {
        private static final String TAG_OWNER = "relics_owner";

        public static String getOwnerUUID(ItemStack stack) {
            return NBTUtils.getString(stack, TAG_OWNER, "");
        }

        @Nullable
        public static PlayerEntity getOwner(ItemStack stack, World world) {
            String uuid = Owner.getOwnerUUID(stack);
            return uuid.isEmpty() ? null : world.func_217371_b(UUID.fromString(uuid));
        }

        public static void setOwnerUUID(ItemStack stack, String uuid) {
            NBTUtils.setString(stack, TAG_OWNER, uuid);
        }
    }
}

