/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.world;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.hurts.sskirillss.relics.configs.data.runes.RuneLootData;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.RuneItem;
import java.util.List;
import java.util.Random;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootSerializers;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.LootFunctionManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RelicLootModifier
extends LootModifier {
    private static final Gson GSON = LootSerializers.func_237387_b_().create();
    private final LootEntry entry;
    private final ILootFunction[] functions;

    public RelicLootModifier(ILootCondition[] conditionsIn, LootEntry entry, ILootFunction[] functions) {
        super(conditionsIn);
        this.entry = entry;
        this.functions = functions;
    }

    @Nonnull
    public List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        this.entry.expand(context, generator -> generator.func_216188_a(ILootFunction.func_215858_a((BiFunction)LootFunctionManager.func_216241_a((BiFunction[])this.functions), generatedLoot::add, (LootContext)context), context));
        Random random = context.func_216032_b();
        for (RuneItem rune : ItemRegistry.getRegisteredRunes()) {
            RuneLootData loot = rune.getLoot();
            ItemStack stack = new ItemStack((IItemProvider)rune);
            stack.func_190920_e(random.nextInt(5) + 1);
            if (!loot.getTable().contains(context.getQueriedLootTableId().toString()) || !((double)random.nextFloat() <= loot.getChance())) continue;
            generatedLoot.add(stack);
        }
        return generatedLoot;
    }

    @Mod.EventBusSubscriber(modid="relics", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class EventHandler {
        @SubscribeEvent
        public static void registerModifierSerializers(@Nonnull RegistryEvent.Register<GlobalLootModifierSerializer<?>> event) {
            event.getRegistry().register((IForgeRegistryEntry)new Serializer().setRegistryName(new ResourceLocation("relics", "relic_gen")));
        }
    }

    private static class Serializer
    extends GlobalLootModifierSerializer<RelicLootModifier> {
        private Serializer() {
        }

        public RelicLootModifier read(ResourceLocation location, JsonObject object, ILootCondition[] conditions) {
            return new RelicLootModifier(conditions, (LootEntry)GSON.fromJson((JsonElement)JSONUtils.func_152754_s((JsonObject)object, (String)"entry"), LootEntry.class), object.has("functions") ? (ILootFunction[])GSON.fromJson((JsonElement)JSONUtils.func_151214_t((JsonObject)object, (String)"functions"), ILootFunction[].class) : new ILootFunction[]{});
        }

        public JsonObject write(RelicLootModifier instance) {
            JsonObject object = this.makeConditions(instance.conditions);
            object.add("entry", GSON.toJsonTree((Object)instance.entry, LootEntry.class));
            object.add("functions", GSON.toJsonTree((Object)instance.functions, ILootFunction[].class));
            return object;
        }
    }
}

