/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.misc;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootConditionType;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public class DetectRSLootTables
implements ILootCondition {
    public static final LootConditionType DETECT_RS_LOOT_TABLES = new LootConditionType((ILootSerializer)new Serializer());
    private final Set<ResourceLocation> blacklistedLootTableIds;

    private DetectRSLootTables(Set<ResourceLocation> blacklistedLootTableIds) {
        this.blacklistedLootTableIds = blacklistedLootTableIds;
    }

    public LootConditionType func_230419_b_() {
        return DETECT_RS_LOOT_TABLES;
    }

    public boolean test(LootContext lootContext) {
        ResourceLocation lootTableID = lootContext.getQueriedLootTableId();
        return !this.blacklistedLootTableIds.contains(lootTableID);
    }

    public static Builder builder(Set<ResourceLocation> blacklistedLootTableIds) {
        return new Builder(blacklistedLootTableIds);
    }

    public static class Serializer
    implements ILootSerializer<DetectRSLootTables> {
        Gson gson = new Gson();
        Type type = new TypeToken<List<String>>(){}.getType();

        public void serialize(JsonObject object, DetectRSLootTables instance, JsonSerializationContext ctx) {
            object.addProperty("loot_table_id", instance.blacklistedLootTableIds.toString());
        }

        public DetectRSLootTables deserialize(JsonObject object, JsonDeserializationContext ctx) {
            List unconvertedLootTableStrings = (List)this.gson.fromJson((JsonElement)JSONUtils.func_151214_t((JsonObject)object, (String)"blacklisted_loot_tables"), this.type);
            Set convertedLootTableStrings = unconvertedLootTableStrings.stream().map(ResourceLocation::new).collect(Collectors.toSet());
            return new DetectRSLootTables(convertedLootTableStrings);
        }
    }

    public static class Builder
    implements ILootCondition.IBuilder {
        private final Set<ResourceLocation> blacklistedLootTableIds;

        public Builder(Set<ResourceLocation> blacklistedLootTableIds) {
            if (blacklistedLootTableIds == null) {
                throw new IllegalArgumentException("Blacklisted loot table must not be null. Use \"blacklisted_loot_tables\":[] to denote no blacklist.");
            }
            this.blacklistedLootTableIds = blacklistedLootTableIds;
        }

        public ILootCondition build() {
            return new DetectRSLootTables(this.blacklistedLootTableIds);
        }
    }
}

