/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.misc;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.JsonOps;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.mixin.resources.FallbackResourceManagerAccessor;
import com.telepathicgrunt.repurposedstructures.mixin.resources.SimpleReloadableResourceManagerAccessor;
import com.telepathicgrunt.repurposedstructures.mixin.structures.JigsawPatternAccessor;
import com.telepathicgrunt.repurposedstructures.mixin.structures.TemplateManagerAccessor;
import com.telepathicgrunt.repurposedstructures.utils.SafeDecodingRegistryOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.FallbackResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;

public final class PoolAdditionMerger {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().setLenient().disableHtmlEscaping().create();
    private static final String DATA_TYPE = "pool_additions";
    private static final int FILE_SUFFIX_LENGTH = ".json".length();

    private PoolAdditionMerger() {
    }

    public static void mergeAdditionPools(FMLServerAboutToStartEvent event) {
        IResourceManager resourceManager = ((TemplateManagerAccessor)event.getServer().func_240792_aT_()).repurposedstructures_getResourceManager();
        Map<ResourceLocation, List<JsonElement>> poolAdditionJSON = PoolAdditionMerger.getPoolAdditionJSON(resourceManager);
        PoolAdditionMerger.parsePoolsAndBeginMerger(poolAdditionJSON, event.getServer().func_244267_aX());
    }

    private static Map<ResourceLocation, List<JsonElement>> getPoolAdditionJSON(IResourceManager resourceManager) {
        HashMap<ResourceLocation, List<JsonElement>> map = new HashMap<ResourceLocation, List<JsonElement>>();
        int dataTypeLength = DATA_TYPE.length() + 1;
        for (ResourceLocation fileIDWithExtension : resourceManager.func_199003_a(DATA_TYPE, fileString -> fileString.endsWith(".json"))) {
            String resourceLocationPath = fileIDWithExtension.func_110623_a();
            ResourceLocation fileID = new ResourceLocation(fileIDWithExtension.func_110624_b(), resourceLocationPath.substring(dataTypeLength, resourceLocationPath.length() - FILE_SUFFIX_LENGTH));
            try {
                for (InputStream fileStream : PoolAdditionMerger.getAllFileStreams(resourceManager, fileIDWithExtension)) {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileStream, StandardCharsets.UTF_8));
                    Throwable throwable = null;
                    try {
                        JsonElement poolJSONElement = (JsonElement)JSONUtils.func_193839_a((Gson)GSON, (Reader)bufferedReader, JsonElement.class);
                        if (poolJSONElement != null) {
                            if (!map.containsKey(fileID)) {
                                map.put(fileID, new ArrayList());
                            }
                            ((List)map.get(fileID)).add(poolJSONElement);
                            continue;
                        }
                        RepurposedStructures.LOGGER.error("(Repurposed Structures POOL MERGER) Couldn't load data file {} from {} as it's null or empty", (Object)fileID, (Object)fileIDWithExtension);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (bufferedReader == null) continue;
                        if (throwable != null) {
                            try {
                                ((Reader)bufferedReader).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ((Reader)bufferedReader).close();
                    }
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException exception) {
                RepurposedStructures.LOGGER.error("(Repurposed Structures POOL MERGER) Couldn't parse data file {} from {}", (Object)fileID, (Object)fileIDWithExtension, (Object)exception);
            }
        }
        return map;
    }

    private static List<InputStream> getAllFileStreams(IResourceManager resourceManager, ResourceLocation fileID) throws IOException {
        ArrayList<InputStream> fileStreams = new ArrayList<InputStream>();
        FallbackResourceManager namespaceResourceManager = ((SimpleReloadableResourceManagerAccessor)resourceManager).repurposedstructures_getFallbackResourceManager().get(fileID.func_110624_b());
        List<IResourcePack> allResourcePacks = ((FallbackResourceManagerAccessor)namespaceResourceManager).repurposedstructures_getPackList();
        for (IResourcePack resourcePack : allResourcePacks) {
            InputStream inputStream;
            if (!resourcePack.func_195764_b(ResourcePackType.SERVER_DATA, fileID) || (inputStream = ((FallbackResourceManagerAccessor)namespaceResourceManager).repurposedstructures_callGetWrappedResource(fileID, resourcePack)) == null) continue;
            fileStreams.add(inputStream);
        }
        return fileStreams;
    }

    private static void parsePoolsAndBeginMerger(Map<ResourceLocation, List<JsonElement>> poolAdditionJSON, DynamicRegistries dynamicRegistries) {
        MutableRegistry poolRegistry = dynamicRegistries.func_243612_b(Registry.field_243555_ax);
        SafeDecodingRegistryOps customRegistryOps = new SafeDecodingRegistryOps(JsonOps.INSTANCE, dynamicRegistries);
        for (Map.Entry<ResourceLocation, List<JsonElement>> entry : poolAdditionJSON.entrySet()) {
            if (poolRegistry.func_82594_a(entry.getKey()) == null) continue;
            for (JsonElement jsonElement : entry.getValue()) {
                JigsawPattern.field_236852_a_.parse(customRegistryOps, (Object)jsonElement).resultOrPartial(messageString -> PoolAdditionMerger.logBadData((ResourceLocation)entry.getKey(), messageString)).ifPresent(validPool -> PoolAdditionMerger.mergeIntoExistingPool(validPool, (JigsawPattern)poolRegistry.func_82594_a((ResourceLocation)entry.getKey())));
            }
        }
    }

    private static void mergeIntoExistingPool(JigsawPattern feedingPool, JigsawPattern gluttonyPool) {
        ArrayList<JigsawPiece> elements = new ArrayList<JigsawPiece>(((JigsawPatternAccessor)gluttonyPool).repurposedstructures_getTemplates());
        ArrayList<Pair<JigsawPiece, Integer>> elementCounts = new ArrayList<Pair<JigsawPiece, Integer>>(((JigsawPatternAccessor)gluttonyPool).repurposedstructures_getRawTemplates());
        elements.addAll(((JigsawPatternAccessor)feedingPool).repurposedstructures_getTemplates());
        elementCounts.addAll(((JigsawPatternAccessor)feedingPool).repurposedstructures_getRawTemplates());
        ((JigsawPatternAccessor)gluttonyPool).repurposedstructures_setTemplates(elements);
        ((JigsawPatternAccessor)gluttonyPool).repurposedstructures_setRawTemplates(elementCounts);
    }

    private static void logBadData(ResourceLocation poolPath, String messageString) {
        RepurposedStructures.LOGGER.error("(Repurposed Structures POOL MERGER) Failed to parse {} additions file. Error is: {}", (Object)poolPath, (Object)messageString);
    }
}

