/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features;

import com.google.common.collect.ImmutableList;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.world.features.configs.NbtFeatureConfig;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class NbtFeature
extends Feature<NbtFeatureConfig> {
    private final BlockIgnoreStructureProcessor IGNORE_STRUCTURE_VOID = new BlockIgnoreStructureProcessor((List)ImmutableList.of((Object)Blocks.field_189881_dj));
    private final PlacementSettings placementsettings = new PlacementSettings().func_186214_a(Mirror.NONE).func_215222_a((StructureProcessor)this.IGNORE_STRUCTURE_VOID).func_186222_a(false);

    public NbtFeature() {
        super(NbtFeatureConfig.CODEC);
    }

    public boolean place(ISeedReader world, ChunkGenerator chunkGenerator, Random random, BlockPos position, NbtFeatureConfig config) {
        ResourceLocation nbtRL;
        if (GeneralUtils.isBlacklistedForWorld(world, config.cfID)) {
            return false;
        }
        BlockPos.Mutable mutable = new BlockPos.Mutable().func_189533_g((Vector3i)position);
        mutable.func_189536_c(Direction.UP);
        while (world.func_175623_d((BlockPos)mutable) && mutable.func_177956_o() > 2) {
            mutable.func_189536_c(Direction.DOWN);
        }
        if (world.func_180495_p((BlockPos)mutable).func_196958_f() || world.func_175623_d(mutable.func_177977_b()) || world.func_175623_d(mutable.func_177979_c(2))) {
            return false;
        }
        mutable.func_189536_c(Direction.DOWN);
        if (config.nbtResourcelocationsAndWeights.size() == 0) {
            return false;
        }
        BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable();
        TemplateManager templatemanager = world.func_201672_e().func_73046_m().func_240792_aT_();
        Template template = templatemanager.func_200219_b(nbtRL = (ResourceLocation)GeneralUtils.getRandomEntry(config.nbtResourcelocationsAndWeights, random));
        if (template == null) {
            RepurposedStructures.LOGGER.warn(config.nbtResourcelocationsAndWeights.toString() + " NTB does not exist!");
            return false;
        }
        int radius = template.func_186259_a().func_177958_n() / 2;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                if (x * x + z * z >= radius * radius + 1) continue;
                blockpos$Mutable.func_189533_g((Vector3i)position).func_196234_d(x, 0, z);
                if (!config.allowInWater && !world.func_204610_c((BlockPos)blockpos$Mutable).func_206888_e()) {
                    return false;
                }
                if (!world.func_180495_p((BlockPos)blockpos$Mutable.func_189536_c(Direction.UP)).func_200132_m() && world.func_180495_p((BlockPos)blockpos$Mutable.func_189534_c(Direction.DOWN, 3)).func_200132_m()) continue;
                return false;
            }
        }
        BlockPos halfLengths = new BlockPos(template.func_186259_a().func_177958_n() / 2, 0, template.func_186259_a().func_177952_p() / 2);
        this.placementsettings.func_186220_a(Rotation.func_222466_a((Random)random)).func_207665_a(halfLengths).func_186222_a(false);
        if (config.processor != null) {
            world.func_241828_r().func_243612_b(Registry.field_243554_aw).func_241873_b(config.processor).ifPresent(processor -> processor.func_242919_a().forEach(arg_0 -> ((PlacementSettings)this.placementsettings).func_215222_a(arg_0)));
        }
        blockpos$Mutable.func_189533_g((Vector3i)position);
        BlockPos offset = new BlockPos(-template.func_186259_a().func_177958_n() / 2, config.heightOffset, -template.func_186259_a().func_177952_p() / 2);
        template.func_237152_b_((IServerWorld)world, blockpos$Mutable.func_177971_a((Vector3i)offset), this.placementsettings, random);
        return true;
    }
}

