/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.telepathicgrunt.repurposedstructures.world.structures.AdvancedJigsawStructure;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.IStructureReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.util.Lazy;

public class MineshaftStructure
extends AdvancedJigsawStructure {
    protected final Lazy<Double> probability;

    public MineshaftStructure(ResourceLocation poolID, Lazy<Integer> structureSize, int biomeRange, Lazy<Integer> maxY, Lazy<Integer> minY, boolean clipOutOfBoundsPieces, Lazy<Integer> verticalRange, Lazy<Double> probability) {
        super(poolID, structureSize, biomeRange, maxY, minY, clipOutOfBoundsPieces, verticalRange);
        this.probability = probability;
    }

    @Override
    public BlockPos func_236388_a_(IWorldReader world, StructureManager structureAccessor, BlockPos searchStartPos, int searchRadius, boolean skipExistingChunks, long worldSeed, StructureSeparationSettings config) {
        return MineshaftStructure.locateStructureFast(world, structureAccessor, searchStartPos, searchRadius, skipExistingChunks, worldSeed, config, this, (Double)this.probability.get());
    }

    public static <C extends IFeatureConfig> BlockPos locateStructureFast(IWorldReader worldView, StructureManager structureAccessor, BlockPos blockPos, int radius, boolean skipExistingChunks, long seed, StructureSeparationSettings structureConfig, Structure<C> structure, double probability) {
        int spacing = structureConfig.func_236668_a_();
        int chunkX = blockPos.func_177958_n() >> 4;
        int chunkZ = blockPos.func_177952_p() >> 4;
        SharedSeedRandom msRandom = new SharedSeedRandom();
        int maxRadius = radius < 100 ? radius : 50000;
        SharedSeedRandom chunkRandom = new SharedSeedRandom();
        for (int currentRadius = 0; currentRadius <= maxRadius; ++currentRadius) {
            for (int xRadius = -currentRadius; xRadius <= currentRadius; ++xRadius) {
                boolean xEdge = xRadius == -currentRadius || xRadius == currentRadius;
                for (int zRadius = -currentRadius; zRadius <= currentRadius; ++zRadius) {
                    boolean zEdge;
                    boolean bl = zEdge = zRadius == -currentRadius || zRadius == currentRadius;
                    if (xEdge || zEdge) {
                        IChunk chunk;
                        StructureStart structureStart;
                        int trueChunkX = chunkX + spacing * xRadius;
                        int trueChunkZ = chunkZ + spacing * zRadius;
                        ChunkPos chunkPos = structure.func_236392_a_(structureConfig, seed, chunkRandom, trueChunkX, trueChunkZ);
                        msRandom.func_202425_c(seed + (long)structureConfig.func_236673_c_(), chunkPos.field_77276_a, chunkPos.field_77275_b);
                        double d = probability / 10000.0;
                        if (!(msRandom.nextDouble() < d) || !worldView.func_225526_b_((chunkPos.field_77276_a << 2) + 2, 60, (chunkPos.field_77275_b << 2) + 2).func_242440_e().func_242493_a(structure) || (structureStart = structureAccessor.func_235013_a_(SectionPos.func_218156_a((ChunkPos)(chunk = worldView.func_217348_a(chunkPos.field_77276_a, chunkPos.field_77275_b, ChunkStatus.field_222606_b)).func_76632_l(), (int)0), structure, (IStructureReader)chunk)) == null || !structureStart.func_75069_d()) continue;
                        if (skipExistingChunks && structureStart.func_212687_g()) {
                            structureStart.func_212685_h();
                            return structureStart.func_204294_a();
                        }
                        if (skipExistingChunks) continue;
                        return structureStart.func_204294_a();
                    }
                    zRadius = currentRadius - 1;
                }
            }
        }
        return null;
    }

    @Override
    protected boolean isFeatureChunk(ChunkGenerator chunkGenerator, BiomeProvider biomeSource, long seed, SharedSeedRandom chunkRandom, int chunkX, int chunkZ, Biome biome, ChunkPos chunkPos, NoFeatureConfig featureConfig) {
        StructureSeparationSettings structureConfig = chunkGenerator.func_235957_b_().func_236197_a_((Structure)this);
        if (structureConfig != null) {
            chunkRandom.func_202425_c(seed + (long)structureConfig.func_236673_c_(), chunkX, chunkZ);
            double d = (Double)this.probability.get() / 10000.0;
            return chunkRandom.nextDouble() < d;
        }
        return false;
    }

    public static class Builder<T extends Builder<T>>
    extends AdvancedJigsawStructure.Builder<T> {
        protected Lazy<Double> probability = Lazy.of(() -> 0.01);

        public Builder(ResourceLocation startPool) {
            super(startPool);
        }

        public T setProbability(ForgeConfigSpec.DoubleValue probability) {
            this.probability = Lazy.of(() -> ((ForgeConfigSpec.DoubleValue)probability).get());
            return (T)((Builder)this.getThis());
        }

        @Override
        public MineshaftStructure build() {
            return new MineshaftStructure(this.startPool, (Lazy<Integer>)this.structureSize, this.biomeRange, (Lazy<Integer>)this.maxY, (Lazy<Integer>)this.minY, this.clipOutOfBoundsPieces, (Lazy<Integer>)this.verticalRange, this.probability);
        }
    }
}

