/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures.pieces;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.repurposedstructures.mixin.structures.SingleJigsawPieceAccessor;
import com.telepathicgrunt.repurposedstructures.modinit.RSStructurePieces;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.Blocks;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.jigsaw.IJigsawDeserializer;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.SingleJigsawPiece;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.JigsawReplacementStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.ProcessorLists;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.StructureProcessorList;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class MirroringSingleJigsawPiece
extends SingleJigsawPiece {
    private static final Codec<Either<ResourceLocation, Template>> TEMPLATE_CODEC = Codec.of(MirroringSingleJigsawPiece::encodeTemplate, (Decoder)ResourceLocation.field_240908_a_.map(Either::left));
    public static final Codec<MirroringSingleJigsawPiece> CODEC = RecordCodecBuilder.create(jigsawPieceInstance -> jigsawPieceInstance.group((App)MirroringSingleJigsawPiece.func_236846_c_(), (App)MirroringSingleJigsawPiece.func_236844_b_(), (App)MirroringSingleJigsawPiece.func_236848_d_(), MirroringSingleJigsawPiece.mirrorCodec()).apply((Applicative)jigsawPieceInstance, MirroringSingleJigsawPiece::new));
    protected final Mirror mirror;

    private static <T> DataResult<T> encodeTemplate(Either<ResourceLocation, Template> templateEither, DynamicOps<T> dynamicOps, T t) {
        Optional optional = templateEither.left();
        return !optional.isPresent() ? DataResult.error((String)"Can not serialize a runtime pool element") : ResourceLocation.field_240908_a_.encode(optional.get(), dynamicOps, t);
    }

    protected static <E extends MirroringSingleJigsawPiece> RecordCodecBuilder<E, Mirror> mirrorCodec() {
        return Codec.STRING.fieldOf("mirror").xmap(Mirror::valueOf, Enum::toString).forGetter(jigsawPieceInstance -> jigsawPieceInstance.mirror);
    }

    public MirroringSingleJigsawPiece(SingleJigsawPiece singleJigsawPiece, Mirror mirror) {
        this(((SingleJigsawPieceAccessor)singleJigsawPiece).getTemplate(), ((SingleJigsawPieceAccessor)singleJigsawPiece).getProcessors(), singleJigsawPiece.func_214854_c(), mirror);
    }

    protected MirroringSingleJigsawPiece(Either<ResourceLocation, Template> locationTemplateEither, Supplier<StructureProcessorList> processorListSupplier, JigsawPattern.PlacementBehaviour placementBehaviour, Mirror mirror) {
        super(locationTemplateEither, processorListSupplier, placementBehaviour);
        this.mirror = mirror;
    }

    public MirroringSingleJigsawPiece(Template template) {
        this((Either<ResourceLocation, Template>)Either.right((Object)template), () -> ProcessorLists.field_244101_a, JigsawPattern.PlacementBehaviour.RIGID, Mirror.NONE);
    }

    private Template getTemplate(TemplateManager templateManager) {
        return (Template)this.field_236839_c_.map(arg_0 -> ((TemplateManager)templateManager).func_200220_a(arg_0), Function.identity());
    }

    public List<Template.BlockInfo> func_214849_a(TemplateManager templateManager, BlockPos blockPos, Rotation rotation, Random random) {
        Template template = this.getTemplate(templateManager);
        List list = template.func_215386_a(blockPos, new PlacementSettings().func_186220_a(rotation), Blocks.field_226904_lY_, true);
        Collections.shuffle(list, random);
        return list;
    }

    public MutableBoundingBox func_214852_a(TemplateManager templateManager, BlockPos blockPos, Rotation rotation) {
        Template template = this.getTemplate(templateManager);
        return template.func_215388_b(new PlacementSettings().func_186220_a(rotation).func_186214_a(this.mirror), blockPos);
    }

    public boolean func_230378_a_(TemplateManager templateManager, ISeedReader seedReader, StructureManager structureManager, ChunkGenerator chunkGenerator, BlockPos blockPos, BlockPos blockPos1, Rotation rotation, MutableBoundingBox mutableBoundingBox, Random random, boolean doNotReplaceJigsaw) {
        PlacementSettings placementsettings;
        Template template = this.getTemplate(templateManager);
        if (!template.func_237146_a_((IServerWorld)seedReader, blockPos, blockPos1, placementsettings = this.func_230379_a_(rotation, mutableBoundingBox, doNotReplaceJigsaw), random, 18)) {
            return false;
        }
        for (Template.BlockInfo template$blockinfo : Template.processBlockInfos((IWorld)seedReader, (BlockPos)blockPos, (BlockPos)blockPos1, (PlacementSettings)placementsettings, (List)this.func_214857_a(templateManager, blockPos, rotation, false), (Template)template)) {
            this.func_214846_a((IWorld)seedReader, template$blockinfo, blockPos, rotation, random, mutableBoundingBox);
        }
        return true;
    }

    protected PlacementSettings func_230379_a_(Rotation rotation, MutableBoundingBox mutableBoundingBox, boolean doNotReplaceJigsaw) {
        PlacementSettings placementsettings = new PlacementSettings();
        placementsettings.func_186223_a(mutableBoundingBox);
        placementsettings.func_186220_a(rotation);
        placementsettings.func_186214_a(this.mirror);
        placementsettings.func_186222_a(false);
        placementsettings.func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
        placementsettings.func_237133_d_(true);
        if (!doNotReplaceJigsaw) {
            placementsettings.func_215222_a((StructureProcessor)JigsawReplacementStructureProcessor.field_215196_a);
        }
        ((StructureProcessorList)this.field_214862_b.get()).func_242919_a().forEach(arg_0 -> ((PlacementSettings)placementsettings).func_215222_a(arg_0));
        this.func_214854_c().func_214937_b().forEach(arg_0 -> ((PlacementSettings)placementsettings).func_215222_a(arg_0));
        return placementsettings;
    }

    public IJigsawDeserializer<?> func_214853_a() {
        return RSStructurePieces.MIRROR_SINGLE;
    }

    public String toString() {
        return "Mirror_Single[" + this.field_236839_c_ + "]";
    }
}

