/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.sampler;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.zip.GZIPOutputStream;
import me.lucko.spark.common.command.sender.CommandSender;
import me.lucko.spark.common.platform.PlatformInfo;
import me.lucko.spark.common.sampler.node.MergeMode;
import me.lucko.spark.common.sampler.node.ThreadNode;
import me.lucko.spark.common.util.ClassSourceLookup;
import me.lucko.spark.proto.SparkProtos;

public interface Sampler {
    public void start();

    public void stop();

    public long getStartTime();

    public long getEndTime();

    public CompletableFuture<? extends Sampler> getFuture();

    public SparkProtos.SamplerData toProto(ExportProps var1);

    default public byte[] formCompressedDataPayload(ExportProps props) {
        SparkProtos.SamplerData proto = this.toProto(props);
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        try (GZIPOutputStream out = new GZIPOutputStream(byteOut);){
            proto.writeTo(out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return byteOut.toByteArray();
    }

    public static class ExportProps {
        public final PlatformInfo platformInfo;
        public final CommandSender creator;
        public final Comparator<? super Map.Entry<String, ThreadNode>> outputOrder;
        public final String comment;
        public final MergeMode mergeMode;
        public final ClassSourceLookup classSourceLookup;

        public ExportProps(PlatformInfo platformInfo, CommandSender creator, Comparator<? super Map.Entry<String, ThreadNode>> outputOrder, String comment, MergeMode mergeMode, ClassSourceLookup classSourceLookup) {
            this.platformInfo = platformInfo;
            this.creator = creator;
            this.outputOrder = outputOrder;
            this.comment = comment;
            this.mergeMode = mergeMode;
            this.classSourceLookup = classSourceLookup;
        }
    }
}

