/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.sampler.async.jfr;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.lucko.spark.common.sampler.async.AsyncStackTraceElement;
import me.lucko.spark.common.sampler.async.jfr.Dictionary;

public class JfrReader
implements Closeable {
    private static final int CHUNK_HEADER_SIZE = 68;
    private static final int CPOOL_OFFSET = 16;
    private static final int META_OFFSET = 24;
    private final FileChannel ch;
    private final ByteBuffer buf;
    public final long startNanos;
    public final long durationNanos;
    public final long startTicks;
    public final long ticksPerSec;
    public final Dictionary<JfrClass> types = new Dictionary();
    public final Map<String, JfrClass> typesByName = new HashMap<String, JfrClass>();
    public final Dictionary<String> threads = new Dictionary();
    public final Dictionary<ClassRef> classes = new Dictionary();
    public final Dictionary<byte[]> symbols = new Dictionary();
    public final Dictionary<MethodRef> methods = new Dictionary();
    public final Dictionary<StackTrace> stackTraces = new Dictionary();
    public final Dictionary<AsyncStackTraceElement> stackFrames = new Dictionary();
    public final Map<Integer, String> frameTypes = new HashMap<Integer, String>();
    public final Map<Integer, String> threadStates = new HashMap<Integer, String>();
    public final List<Sample> samples = new ArrayList<Sample>();

    public JfrReader(Path path) throws IOException {
        this.ch = FileChannel.open(path, StandardOpenOption.READ);
        this.buf = this.ch.map(FileChannel.MapMode.READ_ONLY, 0L, this.ch.size());
        if (this.buf.getInt(0) != 1179406848) {
            throw new IOException("Not a valid JFR file");
        }
        int version = this.buf.getInt(4);
        if (version < 131072 || version > 196607) {
            throw new IOException("Unsupported JFR version: " + (version >>> 16) + "." + (version & 0xFFFF));
        }
        this.startNanos = this.buf.getLong(32);
        this.durationNanos = this.buf.getLong(40);
        this.startTicks = this.buf.getLong(48);
        this.ticksPerSec = this.buf.getLong(56);
        this.readMeta();
        this.readConstantPool();
        this.readEvents();
    }

    @Override
    public void close() throws IOException {
        this.ch.close();
    }

    private void readMeta() {
        this.buf.position(this.buf.getInt(28));
        this.getVarint();
        this.getVarint();
        this.getVarlong();
        this.getVarlong();
        this.getVarlong();
        String[] strings = new String[this.getVarint()];
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = this.getString();
        }
        this.readElement(strings);
    }

    private Element readElement(String[] strings) {
        String name = strings[this.getVarint()];
        int attributeCount = this.getVarint();
        HashMap<String, String> attributes = new HashMap<String, String>(attributeCount);
        for (int i = 0; i < attributeCount; ++i) {
            attributes.put(strings[this.getVarint()], strings[this.getVarint()]);
        }
        Element e = this.createElement(name, attributes);
        int childCount = this.getVarint();
        for (int i = 0; i < childCount; ++i) {
            e.addChild(this.readElement(strings));
        }
        return e;
    }

    private Element createElement(String name, Map<String, String> attributes) {
        switch (name) {
            case "class": {
                JfrClass type = new JfrClass(attributes);
                if (!attributes.containsKey("superType")) {
                    this.types.put(type.id, type);
                }
                this.typesByName.put(type.name, type);
                return type;
            }
            case "field": {
                return new JfrField(attributes);
            }
        }
        return new Element();
    }

    private void readConstantPool() {
        int offset = this.buf.getInt(20);
        while (true) {
            this.buf.position(offset);
            this.getVarint();
            this.getVarint();
            this.getVarlong();
            this.getVarlong();
            long delta = this.getVarlong();
            this.getVarint();
            int poolCount = this.getVarint();
            for (int i = 0; i < poolCount; ++i) {
                int type = this.getVarint();
                this.readConstants(this.types.get(type));
            }
            if (delta == 0L) break;
            offset = (int)((long)offset + delta);
        }
    }

    private void readConstants(JfrClass type) {
        switch (type.name) {
            case "jdk.types.ChunkHeader": {
                this.buf.position(this.buf.position() + 71);
                break;
            }
            case "java.lang.Thread": {
                this.readThreads(type.field("group") != null);
                break;
            }
            case "java.lang.Class": {
                this.readClasses(type.field("hidden") != null);
                break;
            }
            case "jdk.types.Symbol": {
                this.readSymbols();
                break;
            }
            case "jdk.types.Method": {
                this.readMethods();
                break;
            }
            case "jdk.types.StackTrace": {
                this.readStackTraces();
                break;
            }
            case "jdk.types.FrameType": {
                this.readMap(this.frameTypes);
                break;
            }
            case "jdk.types.ThreadState": {
                this.readMap(this.threadStates);
                break;
            }
            default: {
                this.readOtherConstants(type.fields);
            }
        }
    }

    private void readThreads(boolean hasGroup) {
        int count = this.threads.preallocate(this.getVarint());
        for (int i = 0; i < count; ++i) {
            long id = this.getVarlong();
            String osName = this.getString();
            int osThreadId = this.getVarint();
            String javaName = this.getString();
            long javaThreadId = this.getVarlong();
            if (hasGroup) {
                this.getVarlong();
            }
            this.threads.put(id, javaName != null ? javaName : osName);
        }
    }

    private void readClasses(boolean hasHidden) {
        int count = this.classes.preallocate(this.getVarint());
        for (int i = 0; i < count; ++i) {
            long id = this.getVarlong();
            long loader = this.getVarlong();
            long name = this.getVarlong();
            long pkg = this.getVarlong();
            int modifiers = this.getVarint();
            if (hasHidden) {
                this.getVarint();
            }
            this.classes.put(id, new ClassRef(name));
        }
    }

    private void readMethods() {
        int count = this.methods.preallocate(this.getVarint());
        for (int i = 0; i < count; ++i) {
            long id = this.getVarlong();
            long cls = this.getVarlong();
            long name = this.getVarlong();
            long sig = this.getVarlong();
            int modifiers = this.getVarint();
            int hidden = this.getVarint();
            this.methods.put(id, new MethodRef(cls, name, sig));
        }
        this.stackFrames.preallocate(count);
    }

    private void readStackTraces() {
        int count = this.stackTraces.preallocate(this.getVarint());
        for (int i = 0; i < count; ++i) {
            long id = this.getVarlong();
            int truncated = this.getVarint();
            StackTrace stackTrace = this.readStackTrace();
            this.stackTraces.put(id, stackTrace);
        }
    }

    private StackTrace readStackTrace() {
        int depth = this.getVarint();
        long[] methods = new long[depth];
        byte[] types = new byte[depth];
        for (int i = 0; i < depth; ++i) {
            methods[i] = this.getVarlong();
            int line = this.getVarint();
            int bci = this.getVarint();
            types[i] = this.buf.get();
        }
        return new StackTrace(methods, types);
    }

    private void readSymbols() {
        int count = this.symbols.preallocate(this.getVarint());
        for (int i = 0; i < count; ++i) {
            long id = this.getVarlong();
            if (this.buf.get() != 3) {
                throw new IllegalArgumentException("Invalid symbol encoding");
            }
            this.symbols.put(id, this.getBytes());
        }
    }

    private void readMap(Map<Integer, String> map) {
        int count = this.getVarint();
        for (int i = 0; i < count; ++i) {
            map.put(this.getVarint(), this.getString());
        }
    }

    private void readOtherConstants(List<JfrField> fields) {
        int stringType = this.getTypeId("java.lang.String");
        boolean[] numeric = new boolean[fields.size()];
        for (int i = 0; i < numeric.length; ++i) {
            JfrField f = fields.get(i);
            numeric[i] = f.constantPool || f.type != stringType;
        }
        int count = this.getVarint();
        for (int i = 0; i < count; ++i) {
            this.getVarlong();
            this.readFields(numeric);
        }
    }

    private void readFields(boolean[] numeric) {
        for (boolean n : numeric) {
            if (n) {
                this.getVarlong();
                continue;
            }
            this.getString();
        }
    }

    private void readEvents() {
        int executionSample = this.getTypeId("jdk.ExecutionSample");
        int nativeMethodSample = this.getTypeId("jdk.NativeMethodSample");
        this.buf.position(68);
        while (this.buf.hasRemaining()) {
            int position = this.buf.position();
            int size = this.getVarint();
            int type = this.getVarint();
            if (type == executionSample || type == nativeMethodSample) {
                this.readExecutionSample();
                continue;
            }
            this.buf.position(position + size);
        }
        Collections.sort(this.samples);
    }

    private void readExecutionSample() {
        long time = this.getVarlong();
        int tid = this.getVarint();
        int stackTraceId = this.getVarint();
        int threadState = this.getVarint();
        this.samples.add(new Sample(time, tid, stackTraceId, threadState));
        StackTrace stackTrace = this.stackTraces.get(stackTraceId);
        if (stackTrace != null) {
            ++stackTrace.samples;
        }
    }

    private int getTypeId(String typeName) {
        JfrClass type = this.typesByName.get(typeName);
        return type != null ? type.id : -1;
    }

    private int getVarint() {
        int result = 0;
        int shift = 0;
        while (true) {
            byte b = this.buf.get();
            result |= (b & 0x7F) << shift;
            if (b >= 0) {
                return result;
            }
            shift += 7;
        }
    }

    private long getVarlong() {
        long result = 0L;
        for (int shift = 0; shift < 56; shift += 7) {
            byte b = this.buf.get();
            result |= ((long)b & 0x7FL) << shift;
            if (b < 0) continue;
            return result;
        }
        return result | ((long)this.buf.get() & 0xFFL) << 56;
    }

    private String getString() {
        switch (this.buf.get()) {
            case 0: {
                return null;
            }
            case 1: {
                return "";
            }
            case 3: {
                return new String(this.getBytes(), StandardCharsets.UTF_8);
            }
            case 4: {
                char[] chars = new char[this.getVarint()];
                for (int i = 0; i < chars.length; ++i) {
                    chars[i] = (char)this.getVarint();
                }
                return new String(chars);
            }
            case 5: {
                return new String(this.getBytes(), StandardCharsets.ISO_8859_1);
            }
        }
        throw new IllegalArgumentException("Invalid string encoding");
    }

    private byte[] getBytes() {
        byte[] bytes = new byte[this.getVarint()];
        this.buf.get(bytes);
        return bytes;
    }

    public static class StackTrace {
        public final long[] methods;
        public final byte[] types;
        public long samples;

        public StackTrace(long[] methods, byte[] types) {
            this.methods = methods;
            this.types = types;
        }
    }

    public static class Sample
    implements Comparable<Sample> {
        public final long time;
        public final int tid;
        public final int stackTraceId;
        public final int threadState;

        public Sample(long time, int tid, int stackTraceId, int threadState) {
            this.time = time;
            this.tid = tid;
            this.stackTraceId = stackTraceId;
            this.threadState = threadState;
        }

        @Override
        public int compareTo(Sample o) {
            return Long.compare(this.time, o.time);
        }
    }

    public static class MethodRef {
        public final long cls;
        public final long name;
        public final long sig;

        public MethodRef(long cls, long name, long sig) {
            this.cls = cls;
            this.name = name;
            this.sig = sig;
        }
    }

    static class JfrField
    extends Element {
        final String name;
        final int type;
        final boolean constantPool;

        JfrField(Map<String, String> attributes) {
            this.name = attributes.get("name");
            this.type = Integer.parseInt(attributes.get("class"));
            this.constantPool = "true".equals(attributes.get("constantPool"));
        }
    }

    static class JfrClass
    extends Element {
        final int id;
        final String name;
        final List<JfrField> fields;

        JfrClass(Map<String, String> attributes) {
            this.id = Integer.parseInt(attributes.get("id"));
            this.name = attributes.get("name");
            this.fields = new ArrayList<JfrField>(2);
        }

        @Override
        void addChild(Element e) {
            if (e instanceof JfrField) {
                this.fields.add((JfrField)e);
            }
        }

        JfrField field(String name) {
            for (JfrField field : this.fields) {
                if (!field.name.equals(name)) continue;
                return field;
            }
            return null;
        }
    }

    static class Element {
        Element() {
        }

        void addChild(Element e) {
        }
    }

    public static class ClassRef {
        public final long name;

        public ClassRef(long name) {
            this.name = name;
        }
    }
}

