/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel;

import com.legacy.structure_gel.StructureGelConfig;
import com.legacy.structure_gel.StructureGelMod;
import com.legacy.structure_gel.biome_dictionary.BiomeDictionary;
import com.legacy.structure_gel.biome_dictionary.BiomeType;
import com.legacy.structure_gel.commands.StructureGelCommand;
import com.legacy.structure_gel.packets.PacketHandler;
import com.legacy.structure_gel.packets.UpdateGelPlayerPacket;
import com.legacy.structure_gel.util.GelCollectors;
import com.legacy.structure_gel.util.Internal;
import com.legacy.structure_gel.util.RegistryHelper;
import com.legacy.structure_gel.util.capability.GelCapability;
import com.legacy.structure_gel.util.capability.GelEntityProvider;
import com.legacy.structure_gel.util.capability.IGelEntity;
import com.legacy.structure_gel.worldgen.structure.GelStructure;
import com.legacy.structure_gel.worldgen.structure.IConfigStructure;
import com.mojang.brigadier.CommandDispatcher;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryBuilder;

@Internal
public class SGEvents {
    protected static void init(IEventBus modBus, IEventBus forgeBus) {
        modBus.addListener(SGEvents::commonInit);
        modBus.addListener(SGEvents::loadComplete);
        modBus.addListener(SGEvents::createRegistries);
        forgeBus.addListener(SGEvents::registerCommands);
        forgeBus.addListener(SGEvents::onEntityJoinWorld);
        forgeBus.addListener(SGEvents::loadWorld);
        forgeBus.addGenericListener(Entity.class, SGEvents::attachCapabilities);
    }

    protected static void commonInit(FMLCommonSetupEvent event) {
        GelCapability.register();
        PacketHandler.register();
    }

    protected static void loadComplete(FMLLoadCompleteEvent event) {
        try {
            if (StructureGelConfig.COMMON.shouldGuessBiomeDict()) {
                StructureGelMod.LOGGER.info("Attempting to register unregistered biomes to the biome dictionary. This can be disabled via config.");
                BiomeDictionary.makeGuess().forEach((name, types) -> StructureGelMod.LOGGER.info(String.format("Registered %s to %s:[%s]", name, "structure_gel", String.join((CharSequence)", ", types.stream().filter(BiomeDictionary::filterTypeForAutoRegister).map(bt -> bt.getRegistryName().func_110623_a()).sorted().collect(Collectors.toSet())))));
            }
        }
        catch (Throwable e) {
            StructureGelMod.LOGGER.error("Encountered an issue while making assumptions for the biome dictionary. Please narrow down which mods cause a conflict here and report it to our issue tracker: https://gitlab.com/modding-legacy/structure-gel-api/-/issues");
            e.printStackTrace();
        }
        ForgeRegistries.STRUCTURE_FEATURES.forEach(structure -> {
            if (structure instanceof IConfigStructure) {
                StructureGelMod.LOGGER.info(String.format("Reloading biome config for %s", structure.getRegistryName().toString()));
                ((IConfigStructure)structure).getConfig().reloadBiomes();
            }
        });
        RegistryHelper.STRUCTURE_SETTINGS_MAP.forEach((structure, separation) -> {
            if (structure instanceof GelStructure && ((GelStructure)((Object)structure)).getValidDimensions() != null) {
                ((GelStructure)((Object)structure)).getValidDimensions().forEach(dimName -> WorldGenRegistries.field_243658_j.func_241873_b(dimName).ifPresent(noiseSettings -> SGEvents.registerStructureSettings(noiseSettings.func_236108_a_(), structure, separation)));
            } else {
                WorldGenRegistries.field_243658_j.forEach(noiseSettings -> SGEvents.registerStructureSettings(noiseSettings.func_236108_a_(), structure, separation));
            }
        });
    }

    protected static void loadWorld(WorldEvent.Load event) {
        if (event.getWorld() instanceof ServerWorld) {
            ServerWorld world = (ServerWorld)event.getWorld();
            ChunkGenerator chunkGen = world.func_72863_F().func_201711_g();
            DimensionStructuresSettings settings = chunkGen.func_235957_b_();
            RegistryHelper.STRUCTURE_SETTINGS_MAP.forEach((structure, separation) -> {
                if (structure instanceof GelStructure) {
                    Set<ResourceLocation> dims = ((GelStructure)((Object)structure)).getValidDimensions();
                    if (dims == null || dims.contains(world.func_234923_W_().func_240901_a_())) {
                        SGEvents.registerStructureSettings(settings, structure, separation);
                    }
                } else {
                    SGEvents.registerStructureSettings(settings, structure, separation);
                }
            });
            if (chunkGen instanceof FlatChunkGenerator) {
                DimensionStructuresSettings flatSettings = ((FlatChunkGenerator)chunkGen).func_236073_g_().func_236943_d_();
                RegistryHelper.STRUCTURE_SETTINGS_MAP.forEach((structure, separation) -> SGEvents.registerStructureSettings(flatSettings, structure, separation));
            }
        }
    }

    private static void registerStructureSettings(DimensionStructuresSettings structureSettings, Structure<?> structure, StructureSeparationSettings separation) {
        if (!structureSettings.field_236193_d_.keySet().stream().anyMatch(s -> structure.getRegistryName().equals((Object)s.getRegistryName()))) {
            structureSettings.field_236193_d_ = GelCollectors.addToMap(structureSettings.field_236193_d_, structure, separation);
        }
    }

    protected static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getEntity();
            GelCapability.ifPresent(player, gelPlayer -> PacketHandler.sendToClient(new UpdateGelPlayerPacket((IGelEntity)gelPlayer), player));
        }
    }

    protected static void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        GelEntityProvider provider = new GelEntityProvider();
        event.addCapability(StructureGelMod.locate("gel_entity"), (ICapabilityProvider)provider);
        event.addListener(provider::invalidate);
    }

    protected static void createRegistries(RegistryEvent.NewRegistry event) {
        new RegistryBuilder().setName(StructureGelMod.locate("biome_dictionary")).setType(BiomeType.class).setDefaultKey(StructureGelMod.locate("empty")).create();
    }

    protected static void registerCommands(RegisterCommandsEvent event) {
        StructureGelCommand.register((CommandDispatcher<CommandSource>)event.getDispatcher());
    }
}

