/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.access_helpers;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.Consumer;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.util.WeightedSpawnerEntity;

public class SpawnerAccessHelper {
    public static void setMinSpawnDelay(MobSpawnerTileEntity tile, int minSpawnelay) {
        SpawnerAccessHelper.modifySpawnerNBT(tile, nbt -> nbt.func_74777_a("MinSpawnDelay", (short)minSpawnelay));
    }

    public static void setMaxSpawnDelay(MobSpawnerTileEntity tile, int maxSpawnDelay) {
        SpawnerAccessHelper.modifySpawnerNBT(tile, nbt -> nbt.func_74777_a("MaxSpawnDelay", (short)maxSpawnDelay));
    }

    public static void setSpawnCount(MobSpawnerTileEntity tile, int spawnCount) {
        SpawnerAccessHelper.modifySpawnerNBT(tile, nbt -> nbt.func_74777_a("SpawnCount", (short)spawnCount));
    }

    public static void setMaxNearbyEntities(MobSpawnerTileEntity tile, int maxNearbyEntities) {
        SpawnerAccessHelper.modifySpawnerNBT(tile, nbt -> nbt.func_74777_a("MaxNearbyEntities", (short)maxNearbyEntities));
    }

    public static void setRequiredPlayerRange(MobSpawnerTileEntity tile, int requiredPlayerRange) {
        SpawnerAccessHelper.modifySpawnerNBT(tile, nbt -> nbt.func_74777_a("RequiredPlayerRange", (short)requiredPlayerRange));
    }

    public static void setSpawnRange(MobSpawnerTileEntity tile, int spawnRange) {
        SpawnerAccessHelper.modifySpawnerNBT(tile, nbt -> nbt.func_74777_a("SpawnRange", (short)spawnRange));
    }

    public static void setSpawnPotentials(MobSpawnerTileEntity tile, EntityType<?> entityType) {
        SpawnerAccessHelper.setSpawnPotentials(tile, SpawnerAccessHelper.createSpawnerEntity(entityType));
    }

    public static void setSpawnPotentials(MobSpawnerTileEntity tile, WeightedSpawnerEntity ... spawnerEntities) {
        SpawnerAccessHelper.setSpawnPotentials(tile, Arrays.asList(spawnerEntities));
    }

    public static void setSpawnPotentials(MobSpawnerTileEntity tile, Collection<WeightedSpawnerEntity> spawnerEntities) {
        SpawnerAccessHelper.modifySpawnerNBT(tile, nbt -> {
            if (!spawnerEntities.isEmpty()) {
                nbt.func_218657_a("SpawnData", (INBT)((WeightedSpawnerEntity)spawnerEntities.stream().findAny().get()).func_185277_b());
                ListNBT listNbt = new ListNBT();
                spawnerEntities.forEach(wse -> listNbt.add((Object)wse.func_185278_a()));
                nbt.func_218657_a("SpawnPotentials", (INBT)listNbt);
            }
        });
    }

    public static WeightedSpawnerEntity createSpawnerEntity(EntityType<?> entity) {
        return SpawnerAccessHelper.createSpawnerEntity(1, entity);
    }

    public static WeightedSpawnerEntity createSpawnerEntity(int weight, EntityType<?> entity) {
        return SpawnerAccessHelper.createSpawnerEntity(weight, entity, new CompoundNBT());
    }

    public static WeightedSpawnerEntity createSpawnerEntity(int weight, EntityType<?> entity, CompoundNBT entityNBT) {
        CompoundNBT nbt = new CompoundNBT();
        entityNBT.func_74778_a("id", entity.getRegistryName().toString());
        nbt.func_218657_a("Entity", (INBT)entityNBT);
        return new WeightedSpawnerEntity(weight, entityNBT);
    }

    public static void modifySpawnerNBT(MobSpawnerTileEntity tile, Consumer<CompoundNBT> nbtConsumer) {
        CompoundNBT nbt = new CompoundNBT();
        tile.func_145881_a().func_189530_b(nbt);
        nbtConsumer.accept(nbt);
        tile.func_145881_a().func_98270_a(nbt);
    }
}

