/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.worldgen.structure;

import com.google.common.collect.ImmutableList;
import com.legacy.structure_gel.StructureGelMod;
import com.legacy.structure_gel.access_helpers.StructureAccessHelper;
import com.legacy.structure_gel.util.Internal;
import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.StructureSpawnListGatherEvent;

public abstract class GelStructure<C extends IFeatureConfig>
extends Structure<C> {
    public final Map<EntityClassification, List<MobSpawnInfo.Spawners>> spawns = new HashMap<EntityClassification, List<MobSpawnInfo.Spawners>>();
    public boolean insideSpawnsOnly = true;
    public Integer seed = null;
    public Set<ResourceLocation> dimensions = null;

    public GelStructure(Codec<C> codec) {
        super(codec);
        MinecraftForge.EVENT_BUS.addListener(this::potentialSpawnsEvent);
        this.setLakeProof(true);
    }

    public GelStructure<C> setLakeProof(boolean lakeProof) {
        if (lakeProof) {
            StructureAccessHelper.addLakeProofStructure(this);
        } else {
            StructureAccessHelper.removeLakeProofStructure(this);
        }
        return this;
    }

    public GelStructure<C> setSpawnList(EntityClassification classification, List<MobSpawnInfo.Spawners> spawns) {
        this.spawns.put(classification, spawns);
        return this;
    }

    @Deprecated
    public List<DimensionSettings> getNoiseSettingsToGenerateIn() {
        return (List)WorldGenRegistries.field_243658_j.func_239659_c_().stream().map(Map.Entry::getValue).collect(ImmutableList.toImmutableList());
    }

    @Nullable
    public Set<ResourceLocation> getValidDimensions() {
        return this.dimensions;
    }

    public boolean isAllowedNearWorldSpawn() {
        return false;
    }

    public GenerationStage.Decoration func_236396_f_() {
        return GenerationStage.Decoration.SURFACE_STRUCTURES;
    }

    @Internal
    public ChunkPos func_236392_a_(@Nullable StructureSeparationSettings settings, long seed, SharedSeedRandom rand, int chunkX, int chunkZ) {
        int spacing = this.getSpacing();
        int gridX = (int)Math.floor((float)chunkX / (float)spacing) * spacing;
        int gridZ = (int)Math.floor((float)chunkZ / (float)spacing) * spacing;
        int offset = this.getOffset() + 1;
        rand.func_202427_a(seed, gridX, gridZ, this.getSeed());
        return new ChunkPos(gridX + rand.nextInt(offset), gridZ + rand.nextInt(offset));
    }

    @Internal
    protected boolean func_230363_a_(ChunkGenerator chunkGen, BiomeProvider biomeProvider, long seed, SharedSeedRandom sharedSeedRand, int chunkPosX, int chunkPosZ, Biome biomeIn, ChunkPos chunkPos, C config) {
        double probability;
        if (!this.isAllowedNearWorldSpawn()) {
            int x = chunkPos.field_77276_a;
            int z = chunkPos.field_77275_b;
            int range = 12;
            if (x < range && x > -range && z < range && z > -range) {
                return false;
            }
        }
        if ((probability = this.getProbability()) == 1.0) {
            return true;
        }
        sharedSeedRand.func_202427_a(seed, chunkPosX, chunkPosZ, this.getSeed());
        return sharedSeedRand.nextDouble() < this.getProbability();
    }

    @Internal
    public BlockPos func_236388_a_(IWorldReader worldIn, StructureManager structureManager, BlockPos startPos, int searchRadius, boolean skipExistingChunks, long seed, @Nullable StructureSeparationSettings settings) {
        if (this.getProbability() == 0.0) {
            return null;
        }
        return super.func_236388_a_(worldIn, structureManager, startPos, searchRadius, skipExistingChunks, seed, this.getSeparationSettings());
    }

    public int getSeed() {
        if (this.seed == null) {
            if (this.getRegistryName() == null) {
                this.seed = Math.abs(((Object)((Object)this)).getClass().getCanonicalName().hashCode());
                StructureGelMod.LOGGER.warn("The structure {} does not have a registry name. Seed defaulted to {}. This should be avoided.", (Object)((Object)((Object)this)).getClass().getName(), (Object)this.seed);
            } else {
                this.seed = Math.abs(this.getRegistryName().toString().hashCode());
            }
        }
        return this.seed;
    }

    public abstract double getProbability();

    public abstract int getSpacing();

    public abstract int getOffset();

    public String func_143025_a() {
        return this.getRegistryName().toString();
    }

    @Nullable
    @Deprecated
    public List<MobSpawnInfo.Spawners> func_202279_e() {
        return this.spawns.get(EntityClassification.MONSTER);
    }

    @Nullable
    @Deprecated
    public List<MobSpawnInfo.Spawners> func_214469_f() {
        return this.spawns.get(EntityClassification.CREATURE);
    }

    @Nullable
    public List<MobSpawnInfo.Spawners> getSpawns(EntityClassification classification) {
        return this.spawns.get(classification);
    }

    @Internal
    public void potentialSpawnsEvent(StructureSpawnListGatherEvent event) {
        if (event.getStructure() == this) {
            event.setInsideOnly(this.insideSpawnsOnly);
            for (EntityClassification classification : EntityClassification.values()) {
                if (this.getSpawns(classification) == null) continue;
                event.addEntitySpawns(classification, this.getSpawns(classification));
            }
        }
    }

    @Internal
    public StructureSeparationSettings getSeparationSettings() {
        return new StructureSeparationSettings(this.getSpacing(), this.getOffset(), this.getSeed());
    }
}

