/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.phosphor.mixin.chunk.light;

import me.jellysquid.mods.phosphor.common.chunk.level.LevelPropagatorExtended;
import me.jellysquid.mods.phosphor.common.chunk.light.LightProviderBlockAccess;
import me.jellysquid.mods.phosphor.common.chunk.light.LightStorageAccess;
import me.jellysquid.mods.phosphor.common.util.LightUtil;
import me.jellysquid.mods.phosphor.common.util.math.ChunkSectionPosHelper;
import me.jellysquid.mods.phosphor.common.util.math.DirectionHelper;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.LightType;
import net.minecraft.world.chunk.IChunkLightProvider;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.lighting.LightEngine;
import net.minecraft.world.lighting.SectionLightStorage;
import net.minecraft.world.lighting.SkyLightEngine;
import net.minecraft.world.lighting.SkyLightStorage;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={SkyLightEngine.class})
public abstract class MixinChunkSkyLightProvider
extends LightEngine<SkyLightStorage.StorageMap, SkyLightStorage>
implements LevelPropagatorExtended,
LightProviderBlockAccess {
    private static final BlockState AIR_BLOCK = Blocks.field_150350_a.func_176223_P();
    @Shadow
    @Final
    private static Direction[] field_215634_e;
    @Shadow
    @Final
    private static Direction[] field_215633_d;
    private int counterBranchA;
    private int counterBranchB;
    private int counterBranchC;

    public MixinChunkSkyLightProvider(IChunkLightProvider chunkProvider, LightType type, SkyLightStorage lightStorage) {
        super(chunkProvider, type, (SectionLightStorage)lightStorage);
    }

    @Overwrite
    public int func_215480_b(long fromId, long toId, int currentLevel) {
        return this.getPropagatedLevel(fromId, null, toId, currentLevel);
    }

    @Override
    public int getPropagatedLevel(long fromId, BlockState fromState, long toId, int currentLevel) {
        VoxelShape fromShape;
        VoxelShape toShape;
        int toZ;
        int toY;
        if (toId == Long.MAX_VALUE) {
            return 15;
        }
        if (fromId == Long.MAX_VALUE) {
            return 15;
        }
        if (currentLevel >= 15) {
            return currentLevel;
        }
        int toX = BlockPos.func_218290_b((long)toId);
        BlockState toState = this.getBlockStateForLighting(toX, toY = BlockPos.func_218274_c((long)toId), toZ = BlockPos.func_218282_d((long)toId));
        if (toState == null) {
            return 15;
        }
        int fromX = BlockPos.func_218290_b((long)fromId);
        int fromY = BlockPos.func_218274_c((long)fromId);
        int fromZ = BlockPos.func_218282_d((long)fromId);
        if (fromState == null) {
            fromState = this.getBlockStateForLighting(fromX, fromY, fromZ);
        }
        boolean airPropagation = toState == AIR_BLOCK && fromState == AIR_BLOCK;
        boolean verticalOnly = fromX == toX && fromZ == toZ;
        Direction dir = DirectionHelper.getVecDirection(toX - fromX, toY - fromY, toZ - fromZ);
        if (dir == null) {
            return 15;
        }
        if (!airPropagation && (toShape = this.getOpaqueShape(toState, toX, toY, toZ, dir.func_176734_d())) != VoxelShapes.func_197868_b() && LightUtil.unionCoversFullCube(fromShape = this.getOpaqueShape(fromState, fromX, fromY, fromZ, dir), toShape)) {
            return 15;
        }
        int out = this.getSubtractedLight(toState, toX, toY, toZ);
        if (out == 0 && currentLevel == 0 && verticalOnly && fromY > toY) {
            return 0;
        }
        return currentLevel + Math.max(1, out);
    }

    @Overwrite
    public void func_215478_a(long id, int targetLevel, boolean mergeAsMin) {
        int aboveY;
        int aboveChunkY;
        int belowY;
        int belowChunkY;
        long chunkId = SectionPos.func_218162_e((long)id);
        int x = BlockPos.func_218290_b((long)id);
        int y = BlockPos.func_218274_c((long)id);
        int z = BlockPos.func_218282_d((long)id);
        int localX = SectionPos.func_218171_b((int)x);
        int localY = SectionPos.func_218171_b((int)y);
        int localZ = SectionPos.func_218171_b((int)z);
        BlockState fromState = this.getBlockStateForLighting(x, y, z);
        if (localX > 0 && localX < 15 && localY > 0 && localY < 15 && localZ > 0 && localZ < 15) {
            for (Direction dir : field_215633_d) {
                this.propagateLevel(id, fromState, BlockPos.func_218276_a((int)(x + dir.func_82601_c()), (int)(y + dir.func_96559_d()), (int)(z + dir.func_82599_e())), targetLevel, mergeAsMin);
            }
            return;
        }
        int chunkY = SectionPos.func_218159_a((int)y);
        int chunkOffsetY = 0;
        if (localY == 0) {
            while (!((SkyLightStorage)this.field_215627_c).func_215518_g(SectionPos.func_218174_a((long)chunkId, (int)0, (int)(-chunkOffsetY - 1), (int)0)) && ((SkyLightStorage)this.field_215627_c).func_215550_a(chunkY - chunkOffsetY - 1)) {
                ++chunkOffsetY;
            }
        }
        if (chunkY == (belowChunkY = SectionPos.func_218159_a((int)(belowY = y + (-1 - chunkOffsetY * 16)))) || ((SkyLightStorage)this.field_215627_c).func_215518_g(ChunkSectionPosHelper.updateYLong(chunkId, belowChunkY))) {
            BlockState state = chunkY == belowChunkY ? fromState : AIR_BLOCK;
            this.propagateLevel(BlockPos.func_218276_a((int)x, (int)(belowY + 1), (int)z), state, BlockPos.func_218276_a((int)x, (int)belowY, (int)z), targetLevel, mergeAsMin);
        }
        if (chunkY == (aboveChunkY = SectionPos.func_218159_a((int)(aboveY = y + 1))) || ((SkyLightStorage)this.field_215627_c).func_215518_g(ChunkSectionPosHelper.updateYLong(chunkId, aboveChunkY))) {
            this.propagateLevel(id, fromState, BlockPos.func_218276_a((int)x, (int)aboveY, (int)z), targetLevel, mergeAsMin);
        }
        for (Direction dir : field_215634_e) {
            boolean isWithinOriginChunk;
            int adjZ;
            int adjX = x + dir.func_82601_c();
            long offsetId = BlockPos.func_218276_a((int)adjX, (int)y, (int)(adjZ = z + dir.func_82599_e()));
            long offsetChunkId = SectionPos.func_218162_e((long)offsetId);
            boolean bl = isWithinOriginChunk = chunkId == offsetChunkId;
            if (isWithinOriginChunk || ((SkyLightStorage)this.field_215627_c).func_215518_g(offsetChunkId)) {
                this.propagateLevel(id, fromState, offsetId, targetLevel, mergeAsMin);
            }
            if (isWithinOriginChunk) continue;
            for (int offsetChunkY = chunkY - 1; offsetChunkY > belowChunkY; --offsetChunkY) {
                if (!((SkyLightStorage)this.field_215627_c).func_215518_g(ChunkSectionPosHelper.updateYLong(offsetChunkId, offsetChunkY))) continue;
                for (int offsetY = 15; offsetY >= 0; --offsetY) {
                    int adjY = SectionPos.func_218142_c((int)offsetChunkY) + offsetY;
                    offsetId = BlockPos.func_218276_a((int)adjX, (int)adjY, (int)adjZ);
                    this.propagateLevel(BlockPos.func_218276_a((int)x, (int)adjY, (int)z), AIR_BLOCK, offsetId, targetLevel, mergeAsMin);
                }
            }
        }
    }

    @Unique
    private int getLightWithoutLightmap(long blockPos) {
        return 15 - ((LightStorageAccess)this.field_215627_c).getLightWithoutLightmap(blockPos);
    }

    @Overwrite
    public int func_215477_a(long id, long excludedId, int maxLevel) {
        int currentLevel = maxLevel;
        long chunkId = SectionPos.func_218162_e((long)id);
        NibbleArray lightmap = ((LightStorageAccess)this.field_215627_c).callGetLightSection(chunkId, true);
        for (Direction direction : field_215633_d) {
            long adjId = BlockPos.func_218289_a((long)id, (Direction)direction);
            if (adjId == excludedId) continue;
            long adjChunkId = SectionPos.func_218162_e((long)adjId);
            NibbleArray adjLightmap = chunkId == adjChunkId ? lightmap : ((LightStorageAccess)this.field_215627_c).callGetLightSection(adjChunkId, true);
            int adjLevel = adjLightmap == null ? this.getLightWithoutLightmap(adjId) : this.func_215622_a(adjLightmap, adjId);
            int propagatedLevel = this.func_215480_b(adjId, id, adjLevel);
            if (currentLevel > propagatedLevel) {
                currentLevel = propagatedLevel;
            }
            if (currentLevel != 0) continue;
            return currentLevel;
        }
        return currentLevel;
    }

    @Overwrite
    public void func_215473_f(long id) {
        super.func_215473_f(id);
    }
}

