/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers;

import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;

public class LOD {
    private final double distSq;
    public static final int BUFFER = 4;
    public static final int NEAR_DIST = 1024;
    public static final int NEAR_MED_DIST = 2304;
    public static final int MEDIUM_DIST = 4096;
    public static final int FAR_DIST = 9216;

    public LOD(double distance) {
        this.distSq = distance;
    }

    public LOD(TileEntityRendererDispatcher renderer, BlockPos pos) {
        this(renderer.field_217666_g.func_216785_c(), pos);
    }

    public LOD(Vector3d cameraPos, BlockPos pos) {
        this(Vector3d.func_237489_a_((Vector3i)pos).func_72436_e(cameraPos));
    }

    public boolean isOnEdge(TileEntity te) {
        return this.distSq > te.func_145833_n() * te.func_145833_n() - 4.0;
    }

    public boolean isNear() {
        return this.distSq < 1024.0;
    }

    public boolean isNearMed() {
        return this.distSq < 2304.0;
    }

    public boolean isMedium() {
        return this.distSq < 4096.0;
    }

    public boolean isFar() {
        return this.distSq < 9216.0;
    }

    public static boolean isOutOfFocus(Vector3d cameraPos, BlockPos pos, float blockYaw) {
        return LOD.isOutOfFocus(cameraPos, pos, blockYaw, 0.0f, Direction.UP, 0.0f);
    }

    public static boolean isOutOfFocus(Vector3d cameraPos, BlockPos pos, float blockYaw, float degMargin, Direction dir, float offset) {
        float relAngle = LOD.getRelativeAngle(cameraPos, pos, dir, offset);
        return LOD.isOutOfFocus(relAngle, blockYaw, degMargin);
    }

    public static boolean isOutOfFocus(float relativeAngle, float blockYaw, float degMargin) {
        return MathHelper.func_203302_c((float)relativeAngle, (float)(blockYaw - 90.0f)) > -degMargin;
    }

    public static float getRelativeAngle(Vector3d cameraPos, BlockPos pos) {
        return LOD.getRelativeAngle(cameraPos, pos, Direction.UP, 0.0f);
    }

    public static float getRelativeAngle(Vector3d cameraPos, BlockPos pos, Direction dir, float offset) {
        return (float)(MathHelper.func_181159_b((double)((double)(offset * (float)dir.func_82601_c()) + cameraPos.field_72450_a - (double)((float)pos.func_177958_n() + 0.5f)), (double)((double)(offset * (float)dir.func_82599_e()) + cameraPos.field_72449_c - (double)((float)pos.func_177952_p() + 0.5f))) * 180.0 / Math.PI);
    }
}

