/*
 * Decompiled with CFR 0.152.
 */
package azmalent.terraincognita;

import azmalent.cuneiform.lib.config.Category;
import azmalent.cuneiform.lib.config.CommonConfigFile;
import azmalent.cuneiform.lib.config.annotations.Comment;
import azmalent.cuneiform.lib.config.annotations.Name;
import azmalent.cuneiform.lib.config.options.BooleanOption;
import azmalent.cuneiform.lib.config.options.DoubleOption;
import azmalent.cuneiform.lib.config.options.IntOption;
import azmalent.cuneiform.lib.config.options.lazy.RegistryListOption;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.registries.ForgeRegistries;

public class TIConfig
extends CommonConfigFile {
    @Comment(value={"Worldgen features will not be added to the biomes listed here."})
    public static final RegistryListOption<Biome> biomeBlacklist = new RegistryListOption(ForgeRegistries.BIOMES, (List)Lists.newArrayList());

    protected TIConfig() {
        super("terraincognita");
    }

    public static void init() {
        new TIConfig().register();
    }

    public static class Integration
    extends Category {

        public static class Environmental
        extends Category {
            public static final BooleanOption delphiniumsInLushPlains = new BooleanOption(true);
        }

        public static class Quark
        extends Category {
            @Comment(value={"Chance to generate a marigold fairy ring in savanna biome chunk. Set to 0 to disable."})
            public static final DoubleOption savannaFairyRingChance = new DoubleOption(0.0025).inUnitRange();
        }
    }

    public static class Misc
    extends Category {
        @Name(value="Peat Enabled")
        @Comment(value={"Peat is a block found underwater in swamps similar to clay.", "It can be tilled and used to plant crops, which will grow faster than on regular farmland.", "One peat block can also be used as fuel to smelt 12 items."})
        public static final BooleanOption peat = new BooleanOption(true);
        public static final DoubleOption peatGrowthRateBonus = new DoubleOption(0.25).inUnitRange();
        @Name(value="Mossy Gravel Enabled")
        @Comment(value={"Mossy Gravel is found in swamps. It can also be crafted using gravel and vines/hanging moss."})
        public static final BooleanOption mossyGravel = new BooleanOption(true).withFlag("mossy_gravel");
        @Comment(value={"This tweak only applies if apple trees are enabled."})
        public static final BooleanOption disableAppleDropFromOaks = new BooleanOption(true).withFlag("remove_oak_apples");
        @Comment(value={"Adds height variation to cacti, sugarcane and reeds."})
        public static final BooleanOption plantHeightVariation = new BooleanOption(true);
        @Comment(value={"Adds composting recipes for dead bushes, bamboo, poisonous potatoes and chorus fruits/flowers."})
        public static final BooleanOption additionalCompostables = new BooleanOption(true);
        @Comment(value={"Allows growing lily pads by using bonemeal in shallow water pools."})
        public static final BooleanOption bonemealLilypadGrowing = new BooleanOption(true);
        @Comment(value={"Adds foxes, sheep, berry bushes, birches and shrubs to tundras to make them less lackluster."})
        public static final BooleanOption betterTundras = new BooleanOption(true);
        @Comment(value={"If enabled, wither roses will generate naturally in Soul Sand Valleys."})
        public static final BooleanOption witherRoseGeneration = new BooleanOption(true);
        public static final BooleanOption bannerPatterns = new BooleanOption(true).withFlag("banners");
    }

    public static class Tools
    extends Category {
        @Name(value="Basket Enabled")
        @Comment(value={"Basket is a portable container crafted from swamp reeds (or sugar cane if reeds are disabled). It can be placed or opened from inventory.", "Baskets have 9 slots and can only store forage such as flowers, saplings, mushrooms, seeds and eggs.", "When you have a basket in your hand, it will automatically collect compatible items."})
        public static final BooleanOption basket = new BooleanOption(true).withFlag("basket");
        @Name(value="Caltrops Enabled")
        @Comment(value={"Caltrops are metal spikes that can be placed on the ground. Dropped caltrops will also place themselves if possible.", "Caltrops deal one heart of damage and inflict slowness for 10 seconds when touched.", "You can right click caltrops with an empty hand to pick them up. They will also be flushed away by flowing water."})
        public static final BooleanOption caltrops = new BooleanOption(true).withFlag("caltrops");
        @Comment(value={"The chance for caltrops to break when dealing damage."})
        public static final DoubleOption caltropsBreakChance = new DoubleOption(0.125).inUnitRange();
        @Name(value="Blowpipe Enabled")
        public static final BooleanOption blowpipe = new BooleanOption(true).withFlag("blowpipe");
    }

    public static class Biomes
    extends Category {
        public static final IntOption lushPlainsWeight = new IntOption(1).nonNegative();
        public static final IntOption tundraWeight = new IntOption(5).nonNegative();
        public static final IntOption muskegWeight = new IntOption(3).nonNegative();
    }

    public static class Trees
    extends Category {
        @Name(value="Apple Trees Enabled")
        public static final BooleanOption apple = new BooleanOption(true).withFlag("apple");
        @Name(value="Hazel Trees Enabled")
        public static final BooleanOption hazel = new BooleanOption(true).withFlag("hazel");
    }

    public static class Fauna
    extends Category {
        public static final IntOption butterflySpawnWeight = new IntOption(10).inRange(0, 100);
    }

    public static class Flora
    extends Category {
        @Name(value="Dandelion Puff Enabled")
        @Comment(value={"Dandelion puffs spawn among vanilla dandelions. You can blow on a dandelion puff by using it."})
        public static final BooleanOption dandelionPuff = new BooleanOption(true).withFlag("dandelion_puff");
        @Name(value="Dandelion Puff Ratio")
        @Comment(value={"Chance to replace a vanilla dandelion with a dandelion puff during generation."})
        public static final DoubleOption dandelionPuffChance = new DoubleOption(0.5).inUnitRange();
        @Name(value="Field Flowers Enabled")
        @Comment(value={"Adds chicory, yarrow and daffodils to plains. Daffodils are rare, but they can also be found in flower forests."})
        public static final BooleanOption fieldFlowers = new BooleanOption(true).withFlag("field_flowers");
        @Name(value="Forest Flowers Enabled")
        @Comment(value={"Adds wild garlic, primroses and foxgloves to forests. These flowers can also be found in flower forests."})
        public static final BooleanOption forestFlowers = new BooleanOption(true).withFlag("forest_flowers");
        @Name(value="Swamp Flowers Enabled")
        @Comment(value={"Adds forget-me-not, globeflowers and water flags to temperate and hot swamps."})
        public static final BooleanOption swampFlowers = new BooleanOption(true).withFlag("swamp_flowers");
        @Name(value="Cattails Enabled")
        @Comment(value={"Adds cattails to swamps. Cattails can be duplicated using bonemeal and crafted into brown dye."})
        public static final BooleanOption cattails = new BooleanOption(true).withFlag("cattails");
        @Name(value="Small Lilypads Enabled")
        @Comment(value={"Small lilypads can be found in swamps. They can be stacked up to 4, like sea pickles."})
        public static final BooleanOption smallLilypad = new BooleanOption(true);
        @Name(value="Reeds Enabled")
        @Comment(value={"Reeds are a sugarcane-like plant that can be found in swamps. They can be grown in the same way as sugar cane, or, alternatively, in one block deep water.", "Reeds can be crafted into a variety of decorative wicker blocks and baskets."})
        public static final BooleanOption reeds = new BooleanOption(true).withFlag("reeds");
        @Name(value="Savanna Flowers Enabled")
        @Comment(value={"Adds marigolds, blue lupines, snapdragons, gladioluses, geraniums, oleanders and sage to savannas."})
        public static final BooleanOption savannaFlowers = new BooleanOption(true).withFlag("savanna_flowers");
        @Name(value="Jungle Flowers Enabled")
        @Comment(value={"Adds blue, black and purple irises to jungles."})
        public static final BooleanOption jungleFlowers = new BooleanOption(true).withFlag("jungle_flowers");
        @Name(value="Lotus Enabled")
        @Comment(value={"Lotus is a beautiful aquatic flower found in jungle lakes. It comes in yellow, pink and white colors."})
        public static final BooleanOption lotus = new BooleanOption(true).withFlag("lotus");
        @Name(value="Alpine Flowers Enabled")
        @Comment(value={"Adds edelweiss, alpine pink, saxifrage and gentian to temperate and cold mountain biomes.", "All of these flowers can grow on gravel, and saxifrage can grow on stone as well.", "Edelweiss has a minimum altitude requirement to generate."})
        public static final BooleanOption alpineFlowers = new BooleanOption(true).withFlag("alpine_flowers");
        @Name(value="Minimum Altitude for Edelweiss")
        @Comment(value={"Minimum Y level where edelweiss can generate in the mountains."})
        public static final IntOption edelweissMinimumY = new IntOption(90).inRange(64, 128);
        @Name(value="Arctic Flowers Enabled")
        @Comment(value={"Adds white dryads, fireweed, arctic poppies and white rhododendrons to taiga and tundra biomes."})
        public static final BooleanOption arcticFlowers = new BooleanOption(true).withFlag("arctic_flowers");
        @Name(value="Arctic Poppy Ratio")
        @Comment(value={"Chance to replace a vanilla poppy with an arctic poppy in tundra biomes."})
        public static final DoubleOption arcticPoppyChance = new DoubleOption(0.5).inUnitRange();
        @Name(value="Sweet Peas Enabled")
        @Comment(value={"Sweet peas are flowering vines found in flower forests. They come in seven different colors."})
        public static final BooleanOption sweetPeas = new BooleanOption(true).withFlag("sweet_peas");
        @Name(value="Wreaths Enabled")
        @Comment(value={"Wreath is a cosmetic headdress crafted with 4 small flowers of any kind in a 2x2 shape.", "The color of the wreath depends on the flowers you used to craft it."})
        public static final BooleanOption wreath = new BooleanOption(true).withFlag("wreath");
        @Name(value="Caribou Moss Enabled")
        @Comment(value={"Caribou moss is a grass-like plant found in tundras."})
        public static final BooleanOption caribouMoss = new BooleanOption(true);
        @Name(value="Sour Berries Enabled")
        @Comment(value={"Sour berries can be found growing on water in boreal swamps."})
        public static final BooleanOption sourBerries = new BooleanOption(true).withFlag("sour_berries");
        @Name(value="Roots Enabled")
        @Comment(value={"Roots can be found on dirt cave ceilings and overhangs in most biomes.", "They can be collected with shears. You can spread roots by using bonemeal on one.", "Roots can be crafted into brown dye or covered in clay and baked on a campfire. Baked roots grant 15 seconds of Haste when eaten."})
        public static final BooleanOption roots = new BooleanOption(true).withFlag("roots");
        @Name(value="Hanging Moss Enabled")
        public static final BooleanOption hangingMoss = new BooleanOption(true).withFlag("hanging_moss");
        @Name(value="Cactus Flowers Enabled")
        public static final BooleanOption cactusFlowers = new BooleanOption(true).withFlag("cactus_flowers");
        @Name(value="Small Cacti Enabled")
        public static final BooleanOption smallCacti = new BooleanOption(true).withFlag("small_cacti");
    }

    public static class Food
    extends Category {
        @Name(value="Fern Fiddlehead Enabled")
        @Comment(value={"Fern fiddleheads can be found when breaking ferns. You can eat them raw or add them to suspicious stews.", "Duration of suspicious stew's effect is doubled when a fiddlehead is added during or after cooking.", "If the effect is negative, duration is halved instead."})
        public static final BooleanOption fiddlehead = new BooleanOption(true).withFlag("fiddlehead");
        public static final DoubleOption fiddleheadDropChance = new DoubleOption(0.2).inUnitRange();
        @Name(value="Taffy Enabled")
        @Comment(value={"Taffy is a food item that can only be found in dungeons. It restores some health, but also makes your mouth sticky, reducing eating speed with every taffy eaten."})
        public static final BooleanOption taffy = new BooleanOption(true);
        @Name(value="Taffy Healing Amount")
        @Comment(value={"How many half hearts are healed when eating a taffy."})
        public static final IntOption taffyHealing = new IntOption(3).inRange(0, 8);
        @Name(value="Enchanted Golden Carrot Enabled")
        @Comment(value={"Enchanted golden carrot grants 30 seconds of Regeneration II, 2 minutes of Absorption IV, 5 minutes of Speed II and 10 minutes of Night Vision when eaten.", "It can be found in dungeon loot with the same rarity as enchanted golden apples."})
        public static final BooleanOption notchCarrot = new BooleanOption(true);
        @Name(value="Extra Vanilla Foods")
        @Comment(value={"Adds kelp soup and sweet berry sorbet."})
        public static final BooleanOption kelpSoup = new BooleanOption(true).withFlag("vanilla_foods");
    }
}

