/*
 * Decompiled with CFR 0.152.
 */
package azmalent.terraincognita.common.block;

import azmalent.terraincognita.TIConfig;
import azmalent.terraincognita.common.data.ModBlockTags;
import azmalent.terraincognita.network.NetworkHandler;
import azmalent.terraincognita.network.message.s2c.S2CSpawnParticleMessage;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SugarCaneBlock;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.ToolType;

public class PeatBlock
extends Block {
    public PeatBlock() {
        super(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150346_d).func_200944_c());
    }

    @Nullable
    public ToolType getHarvestTool(BlockState state) {
        return ToolType.SHOVEL;
    }

    public void func_225542_b_(@Nonnull BlockState state, @Nonnull ServerWorld world, @Nonnull BlockPos pos, @Nonnull Random random) {
        super.func_225542_b_(state, world, pos, random);
        BlockPos plantPos = pos.func_177984_a();
        BlockState plant = world.func_180495_p(plantPos);
        if (plant.func_235714_a_(ModBlockTags.PEAT_MULTIBLOCK_PLANTS)) {
            while (world.func_180495_p(plantPos.func_177984_a()).func_235714_a_(ModBlockTags.PEAT_MULTIBLOCK_PLANTS)) {
                plantPos = plantPos.func_177984_a();
            }
            plant = world.func_180495_p(plantPos);
        }
        if ((plant.func_177230_c() instanceof IGrowable || plant.func_177230_c() instanceof SugarCaneBlock) && plant.func_204519_t() && random.nextDouble() < TIConfig.Misc.peatGrowthRateBonus.get()) {
            BlockPos up = plantPos.func_177984_a();
            BlockState above = world.func_180495_p(up);
            plant.func_227034_b_(world, plantPos, random);
            if (plant.func_235714_a_(ModBlockTags.PEAT_MULTIBLOCK_PLANTS)) {
                if (world.func_180495_p(up) != above) {
                    PeatBlock.makeParticles(up, random);
                }
            } else if (world.func_180495_p(plantPos) != plant) {
                PeatBlock.makeParticles(up, random);
            }
        }
    }

    public boolean canSustainPlant(@Nonnull BlockState state, @Nonnull IBlockReader world, BlockPos pos, @Nonnull Direction facing, IPlantable plant) {
        return Blocks.field_150346_d.canSustainPlant(Blocks.field_150346_d.func_176223_P(), world, pos, facing, plant);
    }

    public static void makeParticles(BlockPos pos, Random random) {
        for (int i = 0; i < 8; ++i) {
            double x = (double)pos.func_177958_n() + random.nextDouble();
            double y = (double)pos.func_177956_o() + random.nextDouble();
            double z = (double)pos.func_177952_p() + random.nextDouble();
            double xSpeed = random.nextGaussian() * 0.02;
            double ySpeed = random.nextGaussian() * 0.02;
            double zSpeed = random.nextGaussian() * 0.02;
            S2CSpawnParticleMessage message = new S2CSpawnParticleMessage(ParticleTypes.field_197632_y, x, y, z, xSpeed, ySpeed, zSpeed);
            NetworkHandler.sendToAllPlayers(message);
        }
    }
}

