/*
 * Decompiled with CFR 0.152.
 */
package azmalent.terraincognita.common.block;

import azmalent.terraincognita.TIConfig;
import azmalent.terraincognita.common.block.PeatBlock;
import azmalent.terraincognita.common.registry.ModBlocks;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.entity.Entity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.FarmlandWaterManager;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;

public class PeatFarmlandBlock
extends FarmlandBlock {
    public PeatFarmlandBlock() {
        super(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150458_ak));
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return !this.func_176223_P().func_196955_c((IWorldReader)context.func_195991_k(), context.func_195995_a()) ? ModBlocks.PEAT.getBlock().func_176223_P() : this.func_176223_P();
    }

    public boolean canSustainPlant(@Nonnull BlockState state, @Nonnull IBlockReader world, BlockPos pos, @Nonnull Direction facing, IPlantable plant) {
        return plant.getPlantType(world, pos) == PlantType.CROP;
    }

    public void func_225534_a_(BlockState state, @Nonnull ServerWorld worldIn, @Nonnull BlockPos pos, Random rand) {
        if (!state.func_196955_c((IWorldReader)worldIn, pos)) {
            this.turnToPeat(state, (World)worldIn, pos);
        }
    }

    public void func_225542_b_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        BlockState crop;
        BlockPos up = pos.func_177984_a();
        int moisture = (Integer)state.func_177229_b((Property)field_176531_a);
        if (moisture > 0 && this.hasCrops((IBlockReader)world, pos) && (crop = world.func_180495_p(up)).func_204519_t() && random.nextDouble() < TIConfig.Misc.peatGrowthRateBonus.get()) {
            crop.func_227034_b_(world, up, random);
            if (world.func_180495_p(up) != crop) {
                PeatBlock.makeParticles(up, random);
            }
        }
        if (!this.hasWater((IWorldReader)world, pos) && !world.func_175727_C(up)) {
            if (moisture > 0) {
                world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)field_176531_a, (Comparable)Integer.valueOf(moisture - 1)), 2);
            } else if (!this.hasCrops((IBlockReader)world, pos)) {
                this.turnToPeat(state, (World)world, pos);
            }
        } else if (moisture < 7) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)field_176531_a, (Comparable)Integer.valueOf(7)), 2);
        }
    }

    public void func_180658_a(World worldIn, @Nonnull BlockPos pos, Entity entityIn, float fallDistance) {
        if (!worldIn.field_72995_K && worldIn.field_73012_v.nextBoolean() && ForgeHooks.onFarmlandTrample((World)worldIn, (BlockPos)pos, (BlockState)ModBlocks.PEAT.getDefaultState(), (float)fallDistance, (Entity)entityIn)) {
            this.turnToPeat(worldIn.func_180495_p(pos), worldIn, pos);
        }
        entityIn.func_225503_b_(fallDistance, 1.0f);
    }

    private boolean hasCrops(IBlockReader worldIn, BlockPos pos) {
        BlockState plant = worldIn.func_180495_p(pos.func_177984_a());
        BlockState state = worldIn.func_180495_p(pos);
        return plant.func_177230_c() instanceof IPlantable && state.canSustainPlant(worldIn, pos, Direction.UP, (IPlantable)plant.func_177230_c());
    }

    private boolean hasWater(IWorldReader worldIn, BlockPos pos) {
        for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-4, 0, -4), (BlockPos)pos.func_177982_a(4, 1, 4))) {
            if (!worldIn.func_204610_c(blockpos).func_206884_a((ITag)FluidTags.field_206959_a)) continue;
            return true;
        }
        return FarmlandWaterManager.hasBlockWaterTicket((IWorldReader)worldIn, (BlockPos)pos);
    }

    private void turnToPeat(BlockState state, World worldIn, BlockPos pos) {
        worldIn.func_175656_a(pos, PeatFarmlandBlock.func_199601_a((BlockState)state, (BlockState)ModBlocks.PEAT.getBlock().func_176223_P(), (World)worldIn, (BlockPos)pos));
    }
}

