/*
 * Decompiled with CFR 0.152.
 */
package azmalent.terraincognita.common.entity;

import azmalent.terraincognita.common.registry.ModEntities;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.FMLPlayMessages;

public class CactusNeedleEntity
extends ProjectileEntity {
    private double damage = 1.5;
    private int knockbackStrength;
    protected BlockState inBlockState;
    protected boolean inGround;
    protected int timeInGround;
    protected int ticksInGround;
    public int arrowShake;

    public CactusNeedleEntity(EntityType<? extends CactusNeedleEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public CactusNeedleEntity(double x, double y, double z, World worldIn) {
        this((EntityType<? extends CactusNeedleEntity>)((EntityType)ModEntities.CACTUS_NEEDLE.get()), worldIn);
        this.func_70107_b(x, y, z);
    }

    public CactusNeedleEntity(LivingEntity shooter, World worldIn) {
        this(shooter.func_226277_ct_(), shooter.func_226280_cw_() - (double)0.1f, shooter.func_226281_cx_(), worldIn);
        this.func_212361_a((Entity)shooter);
    }

    public CactusNeedleEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        this((EntityType<? extends CactusNeedleEntity>)((EntityType)ModEntities.CACTUS_NEEDLE.get()), world);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 = d0 * 64.0 * CactusNeedleEntity.func_184183_bd()) * d0;
    }

    protected void func_70088_a() {
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        super.func_70186_c(x, y, z, velocity, inaccuracy);
        this.ticksInGround = 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.func_70107_b(x, y, z);
        this.func_70101_b(yaw, pitch);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        super.func_70016_h(x, y, z);
        this.ticksInGround = 0;
    }

    public void func_70071_h_() {
        VoxelShape voxelshape;
        BlockPos blockpos;
        BlockState blockstate;
        super.func_70071_h_();
        Vector3d vector3d = this.func_213322_ci();
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)CactusNeedleEntity.func_213296_b((Vector3d)vector3d));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)vector3d.field_72450_a, (double)vector3d.field_72449_c) * 57.2957763671875);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)vector3d.field_72448_b, (double)f) * 57.2957763671875);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
        if (!(blockstate = this.field_70170_p.func_180495_p(blockpos = this.func_233580_cy_())).isAir((IBlockReader)this.field_70170_p, blockpos) && !(voxelshape = blockstate.func_196952_d((IBlockReader)this.field_70170_p, blockpos)).func_197766_b()) {
            Vector3d vector3d1 = this.func_213303_ch();
            for (AxisAlignedBB axisalignedbb : voxelshape.func_197756_d()) {
                if (!axisalignedbb.func_186670_a(blockpos).func_72318_a(vector3d1)) continue;
                this.inGround = true;
                break;
            }
        }
        if (this.arrowShake > 0) {
            --this.arrowShake;
        }
        if (this.func_70026_G()) {
            this.func_70066_B();
        }
        if (this.inGround) {
            if (this.inBlockState != blockstate && this.func_234593_u_()) {
                this.func_234594_z_();
            } else if (!this.field_70170_p.field_72995_K) {
                ++this.ticksInGround;
                if (this.ticksInGround >= 1200) {
                    this.func_70106_y();
                }
            }
            ++this.timeInGround;
        } else {
            Vector3d vector3d3;
            this.timeInGround = 0;
            Vector3d vector3d2 = this.func_213303_ch();
            BlockRayTraceResult hit = this.field_70170_p.func_217299_a(new RayTraceContext(vector3d2, vector3d3 = vector3d2.func_178787_e(vector3d), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this));
            if (hit.func_216346_c() != RayTraceResult.Type.MISS) {
                vector3d3 = hit.func_216347_e();
            }
            while (!this.field_70128_L) {
                EntityRayTraceResult entityHit = this.rayTraceEntities(vector3d2, vector3d3);
                if (entityHit != null) {
                    hit = entityHit;
                }
                if (hit != null && hit.func_216346_c() == RayTraceResult.Type.ENTITY) {
                    Entity entity = ((EntityRayTraceResult)hit).func_216348_a();
                    Entity entity1 = this.func_234616_v_();
                    if (entity instanceof PlayerEntity && entity1 instanceof PlayerEntity && !((PlayerEntity)entity1).func_96122_a((PlayerEntity)entity)) {
                        hit = null;
                    }
                }
                if (hit == null || hit.func_216346_c() == RayTraceResult.Type.MISS || ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)hit)) continue;
                this.func_70227_a((RayTraceResult)hit);
                this.field_70160_al = true;
            }
            vector3d = this.func_213322_ci();
            double d3 = vector3d.field_72450_a;
            double d4 = vector3d.field_72448_b;
            double d0 = vector3d.field_72449_c;
            double d5 = this.func_226277_ct_() + d3;
            double d1 = this.func_226278_cu_() + d4;
            double d2 = this.func_226281_cx_() + d0;
            float f1 = MathHelper.func_76133_a((double)CactusNeedleEntity.func_213296_b((Vector3d)vector3d));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)d3, (double)d0) * 57.2957763671875);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)d4, (double)f1) * 57.2957763671875);
            this.field_70177_z = CactusNeedleEntity.func_234614_e_((float)this.field_70126_B, (float)this.field_70177_z);
            this.field_70125_A = CactusNeedleEntity.func_234614_e_((float)this.field_70127_C, (float)this.field_70125_A);
            float f2 = 0.99f;
            if (this.func_70090_H()) {
                for (int j = 0; j < 4; ++j) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, d5 - d3 * 0.25, d1 - d4 * 0.25, d2 - d0 * 0.25, d3, d4, d0);
                }
                f2 = this.getWaterDrag();
            }
            this.func_213317_d(vector3d.func_186678_a((double)f2));
            if (!this.func_189652_ae()) {
                Vector3d motion = this.func_213322_ci();
                this.func_213293_j(motion.field_72450_a, motion.field_72448_b - (double)0.03f, motion.field_72449_c);
            }
            this.func_70107_b(d5, d1, d2);
            this.func_145775_I();
        }
    }

    private boolean func_234593_u_() {
        return this.inGround && this.field_70170_p.func_226664_a_(new AxisAlignedBB(this.func_213303_ch(), this.func_213303_ch()).func_186662_g(0.06));
    }

    private void func_234594_z_() {
        this.inGround = false;
        this.ticksInGround = 0;
        this.func_213317_d(this.func_213322_ci().func_216372_d((double)(this.field_70146_Z.nextFloat() * 0.2f), (double)(this.field_70146_Z.nextFloat() * 0.2f), (double)(this.field_70146_Z.nextFloat() * 0.2f)));
    }

    protected void func_230299_a_(BlockRayTraceResult hit) {
        this.inBlockState = this.field_70170_p.func_180495_p(hit.func_216350_a());
        super.func_230299_a_(hit);
        Vector3d vector3d = hit.func_216347_e().func_178786_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        this.func_213317_d(vector3d);
        Vector3d vector3d1 = vector3d.func_72432_b().func_186678_a((double)0.05f);
        this.func_226288_n_(this.func_226277_ct_() - vector3d1.field_72450_a, this.func_226278_cu_() - vector3d1.field_72448_b, this.func_226281_cx_() - vector3d1.field_72449_c);
        this.func_184185_a(SoundEvents.field_187731_t, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
        this.inGround = true;
        this.arrowShake = 7;
    }

    @Nullable
    protected EntityRayTraceResult rayTraceEntities(Vector3d startVec, Vector3d endVec) {
        return ProjectileHelper.func_221269_a((World)this.field_70170_p, (Entity)this, (Vector3d)startVec, (Vector3d)endVec, (AxisAlignedBB)this.func_174813_aQ().func_216361_a(this.func_213322_ci()).func_186662_g(1.0), arg_0 -> ((CactusNeedleEntity)this).func_230298_a_(arg_0));
    }

    public void func_213281_b(@Nonnull CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74777_a("life", (short)this.ticksInGround);
        if (this.inBlockState != null) {
            compound.func_218657_a("inBlockState", (INBT)NBTUtil.func_190009_a((BlockState)this.inBlockState));
        }
        compound.func_74774_a("shake", (byte)this.arrowShake);
        compound.func_74757_a("inGround", this.inGround);
        compound.func_74780_a("damage", this.damage);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.ticksInGround = compound.func_74765_d("life");
        if (compound.func_150297_b("inBlockState", 10)) {
            this.inBlockState = NBTUtil.func_190008_d((CompoundNBT)compound.func_74775_l("inBlockState"));
        }
        this.arrowShake = compound.func_74771_c("shake") & 0xFF;
        this.inGround = compound.func_74767_n("inGround");
        if (compound.func_150297_b("damage", 99)) {
            this.damage = compound.func_74769_h("damage");
        }
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public double getDamage() {
        return this.damage;
    }

    public void setDamage(double damageIn) {
        this.damage = damageIn;
    }

    public void setKnockbackStrength(int knockbackStrengthIn) {
        this.knockbackStrength = knockbackStrengthIn;
    }

    public boolean func_70075_an() {
        return false;
    }

    protected float func_213316_a(Pose poseIn, EntitySize sizeIn) {
        return 0.13f;
    }

    public void setEnchantmentEffectsFromEntity(LivingEntity living, float p_190547_2_) {
        int power = EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185309_u, (LivingEntity)living);
        int punch = EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185310_v, (LivingEntity)living);
        this.setDamage((double)(p_190547_2_ * 2.0f) + this.field_70146_Z.nextGaussian() * 0.25 + (double)((float)this.field_70170_p.func_175659_aa().func_151525_a() * 0.11f));
        if (power > 0) {
            this.setDamage(this.damage + (double)power * 0.5 + 0.5);
        }
        if (punch > 0) {
            this.setKnockbackStrength(punch);
        }
        if (EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185311_w, (LivingEntity)living) > 0) {
            this.func_70015_d(100);
        }
    }

    protected float getWaterDrag() {
        return 0.6f;
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return null;
    }
}

