/*
 * Decompiled with CFR 0.152.
 */
package azmalent.terraincognita.common.integration.quark.block;

import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ChainBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.LanternBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class TIWoodPostBlock
extends Block
implements IWaterLoggable {
    private static final VoxelShape SHAPE_X = Block.func_208617_a((double)0.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);
    private static final VoxelShape SHAPE_Y = Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape SHAPE_Z = Block.func_208617_a((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)16.0);
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.field_208148_A;
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final BooleanProperty[] CHAINED = new BooleanProperty[]{BooleanProperty.func_177716_a((String)"chain_down"), BooleanProperty.func_177716_a((String)"chain_up"), BooleanProperty.func_177716_a((String)"chain_north"), BooleanProperty.func_177716_a((String)"chain_south"), BooleanProperty.func_177716_a((String)"chain_west"), BooleanProperty.func_177716_a((String)"chain_east")};
    public Block strippedBlock = null;

    public TIWoodPostBlock(MaterialColor color) {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)color).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a));
        BlockState state = (BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a(AXIS, (Comparable)Direction.Axis.Y);
        for (BooleanProperty prop : CHAINED) {
            state = (BlockState)state.func_206870_a((Property)prop, (Comparable)Boolean.valueOf(false));
        }
        this.func_180632_j(state);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{WATERLOGGED, AXIS});
        for (BooleanProperty prop : CHAINED) {
            builder.func_206894_a(new Property[]{prop});
        }
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction.Axis)state.func_177229_b(AXIS)) {
            case X: {
                return SHAPE_X;
            }
            case Y: {
                return SHAPE_Y;
            }
        }
        return SHAPE_Z;
    }

    public BlockState getToolModifiedState(BlockState state, World world, BlockPos pos, PlayerEntity player, ItemStack stack, ToolType toolType) {
        if (this.strippedBlock == null || toolType != ToolType.AXE) {
            return super.getToolModifiedState(state, world, pos, player, stack, toolType);
        }
        BlockState newState = this.strippedBlock.func_176223_P();
        for (Property p : state.func_235904_r_()) {
            newState = (BlockState)newState.func_206870_a(p, state.func_177229_b(p));
        }
        return newState;
    }

    public boolean func_200123_i(BlockState state, @Nonnull IBlockReader reader, @Nonnull BlockPos pos) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) == false;
    }

    private BlockState getState(IWorld world, BlockPos pos, Direction.Axis axis) {
        BlockState state = (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.func_204610_c(pos).func_206886_c() == Fluids.field_204546_a))).func_206870_a(AXIS, (Comparable)axis);
        for (Direction d : Direction.values()) {
            BlockState sideState;
            if (d.func_176740_k() == axis || (!((sideState = world.func_180495_p(pos.func_177972_a(d))).func_177230_c() instanceof ChainBlock) || sideState.func_177229_b((Property)BlockStateProperties.field_208148_A) != d.func_176740_k()) && (d != Direction.DOWN || !(sideState.func_177230_c() instanceof LanternBlock) || !((Boolean)sideState.func_177229_b((Property)LanternBlock.field_220278_a)).booleanValue())) continue;
            BooleanProperty prop = CHAINED[d.ordinal()];
            state = (BlockState)state.func_206870_a((Property)prop, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return this.getState((IWorld)context.func_195991_k(), context.func_195995_a(), context.func_196000_l().func_176740_k());
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.func_220069_a(state, worldIn, pos, blockIn, fromPos, isMoving);
        BlockState newState = this.getState((IWorld)worldIn, pos, (Direction.Axis)state.func_177229_b(AXIS));
        if (!newState.equals(state)) {
            worldIn.func_175656_a(pos, newState);
        }
    }

    @Nonnull
    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : Fluids.field_204541_a.func_207188_f();
    }
}

