/*
 * Decompiled with CFR 0.152.
 */
package azmalent.terraincognita.common.inventory;

import azmalent.terraincognita.TerraIncognita;
import azmalent.terraincognita.common.inventory.BasketStackHandler;
import azmalent.terraincognita.common.registry.ModContainers;
import azmalent.terraincognita.common.tile.BasketTileEntity;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class BasketContainer
extends Container {
    public static final int WIDTH = 3;
    public static final int HEIGHT = 3;
    public static final int SIZE = 9;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_HEIGHT = 3;
    private static final int PLAYER_INVENTORY_WIDTH = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int SLOT_OFFSET = 18;
    private static final int PLAYER_INVENTORY_X = 8;
    private static final int PLAYER_INVENTORY_Y = 84;
    private static final int HOTBAR_Y = 142;
    private static final int BASKET_INVENTORY_X = 62;
    private static final int BASKET_INVENTORY_Y = 18;
    private final IUseContext useContext;

    public BasketContainer(int windowId, PlayerInventory playerInventory, BasketStackHandler stackHandler, ItemStack stack) {
        this(windowId, playerInventory, stackHandler, new IUseContext.Item(stack));
    }

    public BasketContainer(int windowId, PlayerInventory playerInventory, BasketStackHandler stackHandler, World world, BlockPos pos) {
        this(windowId, playerInventory, stackHandler, new IUseContext.Block(world, pos));
    }

    private BasketContainer(int windowId, PlayerInventory playerInventory, BasketStackHandler stackHandler, IUseContext useContext) {
        super((ContainerType)ModContainers.BASKET.get(), windowId);
        this.useContext = useContext;
        for (int i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)playerInventory, i, 8 + 18 * i, 142));
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                int slotIndex = 9 + y * 9 + x;
                int xpos = 8 + x * 18;
                int ypos = 84 + y * 18;
                this.func_75146_a(new Slot((IInventory)playerInventory, slotIndex, xpos, ypos));
            }
        }
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 3; ++col) {
                int x = 62 + col * 18;
                int y = 18 + row * 18;
                this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)stackHandler, row * 3 + col, x, y));
            }
        }
    }

    public static BasketContainer createOnClientSide(int windowId, PlayerInventory playerInventory, PacketBuffer buffer) {
        try {
            return new BasketContainer(windowId, playerInventory, new BasketStackHandler(), ItemStack.field_190927_a);
        }
        catch (IllegalArgumentException e) {
            TerraIncognita.LOGGER.warn((Object)e);
            return null;
        }
    }

    @Nonnull
    public ItemStack func_82846_b(PlayerEntity player, int index) {
        Slot sourceSlot = (Slot)this.field_75151_b.get(index);
        if (sourceSlot == null || !sourceSlot.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        ItemStack sourceStack = sourceSlot.func_75211_c();
        if (index < 36) {
            if (!this.func_75135_a(sourceStack, 36, 45, false)) {
                return ItemStack.field_190927_a;
            }
        } else if (index < 45) {
            if (!this.func_75135_a(sourceStack, 0, 36, false)) {
                return ItemStack.field_190927_a;
            }
        } else {
            TerraIncognita.LOGGER.warn("Invalid slot index:" + index);
            return ItemStack.field_190927_a;
        }
        if (sourceStack.func_190916_E() == 0) {
            sourceSlot.func_75215_d(ItemStack.field_190927_a);
        } else {
            sourceSlot.func_75218_e();
        }
        sourceSlot.func_190901_a(player, sourceStack);
        return sourceStack.func_77946_l();
    }

    public boolean func_75145_c(@Nonnull PlayerEntity player) {
        return this.useContext.canInteractWith(player);
    }

    private static interface IUseContext {
        public boolean canInteractWith(@Nonnull PlayerEntity var1);

        public static final class Item
        implements IUseContext {
            private final ItemStack heldStack;

            public Item(ItemStack heldStack) {
                this.heldStack = heldStack;
            }

            @Override
            public boolean canInteractWith(@Nonnull PlayerEntity player) {
                ItemStack main = player.func_184614_ca();
                ItemStack off = player.func_184592_cb();
                return !main.func_190926_b() && main == this.heldStack || !off.func_190926_b() && off == this.heldStack;
            }
        }

        public static final class Block
        implements IUseContext {
            private final World world;
            private final BlockPos pos;

            public Block(World world, BlockPos pos) {
                this.world = world;
                this.pos = pos;
            }

            @Override
            public boolean canInteractWith(@Nonnull PlayerEntity player) {
                TileEntity te = this.world.func_175625_s(this.pos);
                if (te instanceof BasketTileEntity) {
                    return player.func_70092_e((double)this.pos.func_177958_n() + 0.5, (double)this.pos.func_177956_o() + 0.5, (double)this.pos.func_177952_p() + 0.5) < 64.0;
                }
                return false;
            }
        }
    }
}

