/*
 * Decompiled with CFR 0.152.
 */
package azmalent.terraincognita.common.item;

import azmalent.terraincognita.common.entity.CactusNeedleEntity;
import azmalent.terraincognita.common.registry.ModItems;
import java.util.function.Predicate;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.enchantment.IVanishable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShootableItem;
import net.minecraft.item.UseAction;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

@MethodsReturnNonnullByDefault
public class BlowpipeItem
extends ShootableItem
implements IVanishable {
    private static final Predicate<ItemStack> AMMO_PREDICATE = stack -> stack.func_77973_b() == ModItems.CACTUS_NEEDLE.get();

    public BlowpipeItem() {
        super(new Item.Properties().func_200917_a(1).func_200918_c(64).func_200916_a(ItemGroup.field_78037_j));
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity living, int timeLeft) {
        if (living instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)living;
            boolean infiniteAmmo = player.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0;
            ItemStack ammo = player.func_213356_f(stack);
            int i = this.func_77626_a(stack) - timeLeft;
            if ((i = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)worldIn, (PlayerEntity)player, (int)i, (!ammo.func_190926_b() || infiniteAmmo ? 1 : 0) != 0)) < 0) {
                return;
            }
            if (!ammo.func_190926_b() || infiniteAmmo) {
                float velocity;
                if (ammo.func_190926_b()) {
                    ammo = new ItemStack((IItemProvider)ModItems.CACTUS_NEEDLE.get());
                }
                if (!((double)(velocity = BlowpipeItem.getArrowVelocity(i)) < 0.1)) {
                    if (!worldIn.field_72995_K) {
                        int knockback;
                        CactusNeedleEntity needle = new CactusNeedleEntity((LivingEntity)player, worldIn);
                        int power = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack);
                        if (power > 0) {
                            needle.setDamage(needle.getDamage() + (double)power * 0.5 + 0.5);
                        }
                        if ((knockback = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)stack)) > 0) {
                            needle.setKnockbackStrength(knockback);
                        }
                        if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)stack) > 0) {
                            needle.func_70015_d(100);
                        }
                        stack.func_222118_a(1, (LivingEntity)player, playerEntity -> playerEntity.func_213334_d(player.func_184600_cs()));
                        worldIn.func_217376_c((Entity)needle);
                    }
                    worldIn.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187737_v, SoundCategory.PLAYERS, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + velocity * 0.5f);
                    if (!infiniteAmmo) {
                        ammo.func_190918_g(1);
                        if (ammo.func_190926_b()) {
                            player.field_71071_by.func_184437_d(ammo);
                        }
                    }
                    player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
                }
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack;
        boolean hasAmmo = !player.func_213356_f(stack = player.func_184586_b(hand)).func_190926_b();
        ActionResult result = ForgeEventFactory.onArrowNock((ItemStack)stack, (World)world, (PlayerEntity)player, (Hand)hand, (boolean)hasAmmo);
        if (result != null) {
            return result;
        }
        if (!player.field_71075_bZ.field_75098_d && !hasAmmo) {
            return ActionResult.func_226251_d_((Object)stack);
        }
        player.func_184598_c(hand);
        return ActionResult.func_226249_b_((Object)stack);
    }

    public static float getArrowVelocity(int charge) {
        float f = (float)charge / 20.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.CROSSBOW;
    }

    public Predicate<ItemStack> func_220004_b() {
        return AMMO_PREDICATE;
    }

    public int func_230305_d_() {
        return 12;
    }
}

