/*
 * Decompiled with CFR 0.152.
 */
package azmalent.terraincognita.common.recipe;

import azmalent.terraincognita.common.registry.ModItems;
import azmalent.terraincognita.common.registry.ModRecipes;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.DyeItem;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class WreathRecipe
extends SpecialRecipe {
    public static final Map<Item, DyeItem> FLOWER_TO_DYE_MAP = Maps.newHashMap();
    private static final ItemStack DUMMY = new ItemStack((IItemProvider)ModItems.WREATH.get());

    public WreathRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(CraftingInventory inv, @Nonnull World worldIn) {
        int numFlowers = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_77973_b().func_206844_a((ITag)ItemTags.field_219770_E)) {
                ++numFlowers;
                continue;
            }
            if (stack.func_190926_b()) continue;
            return false;
        }
        if (numFlowers == 4) {
            for (int row = 0; row < inv.func_174923_h() - 1; ++row) {
                for (int col = 0; col < inv.func_174922_i() - 1; ++col) {
                    int i = row * inv.func_174922_i() + col;
                    if (inv.func_70301_a(i).func_190926_b()) continue;
                    return !inv.func_70301_a(i + 1).func_190926_b() && !inv.func_70301_a(i + inv.func_174922_i()).func_190926_b() && !inv.func_70301_a(i + inv.func_174922_i() + 1).func_190926_b();
                }
            }
        }
        return false;
    }

    @Nonnull
    public ItemStack getCraftingResult(CraftingInventory inv) {
        ArrayList<DyeItem> dyes = new ArrayList<DyeItem>();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i).func_190926_b()) continue;
            DyeItem dye = FLOWER_TO_DYE_MAP.getOrDefault(inv.func_70301_a(i).func_77973_b(), (DyeItem)Items.field_222069_lA);
            dyes.add(dye);
        }
        ItemStack output = new ItemStack((IItemProvider)ModItems.WREATH.get());
        return IDyeableArmorItem.func_219975_a((ItemStack)output, dyes);
    }

    public boolean func_194133_a(int width, int height) {
        return width >= 2 && height >= 2;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return DUMMY;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipes.WREATH.get();
    }
}

