/*
 * Decompiled with CFR 0.152.
 */
package azmalent.terraincognita.common.registry;

import azmalent.cuneiform.lib.registry.BlockEntry;
import azmalent.terraincognita.client.renderer.tile.ModChestRenderer;
import azmalent.terraincognita.client.renderer.tile.ModSignRenderer;
import azmalent.terraincognita.common.registry.ModBlocks;
import azmalent.terraincognita.common.registry.ModWoodTypes;
import azmalent.terraincognita.common.tile.BasketTileEntity;
import azmalent.terraincognita.common.tile.ModChestTileEntity;
import azmalent.terraincognita.common.tile.ModSignTileEntity;
import azmalent.terraincognita.common.tile.ModTrappedChestTileEntity;
import java.util.Arrays;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ModTileEntities {
    public static final DeferredRegister<TileEntityType<?>> TILE_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.TILE_ENTITIES, (String)"terraincognita");
    public static final RegistryObject<TileEntityType<ModChestTileEntity>> CHEST = ModTileEntities.register("chest", ModChestTileEntity::new, ModWoodTypes.getChests());
    public static final RegistryObject<TileEntityType<ModTrappedChestTileEntity>> TRAPPED_CHEST = ModTileEntities.register("trapped_chest", ModTrappedChestTileEntity::new, ModWoodTypes.getTrappedChests());
    public static final RegistryObject<TileEntityType<ModSignTileEntity>> SIGN = ModTileEntities.register("sign", ModSignTileEntity::new, ModWoodTypes.getSigns());
    public static final RegistryObject<TileEntityType<BasketTileEntity>> BASKET;

    private static <T extends TileEntity> RegistryObject<TileEntityType<T>> register(String id, Supplier<T> constructor, Supplier<Block> ... blockSuppliers) {
        return TILE_ENTITIES.register(id, () -> {
            Block[] blocks = (Block[])Arrays.stream(blockSuppliers).map(Supplier::get).toArray(Block[]::new);
            return TileEntityType.Builder.func_223042_a((Supplier)constructor, (Block[])blocks).func_206865_a(null);
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerRenderers() {
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)CHEST.get()), ModChestRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)TRAPPED_CHEST.get()), ModChestRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)SIGN.get()), ModSignRenderer::new);
    }

    static {
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = () -> ((BlockEntry)ModBlocks.BASKET).getBlock();
        BASKET = ModTileEntities.register("basket", BasketTileEntity::new, supplierArray);
    }
}

