/*
 * Decompiled with CFR 0.152.
 */
package azmalent.terraincognita.common.world;

import azmalent.terraincognita.common.integration.EnvironmentalIntegration;
import azmalent.terraincognita.common.registry.ModBlocks;
import azmalent.terraincognita.common.registry.ModFeatures;
import azmalent.terraincognita.common.world.ModConfiguredFeatures;
import azmalent.terraincognita.common.world.blockstateprovider.AlpineFlowerBlockStateProvider;
import azmalent.terraincognita.common.world.feature.AlpineFlowerFeature;
import azmalent.terraincognita.common.world.feature.SweetPeasFeature;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.DoublePlantBlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.WeightedBlockStateProvider;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.ConfiguredRandomFeatureList;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.FeatureSpread;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.MultipleRandomFeatureConfig;
import net.minecraft.world.gen.feature.SingleRandomFeature;

public class ModFlowerFeatures {
    public static ConfiguredFeature<?, ?> FOREST_FLOWERS;
    public static ConfiguredFeature<?, ?> SWAMP_FLOWERS;
    public static ConfiguredFeature<?, ?> ALPINE_FLOWERS;
    public static ConfiguredFeature<?, ?> SAVANNA_FLOWERS;
    public static ConfiguredFeature<?, ?> JUNGLE_FLOWERS;
    public static ConfiguredFeature<?, ?> ARCTIC_FLOWERS;
    public static ConfiguredFeature<?, ?> CACTUS_FLOWERS;
    public static ConfiguredFeature<?, ?> SWEET_PEAS;
    public static ConfiguredFeature<?, ?> LUSH_PLAINS_FLOWERS;
    public static ConfiguredFeature<?, ?> WITHER_ROSE;

    private static ConfiguredFeature<?, ?> initFlowerFeature(BlockClusterFeatureConfig config) {
        return (ConfiguredFeature)Feature.field_227247_y_.func_225566_b_((IFeatureConfig)config).func_227228_a_(Features.Placements.field_244000_k).func_227228_a_(Features.Placements.field_244001_l).func_242731_b(4);
    }

    private static ConfiguredFeature<?, ?> initTallFlowerFeature(BlockClusterFeatureConfig config, int min, int max) {
        return (ConfiguredFeature)((ConfiguredFeature)Feature.field_227248_z_.func_225566_b_((IFeatureConfig)config).func_242730_a(FeatureSpread.func_242253_a((int)min, (int)max))).func_227228_a_(Features.Placements.field_244000_k).func_227228_a_(Features.Placements.field_244001_l).func_242731_b(5);
    }

    private static ConfiguredFeature<?, ?> initSimpleRandomFeature(SingleRandomFeature config) {
        return (ConfiguredFeature)Feature.field_204620_ao.func_225566_b_((IFeatureConfig)config).func_227228_a_(Features.Placements.field_244000_k).func_227228_a_(Features.Placements.field_244001_l).func_242731_b(4);
    }

    public static void registerFeatures() {
        FOREST_FLOWERS = ModConfiguredFeatures.register("forest_flowers", ModFlowerFeatures.initFlowerFeature(Configs.FOREST_FLOWERS));
        SWAMP_FLOWERS = ModConfiguredFeatures.register("swamp_flowers", ModFlowerFeatures.initSimpleRandomFeature(Configs.SWAMP_FLOWERS));
        ALPINE_FLOWERS = ModConfiguredFeatures.register("alpine_flowers", (ConfiguredFeature)((AlpineFlowerFeature)ModFeatures.ALPINE_FLOWERS.get()).func_225566_b_((IFeatureConfig)Configs.ALPINE_FLOWERS).func_227228_a_(Features.Placements.field_244000_k).func_227228_a_(Features.Placements.field_244001_l).func_242731_b(4));
        SAVANNA_FLOWERS = ModConfiguredFeatures.register("savanna_flowers", ModFlowerFeatures.initSimpleRandomFeature(Configs.SAVANNA_FLOWERS));
        JUNGLE_FLOWERS = ModConfiguredFeatures.register("jungle_flowers", ModFlowerFeatures.initFlowerFeature(Configs.JUNGLE_FLOWERS));
        ARCTIC_FLOWERS = ModConfiguredFeatures.register("arctic_flowers", ModFlowerFeatures.initSimpleRandomFeature(Configs.ARCTIC_FLOWERS));
        CACTUS_FLOWERS = ModConfiguredFeatures.register("cactus_flowers", ModFlowerFeatures.initFlowerFeature(Configs.CACTUS_FLOWERS));
        SWEET_PEAS = ModConfiguredFeatures.register("sweet_peas", (ConfiguredFeature)((SweetPeasFeature)ModFeatures.SWEET_PEAS.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_242728_a());
        LUSH_PLAINS_FLOWERS = ModConfiguredFeatures.register("lush_plains_flowers", (ConfiguredFeature)Feature.field_202292_al.func_225566_b_((IFeatureConfig)Configs.LUSH_PLAINS_FLOWERS).func_227228_a_(Features.Placements.field_244000_k).func_227228_a_(Features.Placements.field_244001_l).func_242731_b(4));
        WITHER_ROSE = ModConfiguredFeatures.register("wither_rose", ModFlowerFeatures.initFlowerFeature(Configs.WITHER_ROSE));
    }

    public static class Configs {
        public static final BlockClusterFeatureConfig FOREST_FLOWERS = Configs.flowerConfig((BlockStateProvider)StateProviders.FOREST_FLOWERS, 16);
        public static BlockClusterFeatureConfig SWAMP_SMALL_FLOWERS = Configs.flowerConfig((BlockStateProvider)StateProviders.SWAMP_FLOWERS, 32);
        public static BlockClusterFeatureConfig WATER_FLAG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(States.WATER_FLAG), (BlockPlacer)DoublePlantBlockPlacer.field_236444_c_).func_227315_a_(24).func_227317_b_().func_227320_c_().func_227314_a_().func_227322_d_();
        public static SingleRandomFeature SWAMP_FLOWERS = new SingleRandomFeature((List)Lists.newArrayList((Object[])new Supplier[]{() -> ModFlowerFeatures.access$100(Configs.SWAMP_SMALL_FLOWERS), () -> ModFlowerFeatures.access$000(Configs.WATER_FLAG, -1, 4)}));
        public static BlockClusterFeatureConfig ALPINE_FLOWERS = Configs.flowerConfig(AlpineFlowerBlockStateProvider.INSTANCE, 32);
        public static BlockClusterFeatureConfig SAVANNA_SMALL_FLOWERS = Configs.flowerConfig((BlockStateProvider)StateProviders.SAVANNA_FLOWERS, 32);
        public static BlockClusterFeatureConfig SAVANNA_TALL_FLOWERS = new BlockClusterFeatureConfig.Builder((BlockStateProvider)StateProviders.SAVANNA_TALL_FLOWERS, (BlockPlacer)DoublePlantBlockPlacer.field_236444_c_).func_227315_a_(12).func_227317_b_().func_227322_d_();
        public static SingleRandomFeature SAVANNA_FLOWERS = new SingleRandomFeature((List)Lists.newArrayList((Object[])new Supplier[]{() -> ModFlowerFeatures.access$100(Configs.SAVANNA_SMALL_FLOWERS), () -> ModFlowerFeatures.access$000(Configs.SAVANNA_TALL_FLOWERS, -3, 4)}));
        public static BlockClusterFeatureConfig JUNGLE_FLOWERS = Configs.flowerConfig((BlockStateProvider)StateProviders.JUNGLE_FLOWERS, 64);
        public static BlockClusterFeatureConfig ARCTIC_SMALL_FLOWERS = Configs.flowerConfig((BlockStateProvider)StateProviders.ARCTIC_FLOWERS, 16);
        public static BlockClusterFeatureConfig ARCTIC_TALL_FLOWERS = new BlockClusterFeatureConfig.Builder((BlockStateProvider)StateProviders.ARCTIC_TALL_FLOWERS, (BlockPlacer)DoublePlantBlockPlacer.field_236444_c_).func_227315_a_(12).func_227317_b_().func_227322_d_();
        public static SingleRandomFeature ARCTIC_FLOWERS = new SingleRandomFeature((List)Lists.newArrayList((Object[])new Supplier[]{() -> ModFlowerFeatures.access$100(Configs.ARCTIC_SMALL_FLOWERS), () -> ModFlowerFeatures.access$000(Configs.ARCTIC_TALL_FLOWERS, -3, 4)}));
        public static BlockClusterFeatureConfig CACTUS_FLOWERS = Configs.flowerConfig((BlockStateProvider)new SimpleBlockStateProvider(States.CACTUS_FLOWER), 1024);
        public static BlockClusterFeatureConfig LUSH_PLAINS_TALL_FLOWERS = new BlockClusterFeatureConfig.Builder((BlockStateProvider)StateProviders.LUSH_PLAINS_TALL_FLOWERS, (BlockPlacer)DoublePlantBlockPlacer.field_236444_c_).func_227315_a_(12).func_227317_b_().func_227322_d_();
        public static MultipleRandomFeatureConfig LUSH_PLAINS_FLOWERS = new MultipleRandomFeatureConfig((List)Lists.newArrayList((Object[])new ConfiguredRandomFeatureList[]{Features.field_243930_cm.func_227227_a_(0.8f)}), ModFlowerFeatures.access$000(LUSH_PLAINS_TALL_FLOWERS, -2, 4));
        public static BlockClusterFeatureConfig WITHER_ROSE = Configs.flowerConfig((BlockStateProvider)new SimpleBlockStateProvider(States.WITHER_ROSE), 128);

        private static BlockClusterFeatureConfig flowerConfig(BlockStateProvider provider, int tries) {
            return new BlockClusterFeatureConfig.Builder(provider, (BlockPlacer)SimpleBlockPlacer.field_236447_c_).func_227315_a_(tries).func_227322_d_();
        }
    }

    public static class StateProviders {
        static final WeightedBlockStateProvider FOREST_FLOWERS = new WeightedBlockStateProvider().func_227407_a_(States.WILD_GARLIC, 2).func_227407_a_(States.FOXGLOVE, 2).func_227407_a_(States.YELLOW_PRIMROSE, 1).func_227407_a_(States.PINK_PRIMROSE, 1).func_227407_a_(States.PURPLE_PRIMROSE, 1);
        static final WeightedBlockStateProvider SWAMP_FLOWERS = new WeightedBlockStateProvider().func_227407_a_(States.FORGET_ME_NOT, 1).func_227407_a_(States.GLOBEFLOWER, 1);
        static final WeightedBlockStateProvider SAVANNA_FLOWERS = new WeightedBlockStateProvider().func_227407_a_(States.MARIGOLD, 2).func_227407_a_(States.BLUE_LUPINE, 3).func_227407_a_(States.GLADIOLUS, 1).func_227407_a_(States.SNAPDRAGON, 1).func_227407_a_(States.GERANIUM, 1);
        static final WeightedBlockStateProvider SAVANNA_TALL_FLOWERS = new WeightedBlockStateProvider().func_227407_a_(States.OLEANDER, 2).func_227407_a_(States.SAGE, 3);
        static final WeightedBlockStateProvider ARCTIC_FLOWERS = new WeightedBlockStateProvider().func_227407_a_(States.DWARF_FIREWEED, 2).func_227407_a_(States.WHITE_DRYAD, 3);
        static final WeightedBlockStateProvider ARCTIC_TALL_FLOWERS = new WeightedBlockStateProvider().func_227407_a_(States.FIREWEED, 2).func_227407_a_(States.WHITE_RHODODENDRON, 1);
        static final WeightedBlockStateProvider JUNGLE_FLOWERS = new WeightedBlockStateProvider().func_227407_a_(States.BLUE_IRIS, 1).func_227407_a_(States.PURPLE_IRIS, 1).func_227407_a_(States.BLACK_IRIS, 1);
        static final WeightedBlockStateProvider LUSH_PLAINS_TALL_FLOWERS = new WeightedBlockStateProvider().func_227407_a_(States.ROSE_BUSH, 2).func_227407_a_(States.PEONY, 2).func_227407_a_(States.LILAC, 2).func_227407_a_(States.SUNFLOWER, 2);

        static {
            EnvironmentalIntegration.addDelphiniums(LUSH_PLAINS_TALL_FLOWERS);
        }
    }

    public static class States {
        static final BlockState WILD_GARLIC = ModBlocks.WILD_GARLIC.getBlock().func_176223_P();
        static final BlockState FOXGLOVE = ModBlocks.FOXGLOVE.getBlock().func_176223_P();
        static final BlockState YELLOW_PRIMROSE = ModBlocks.YELLOW_PRIMROSE.getBlock().func_176223_P();
        static final BlockState PINK_PRIMROSE = ModBlocks.PINK_PRIMROSE.getBlock().func_176223_P();
        static final BlockState PURPLE_PRIMROSE = ModBlocks.PURPLE_PRIMROSE.getBlock().func_176223_P();
        static final BlockState FORGET_ME_NOT = ModBlocks.FORGET_ME_NOT.getBlock().func_176223_P();
        static final BlockState GLOBEFLOWER = ModBlocks.GLOBEFLOWER.getBlock().func_176223_P();
        static final BlockState WATER_FLAG = ModBlocks.WATER_FLAG.getBlock().func_176223_P();
        static final BlockState DWARF_FIREWEED = ModBlocks.DWARF_FIREWEED.getBlock().func_176223_P();
        static final BlockState WHITE_DRYAD = ModBlocks.WHITE_DRYAD.getBlock().func_176223_P();
        static final BlockState FIREWEED = ModBlocks.FIREWEED.getBlock().func_176223_P();
        static final BlockState WHITE_RHODODENDRON = ModBlocks.WHITE_RHODODENDRON.getBlock().func_176223_P();
        static final BlockState MARIGOLD = ModBlocks.MARIGOLD.getBlock().func_176223_P();
        static final BlockState BLUE_LUPINE = ModBlocks.BLUE_LUPINE.getBlock().func_176223_P();
        static final BlockState SNAPDRAGON = ModBlocks.SNAPDRAGON.getBlock().func_176223_P();
        static final BlockState GLADIOLUS = ModBlocks.GLADIOLUS.getBlock().func_176223_P();
        static final BlockState GERANIUM = ModBlocks.GERANIUM.getBlock().func_176223_P();
        static final BlockState OLEANDER = ModBlocks.OLEANDER.getBlock().func_176223_P();
        static final BlockState SAGE = ModBlocks.SAGE.getBlock().func_176223_P();
        static final BlockState BLUE_IRIS = ModBlocks.BLUE_IRIS.getBlock().func_176223_P();
        static final BlockState PURPLE_IRIS = ModBlocks.PURPLE_IRIS.getBlock().func_176223_P();
        static final BlockState BLACK_IRIS = ModBlocks.BLACK_IRIS.getBlock().func_176223_P();
        static final BlockState CACTUS_FLOWER = ModBlocks.CACTUS_FLOWER.getBlock().func_176223_P();
        static final BlockState ROSE_BUSH = Blocks.field_196802_gf.func_176223_P();
        static final BlockState PEONY = Blocks.field_196803_gg.func_176223_P();
        static final BlockState LILAC = Blocks.field_196801_ge.func_176223_P();
        static final BlockState SUNFLOWER = Blocks.field_196800_gd.func_176223_P();
        static final BlockState WITHER_ROSE = Blocks.field_222388_bz.func_176223_P();
    }
}

