/*
 * Decompiled with CFR 0.152.
 */
package azmalent.terraincognita.common.world.feature;

import azmalent.terraincognita.common.block.plants.CaribouMossWallBlock;
import azmalent.terraincognita.common.registry.ModBlocks;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class FallenLogFeature
extends Feature<NoFeatureConfig> {
    public FallenLogFeature() {
        super(NoFeatureConfig.field_236558_a_);
    }

    public boolean generate(@Nonnull ISeedReader reader, @Nonnull ChunkGenerator generator, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull NoFeatureConfig config) {
        boolean success = false;
        int length = 5 + rand.nextInt(3);
        Direction direction = Direction.Plane.HORIZONTAL.func_179518_a(rand);
        BlockState log = (BlockState)(rand.nextFloat() < 0.66f ? Blocks.field_196618_L : Blocks.field_196619_M).func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)direction.func_176740_k());
        boolean mossy = rand.nextBoolean();
        BlockPos.Mutable nextPos = pos.func_239590_i_();
        for (int i = 0; i < length; ++i) {
            if (reader.func_175623_d((BlockPos)nextPos) && FallenLogFeature.func_236293_a_((IWorldGenerationBaseReader)reader, (BlockPos)nextPos.func_177977_b())) {
                reader.func_180501_a((BlockPos)nextPos, log, 2);
                if (mossy) {
                    this.placeCaribouMossOnLog(reader, (BlockPos)nextPos, direction, rand);
                }
                success = true;
            }
            nextPos.func_189536_c(direction);
        }
        return success;
    }

    private void placeCaribouMossOnLog(ISeedReader reader, BlockPos pos, Direction logDirection, Random rand) {
        BlockPos up = pos.func_177984_a();
        if (reader.func_175623_d(up) && rand.nextFloat() < 0.66f) {
            BlockState moss = ModBlocks.CARIBOU_MOSS.getBlock().func_176223_P();
            reader.func_180501_a(up, moss, 2);
        }
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos sidePos = pos.func_177972_a(direction);
            if (direction.func_176740_k() == logDirection.func_176740_k() || !reader.func_175623_d(sidePos) || !((double)rand.nextFloat() < 0.66)) continue;
            BlockState moss = ModBlocks.CARIBOU_MOSS_WALL.getDefaultState();
            reader.func_180501_a(sidePos, (BlockState)moss.func_206870_a((Property)CaribouMossWallBlock.FACING, (Comparable)direction), 2);
        }
    }
}

