/*
 * Decompiled with CFR 0.152.
 */
package azmalent.terraincognita.mixin;

import azmalent.terraincognita.TIConfig;
import azmalent.terraincognita.common.registry.ModBlocks;
import azmalent.terraincognita.common.registry.ModItems;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CactusBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.Tags;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CactusBlock.class})
public abstract class CactusBlockMixin
extends Block {
    public CactusBlockMixin(AbstractBlock.Properties properties) {
        super(properties);
    }

    private boolean isCactus(BlockState state) {
        return state.func_203425_a(Blocks.field_150434_aF) || state.func_177230_c() == ModBlocks.SMOOTH_CACTUS.getBlock();
    }

    private int getHeight(ServerWorld world, BlockPos pos) {
        int height = 1;
        while (this.isCactus(world.func_180495_p(pos.func_177979_c(height)))) {
            ++height;
        }
        return height;
    }

    private int getMaxHeight(BlockPos pos) {
        if (TIConfig.Misc.plantHeightVariation.get().booleanValue()) {
            return new Random(pos.func_218275_a()).nextInt(3) + 2;
        }
        return 3;
    }

    private void grow(ServerWorld world, BlockPos pos, BlockPos up) {
        BlockState cactus = Blocks.field_150434_aF.func_176223_P();
        world.func_180501_a(pos, cactus, 4);
        world.func_175656_a(up, cactus);
        cactus.func_215697_a((World)world, up, Blocks.field_150434_aF, pos, false);
    }

    private boolean canGrowFlower(ServerWorld world, BlockPos pos, Random random) {
        if (!TIConfig.Flora.cactusFlowers.get().booleanValue()) {
            return false;
        }
        return random.nextInt(300) == 0 && world.func_175710_j(pos);
    }

    @Inject(method={"randomTick"}, at={@At(value="HEAD")}, cancellable=true)
    private void randomTick(BlockState state, ServerWorld worldIn, BlockPos pos, Random random, CallbackInfo ci) {
        int height = this.getHeight(worldIn, pos);
        int maxHeight = this.getMaxHeight(pos);
        int age = (Integer)state.func_177229_b((Property)CactusBlock.field_176587_a);
        BlockPos up = pos.func_177984_a();
        if (worldIn.func_175623_d(up)) {
            if (ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)up, (BlockState)state, (boolean)true)) {
                if (age == 15) {
                    if (height < maxHeight) {
                        this.grow(worldIn, pos, up);
                    }
                } else if (this.canGrowFlower(worldIn, pos, random)) {
                    worldIn.func_175656_a(up, ModBlocks.CACTUS_FLOWER.getBlock().func_176223_P());
                } else {
                    worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)CactusBlock.field_176587_a, (Comparable)Integer.valueOf(age + 1)), 4);
                }
                ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (BlockState)state);
            }
        } else if (worldIn.func_180495_p(up).func_177230_c() == ModBlocks.CACTUS_FLOWER.getBlock() && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)up, (BlockState)state, (boolean)true)) {
            BlockPos up2 = up.func_177984_a();
            if (worldIn.func_175623_d(up2) && up2.func_177956_o() < 255 && height < maxHeight) {
                if (age == 15) {
                    this.grow(worldIn, pos, up);
                    worldIn.func_175656_a(up2, ModBlocks.CACTUS_FLOWER.getBlock().func_176223_P());
                } else {
                    worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)CactusBlock.field_176587_a, (Comparable)Integer.valueOf(age + 1)), 4);
                }
            }
            ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (BlockState)state);
        }
        ci.cancel();
    }

    @Nonnull
    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack shears = player.func_184586_b(handIn);
        if (this == Blocks.field_150434_aF && shears.func_77973_b().func_206844_a((ITag)Tags.Items.SHEARS)) {
            worldIn.func_175656_a(pos, ModBlocks.SMOOTH_CACTUS.getDefaultState());
            worldIn.func_184148_a(player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187763_eJ, SoundCategory.BLOCKS, 1.0f, 1.0f);
            CactusBlockMixin.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)ModItems.CACTUS_NEEDLE.get(), 1 + worldIn.field_73012_v.nextInt(2)));
            shears.func_222118_a(1, (LivingEntity)player, playerEntity -> playerEntity.func_213334_d(handIn));
            return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
        }
        return ActionResultType.PASS;
    }
}

