/*
 * Decompiled with CFR 0.152.
 */
package azmalent.terraincognita.util;

import azmalent.cuneiform.lib.util.BiomeUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.common.world.MobSpawnInfoBuilder;
import net.minecraftforge.fml.RegistryObject;

public class WorldGenUtil {
    public static Biome.Category getProperBiomeCategory(Biome biome) {
        Biome.Category category = biome.func_201856_r();
        RegistryKey key = BiomeUtil.getBiomeKey((Biome)biome);
        if (category == Biome.Category.PLAINS) {
            if (BiomeDictionary.hasType((RegistryKey)key, (BiomeDictionary.Type)BiomeDictionary.Type.COLD)) {
                return Biome.Category.ICY;
            }
        } else if (category == Biome.Category.FOREST) {
            if (BiomeUtil.hasAnyType((RegistryKey)key, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.HOT})) {
                return Biome.Category.JUNGLE;
            }
            if (BiomeDictionary.hasType((RegistryKey)key, (BiomeDictionary.Type)BiomeDictionary.Type.COLD)) {
                return Biome.Category.TAIGA;
            }
        }
        return category;
    }

    public static <T extends Entity> void addSpawner(MobSpawnInfoBuilder spawns, RegistryObject<EntityType<T>> entityType, EntityClassification classification, int weight, int minCount, int maxCount) {
        if (weight > 0) {
            spawns.func_242575_a(classification, new MobSpawnInfo.Spawners((EntityType)entityType.get(), weight, minCount, maxCount));
        }
    }

    public static void addVegetation(BiomeGenerationSettingsBuilder builder, ConfiguredFeature<?, ?> ... features) {
        for (ConfiguredFeature<?, ?> feature : features) {
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, feature);
        }
    }

    public static void addOre(BiomeGenerationSettingsBuilder builder, ConfiguredFeature<?, ?> ... features) {
        for (ConfiguredFeature<?, ?> feature : features) {
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, feature);
        }
    }

    public static void addModification(BiomeGenerationSettingsBuilder builder, ConfiguredFeature<?, ?> ... features) {
        for (ConfiguredFeature<?, ?> feature : features) {
            builder.func_242513_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, feature);
        }
    }
}

